/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.perf;

import com.ibm.safe.perf.NamedTimer;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.perf.TimeoutStopwatch;
import com.ibm.safe.reporting.message.AggregateSolverResult;
import com.ibm.safe.reporting.message.ISolverResult;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Map;

public final class SolverPerfTracker
extends PerformanceTracker {
    private Map<String, Integer> solverTotalInstances = HashMapFactory.make();
    private Map<String, Integer> solverProcessedInstances = HashMapFactory.make();

    public SolverPerfTracker(String trackerName, PerformanceTracker.Kind trackerKind) {
        super(trackerName, trackerKind);
    }

    public int getProcessedInstances(String trackerName) {
        Integer value = this.solverProcessedInstances.get(trackerName);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public int getTotalInstances(String trackerName) {
        Integer value = this.solverTotalInstances.get(trackerName);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void stopTracking(String timerName, ISolverResult result) {
        super.stopTracking(timerName);
        this.updateProgress(timerName, result);
    }

    public void timeout(String timerName, ISolverResult result) {
        TimeoutStopwatch current = (TimeoutStopwatch)this.timers.get(timerName);
        assert (current != null);
        current.timeout();
        this.updateProgress(timerName, result);
    }

    @Override
    protected NamedTimer createTimerInstance(String timerName) {
        return new TimeoutStopwatch(timerName);
    }

    private void updateProgress(String timerName, ISolverResult result) {
        if (result instanceof AggregateSolverResult && result != null) {
            AggregateSolverResult r = (AggregateSolverResult)result;
            this.solverTotalInstances.put(timerName, r.totalInstancesNum());
            this.solverProcessedInstances.put(timerName, r.processedInstancesNum());
        }
    }
}

