/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.options;

import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.wala.util.debug.Assertions;

public class WholeProgramProperties {
    public static void register() {
        PropertiesManager.registerProperties(Props.values());
        CommonProperties.register();
    }

    public static enum Props implements PropertiesManager.IPropertyDescriptor
    {
        ALL_MAIN_CLASSES_ENTRY_POINT("all_main_classes_entry_point", PropertiesManager.Type.BOOLEAN, "Takes all main classes as entry points."),
        CG_KIND("cg_kind", PropertiesManager.Type.STRING, "ZERO_ONE_CUSTOM", "Specifies kind of call graph to build for typestate analysis."),
        ENTRY_POINTS("entry_points", PropertiesManager.Type.STRING, "Specifies a list of entry points for the analysis."),
        ENTRY_POINTS_FILE("entry_points_file", PropertiesManager.Type.STRING, "Specifies an XML file where some end-user entry points are defined."),
        GENERATE_WITNESS("generate_witness", PropertiesManager.Type.BOOLEAN, ""),
        LIVE_ANALYSIS("live_analysis", PropertiesManager.Type.BOOLEAN, true, ""),
        CONTRADICTION_ANALYSIS("contradiction_analysis", PropertiesManager.Type.BOOLEAN, false, "Perform contradiction analysis."),
        POINTS_TO_GRAPH("points_to_graph", PropertiesManager.Type.STRING, "Outputs points-to graph"),
        REPORT_CALL_GRAPH("report_call_graph", PropertiesManager.Type.BOOLEAN, "Outputs or not the call graph."),
        SELECT_MAIN_CLASSES("select_main_classes", PropertiesManager.Type.STRING, "Filters some main classes among the ones automatically detected."),
        SLICE_SUPERGRAPH("slice_supergraph", PropertiesManager.Type.BOOLEAN, "Enable supergraph slicing.");

        private final String name;
        private final boolean cmdLine;
        private final PropertiesManager.Type type;
        private final String defaultString;
        private final String description;

        private Props(String name, PropertiesManager.Type type, String defaultString, String description) {
            this.name = name;
            this.type = type;
            this.cmdLine = true;
            this.defaultString = defaultString;
            this.description = description;
        }

        private Props(String name, PropertiesManager.Type type, boolean defaultBoolean, String description) {
            this(name, type, defaultBoolean ? "true" : "false", description);
        }

        private Props(String name, PropertiesManager.Type type, String description) {
            this.name = name;
            this.type = type;
            this.cmdLine = true;
            this.description = description;
            switch (type) {
                case BOOLEAN: {
                    this.defaultString = "false";
                    break;
                }
                case INT: {
                    this.defaultString = null;
                    break;
                }
                case STRING: {
                    this.defaultString = null;
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                    this.defaultString = null;
                }
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isCommandLineOption() {
            return this.cmdLine;
        }

        @Override
        public PropertiesManager.Type getType() {
            return this.type;
        }

        @Override
        public String getDefaultAsString() {
            return this.defaultString;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

