/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.options;

import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.runners.AbstractSolverRunner;
import com.ibm.safe.internal.runners.RuntimeDirWalkVisitor;
import com.ibm.safe.options.ByteCodeFilter;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.utils.DirectoryWalk;
import com.ibm.safe.utils.IDirectoryWalkVisitor;
import com.ibm.safe.utils.SafeHome;
import com.ibm.safe.utils.SafeLogger;
import com.ibm.wala.classLoader.ClassFileModule;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.ide.util.EclipseProjectPath;
import com.ibm.wala.ide.util.JavaEclipseProjectPath;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class CommonOptions
extends PropertiesManager {
    static final String CLASS_EXT = ".class";
    static final String JAR_EXT = ".jar";
    static final String EAR_EXT = ".ear";
    static final String WAR_EXT = ".war";
    static final String RAR_EXT = ".rar";
    private AnalysisScope scope;
    private FileProvider fp = new FileProvider();
    private static final String SAFE_EXCLUSIONS = "SafeClassHierarchyExclusions.txt";

    public CommonOptions(PropertiesManager p) {
        super(p);
    }

    public AnalysisScope getOrCreateAnalysisScope() throws PropertiesException, IOException, CoreException {
        if (this.scope == null) {
            if (this.getStringValue(CommonProperties.Props.PROJECT) != null) {
                this.scope = this.createEclipseAnalyseScope();
            } else {
                String exclusionFile;
                String string = this.isNoExclusion() ? null : (exclusionFile = this.specificExclusionFile() == null ? SAFE_EXCLUSIONS : this.specificExclusionFile());
                if (this.getBooleanValue(CommonProperties.Props.J2EE)) {
                    return null;
                }
                this.scope = AnalysisScopeReader.makePrimordialScope((File)this.fp.getFile(exclusionFile));
                Module[] moduleArray = this.getStandardLibraries(CommonProperties.Props.J2SE_DIR);
                int n = moduleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Module jarFileModule = moduleArray[n2];
                    this.scope.addToScope(ClassLoaderReference.Primordial, jarFileModule);
                    ++n2;
                }
                Collection<Module> appModules = this.collectModules(this.getAppropriateClassLoader(), this.getModules(), this.getAutoSearchDirectories());
                for (Module module : appModules) {
                    this.scope.addToScope(ClassLoaderReference.Application, module);
                }
            }
        }
        return this.scope;
    }

    private final boolean isNoExclusion() throws PropertiesException {
        return this.getBooleanValue(CommonProperties.Props.NO_EXCLUSIONS);
    }

    private final String specificExclusionFile() throws PropertiesException {
        return this.getStringValue(CommonProperties.Props.EXCLUSION_FILE);
    }

    public final boolean isVerboseMode() throws PropertiesException {
        return this.getBooleanValue(CommonProperties.Props.VERBOSE);
    }

    public final boolean shouldUsePerfomanceTracker() throws PropertiesException {
        return this.getBooleanValue(CommonProperties.Props.PERFORMANCE_TRACKING);
    }

    public int getMaxFindingsPerRule() throws PropertiesException {
        return this.getIntValue(CommonProperties.Props.MAX_FINDINGS_PER_RULE);
    }

    public String getShortProgramName() throws PropertiesException {
        return this.getStringValue(CommonProperties.Props.SHORT_PROGRAM_NAME);
    }

    public boolean analyzeDependentJars() throws PropertiesException {
        return this.getBooleanValue(CommonProperties.Props.ANALYZE_DEPENDENT_JARS);
    }

    public boolean isClosedWorld() throws PropertiesException {
        return this.getBooleanValue(CommonProperties.Props.CLOSE_WORLD);
    }

    public boolean isJ2EEOptionsActivated() throws PropertiesException {
        return this.isClosedWorld() || this.analyzeDependentJars();
    }

    public String[] getMainClasses() throws PropertiesException {
        String mainClassesOption = this.getStringValue(CommonProperties.Props.MAIN_CLASSES);
        if (mainClassesOption == null) {
            return null;
        }
        String[] mainClasses = mainClassesOption.split("[,;]\\s*");
        if (mainClasses.length == 0) {
            SafeLogger.severe("Unable to identify main Java classes with 'main_classes' option.");
        }
        return mainClasses;
    }

    public final String[] getModules() throws PropertiesException {
        String modules = this.getStringValue(CommonProperties.Props.MODULES);
        if (modules == null && this.getStringValue(CommonProperties.Props.AUTO_SEARCH_IN_DIRS) == null) {
            throw new PropertiesException("At least one of '-modules' and '-auto_search_in_dirs' options has to be used.");
        }
        return modules == null ? new String[]{} : modules.split("[,;]\\s*");
    }

    private AnalysisScope createEclipseAnalyseScope() throws PropertiesException, IOException, CoreException {
        String projectName = this.getStringValue(CommonProperties.Props.PROJECT);
        if (projectName == null) {
            throw new InvalidParameterException("'project' option should be initialized/provided when you use 'workspace' option.");
        }
        IJavaProject project = this.getJavaProject(projectName);
        JavaEclipseProjectPath epPath = JavaEclipseProjectPath.make((IJavaProject)project, (EclipseProjectPath.AnalysisScopeType)EclipseProjectPath.AnalysisScopeType.SOURCE_FOR_PROJ);
        return this.mergeProjectPaths(Collections.singleton(epPath));
    }

    private Collection<Module> collectModules(ClassLoader classLoader, String[] modules, String[] searchingDirs) throws PropertiesException {
        LinkedList<Module> allModules = new LinkedList<Module>();
        this.loadModulesSpecified(classLoader, modules, allModules, searchingDirs.length > 0);
        this.searchModulesToLoad(classLoader, searchingDirs, allModules);
        if (allModules.isEmpty()) {
            throw new PropertiesException("None of the elements listed from '-modules' parameter had been loaded. Please, check classpath.");
        }
        return allModules;
    }

    private AnalysisScope mergeProjectPaths(Collection<JavaEclipseProjectPath> projectPaths) throws IOException {
        AnalysisScope scope = AnalysisScope.createJavaAnalysisScope();
        HashSet seen = HashSetFactory.make();
        this.buildScope(ClassLoaderReference.Application, projectPaths, scope, seen);
        this.buildScope(ClassLoaderReference.Extension, projectPaths, scope, seen);
        this.buildScope(ClassLoaderReference.Primordial, projectPaths, scope, seen);
        return scope;
    }

    private void buildScope(ClassLoaderReference loader, Collection<JavaEclipseProjectPath> projectPaths, AnalysisScope scope, Collection<Module> seen) throws IOException {
        for (EclipseProjectPath eclipseProjectPath : projectPaths) {
            AnalysisScope pScope = eclipseProjectPath.toAnalysisScope();
            for (Module m : pScope.getModules(loader)) {
                if (seen.contains(m)) continue;
                seen.add(m);
                scope.addToScope(loader, m);
            }
        }
    }

    private ClassLoader getAppropriateClassLoader() throws PropertiesException {
        ClassLoader defaultClassLoader = AbstractSolverRunner.class.getClassLoader();
        if (this.getPathValue(CommonProperties.Props.MODULES_DIRS) != null) {
            String modulesDirsOpt = this.getPathValue(CommonProperties.Props.MODULES_DIRS);
            return this.getNewClassLoader(modulesDirsOpt.split("[,;]\\s*"), defaultClassLoader);
        }
        return defaultClassLoader;
    }

    private String[] getAutoSearchDirectories() throws PropertiesException {
        String searchingDirs = this.getStringValue(CommonProperties.Props.AUTO_SEARCH_IN_DIRS);
        return searchingDirs == null ? new String[]{} : searchingDirs.split("[,;]\\s*");
    }

    private File getFile(ClassLoader classLoader, String fileName) throws IOException {
        URL url = classLoader.getResource(fileName);
        if (url != null) {
            return new File(url.getFile());
        }
        File file = new File(fileName);
        if (file.isAbsolute()) {
            if (file.exists()) {
                return file;
            }
            throw new IOException("Module name given via absolute path " + fileName + " is wrong.");
        }
        File f = new File(System.getProperty("user.dir"), fileName);
        if (f.exists()) {
            return f;
        }
        throw new IOException("Unable to access via given classpath to " + fileName + " file.");
    }

    private IJavaProject getJavaProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject javaProject = JavaCore.create((IProject)root.getProject(projectName));
        if (javaProject == null) {
            throw new InvalidParameterException("We could not find project '" + projectName + "' withing workspace provided.");
        }
        return javaProject;
    }

    private ClassLoader getNewClassLoader(String[] modulesDirs, ClassLoader parentClassLoader) {
        ArrayList<URL> urls = new ArrayList<URL>(modulesDirs.length);
        boolean oneValidURL = false;
        String safeHomeDir = SafeHome.getSafeHomeDir(this.getClass().getClassLoader());
        int i = 0;
        while (i < modulesDirs.length) {
            try {
                File dir = new File(modulesDirs[i]);
                if (!dir.isAbsolute()) {
                    dir = new File(safeHomeDir, modulesDirs[i]);
                }
                if (!dir.exists()) {
                    SafeLogger.severe("Directory " + modulesDirs[i] + " specified from -modules_dirs option does not exist.");
                } else if (!dir.isDirectory()) {
                    SafeLogger.severe("Element " + modulesDirs[i] + "(from -modules_dirs option) doesn't represent a directory.");
                } else {
                    urls.add(dir.toURI().toURL());
                    oneValidURL = true;
                }
            }
            catch (MalformedURLException except) {
                SafeLogger.severe("Directory " + modulesDirs[i] + " can't be converted to a valid file URL (Internal Error).", except);
            }
            ++i;
        }
        return oneValidURL ? new URLClassLoader(urls.toArray(new URL[urls.size()]), parentClassLoader) : parentClassLoader;
    }

    private Module[] getStandardLibraries(PropertiesManager.IPropertyDescriptor d) throws PropertiesException {
        String directory = this.getPathValue(d);
        if (directory == null) {
            throw new PropertiesException("Reading of " + d.getName() + " property failed. Value must be set for this variable in properties file.");
        }
        File dirFile = new File(directory);
        if (!dirFile.exists()) {
            throw new PropertiesException("Directory " + dirFile.getPath() + " specified for " + d.getName() + " property does not exist.");
        }
        Stack<Module> jarFiles = new Stack<Module>();
        DirectoryWalk.walk(dirFile, new JarFileFilter(), (IDirectoryWalkVisitor)new RuntimeDirWalkVisitor(jarFiles));
        if (jarFiles.size() == 0) {
            SafeLogger.warning("No jars files detected from directory " + dirFile.getPath() + " for " + d.getName() + " property.");
        }
        return jarFiles.toArray(new Module[jarFiles.size()]);
    }

    private boolean isJ2EEModule(String module) throws PropertiesException {
        boolean isJ2EECode = this.getBooleanValue(CommonProperties.Props.J2EE);
        return isJ2EECode || module.endsWith(EAR_EXT) || module.endsWith(WAR_EXT) || module.endsWith(RAR_EXT);
    }

    private void loadModulesSpecified(ClassLoader classLoader, String[] modules, Collection<Module> allModules, boolean autoSearchInDirs) throws PropertiesException {
        int i = 0;
        while (i < modules.length) {
            block11: {
                if (this.isJ2EEModule(modules[i])) {
                    return;
                }
                if (modules[i].endsWith(CLASS_EXT)) {
                    try {
                        allModules.add((Module)new ClassFileModule(this.getFile(classLoader, modules[i]), null));
                    }
                    catch (IOException except) {
                        if (!autoSearchInDirs) {
                            SafeLogger.severe("Unable to add " + modules[i] + " class file in modules from string given.", except);
                        }
                    }
                    catch (InvalidClassFileException e) {
                        e.printStackTrace();
                    }
                } else if (modules[i].endsWith(JAR_EXT)) {
                    try {
                        allModules.add((Module)new JarFileModule(new JarFile(this.getFile(classLoader, modules[i]))));
                    }
                    catch (IOException except) {
                        if (autoSearchInDirs) break block11;
                        SafeLogger.severe("Unable to add " + modules[i] + " jar file in modules from string given.", except);
                    }
                }
            }
            ++i;
        }
    }

    private void searchModulesToLoad(ClassLoader classLoader, String[] searchingDirs, Collection<Module> allModules) {
        ByteCodeFilter byteCodeFilter = new ByteCodeFilter();
        DirectoryWalkVisitor walkVisitor = new DirectoryWalkVisitor(allModules);
        int i = 0;
        while (i < searchingDirs.length) {
            try {
                File dir = this.getFile(classLoader, searchingDirs[i]);
                DirectoryWalk.walk(dir, byteCodeFilter, (IDirectoryWalkVisitor)walkVisitor);
            }
            catch (IOException except) {
                SafeLogger.severe("Unable to add searching directory " + searchingDirs[i] + " in the list of research.", except);
            }
            ++i;
        }
    }

    private static final class DirectoryWalkVisitor
    implements IDirectoryWalkVisitor {
        private final Collection<Module> modules;

        DirectoryWalkVisitor(Collection<Module> theModules) {
            this.modules = theModules;
        }

        @Override
        public void visitDirectory(File directory) {
        }

        @Override
        public void visitFile(File file) {
            if (file.getName().endsWith(CommonOptions.CLASS_EXT)) {
                System.out.println(String.valueOf(file.getName()) + " found.");
                try {
                    this.modules.add((Module)new ClassFileModule(file, null));
                }
                catch (InvalidClassFileException e) {
                    e.printStackTrace();
                }
            } else if (file.getName().endsWith(CommonOptions.JAR_EXT)) {
                try {
                    this.modules.add((Module)new JarFileModule(new JarFile(file)));
                    System.out.println(String.valueOf(file.getName()) + " found.");
                }
                catch (IOException except) {
                    SafeLogger.warning("Unable to add " + file.getName() + " jar file in modules from string given.", except);
                }
            } else {
                return;
            }
        }
    }

    private static final class JarFileFilter
    implements FileFilter {
        private JarFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(CommonOptions.JAR_EXT);
        }
    }
}

