/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ZipUtils {
    private static final int BUFFER_SIZE = 2048;

    public static void uncompress(String zipFileName, String directory) throws IOException {
        ZipEntry entry;
        ZipInputStream zipIs = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFileName)));
        byte[] data = new byte[2048];
        while ((entry = zipIs.getNextEntry()) != null) {
            int count;
            File file = new File(directory, entry.getName());
            if (!ZipUtils.meetRequirements(file)) continue;
            BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(file), 2048);
            while ((count = zipIs.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zipIs.close();
    }

    private static boolean meetRequirements(File file) {
        assert (file != null);
        File parentFile = file.getParentFile();
        assert (parentFile != null);
        return !file.exists() && (parentFile.exists() || parentFile.mkdirs());
    }
}

