/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.io;

import com.ibm.safe.utils.Trace;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.FileWriter;
import java.util.Iterator;

public class DotWriter {
    public static void write(String fileName, PointerAnalysis pai) {
        StringBuffer dotStringBuffer = DotWriter.dotOutput(pai);
        try {
            FileWriter fw = new FileWriter(fileName, false);
            fw.write(dotStringBuffer.toString());
            fw.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing dot file");
        }
    }

    public static StringBuffer dotOutput(PointerAnalysis pai) {
        StringBuffer result = new StringBuffer("digraph \"PointsTo Graph\" {\n");
        result.append("rankdir=LR;center=true;fontsize=12;node [fontsize=12];edge [fontsize=12]; \n");
        for (PointerKey p : pai.getPointerKeys()) {
            result.append("   ").append(DotWriter.dotOutput(p, false));
            result.append(" [color=\"green\"] \n");
        }
        for (PointerKey p : pai.getPointerKeys()) {
            OrdinalSet O = pai.getPointsToSet(p);
            if (O.size() == 0) continue;
            Iterator it2 = O.iterator();
            while (it2.hasNext()) {
                result.append("     ");
                result.append(DotWriter.dotOutput(p, true));
                result.append(" -> ");
                result.append(DotWriter.dotOutput(it2.next(), true));
                result.append(" \n");
            }
        }
        result.append("\n}");
        return result;
    }

    public static StringBuffer dotOutput(LocalPointerKey lpk, boolean edgeLabel) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(DotWriter.dotOutput(lpk.getNode(), edgeLabel));
        result.append(",v ");
        result.append(lpk.getValueNumber());
        result.append("\"");
        return result;
    }

    public static StringBuffer dotOutput(ReturnValueKey rvk, boolean edgeLabel) {
        StringBuffer result = new StringBuffer();
        result.append("\" ");
        result.append(rvk.getNode().getMethod().getName());
        result.append(" \"");
        return result;
    }

    public static StringBuffer dotOutput(PropagationCallGraphBuilder.TypedPointerKey tpk, boolean edgeLabel) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(tpk.getBase().toString().substring(10));
        result.append("T ");
        result.append(tpk.getTypeFilter().toString().substring(10));
        result.append("\"");
        return result;
    }

    public static StringBuffer dotOutput(ConcreteTypeKey ctk, boolean edgeLabel) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(ctk.getType());
        result.append("\"");
        return result;
    }

    public static StringBuffer dotOutput(ExceptionReturnValueKey ervk, boolean edgeLabel) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append("ERV ");
        result.append(ervk.getNode().getMethod().getReference().getName());
        result.append("\"");
        return result;
    }

    public static StringBuffer dotOutput(AllocationSiteInNode nask, boolean edgeLabel) {
        StringBuffer result = new StringBuffer();
        CGNode node = nask.getNode();
        result.append("\"");
        result.append("ST ");
        result.append(node.getMethod().getName());
        result.append(nask.getSite());
        result.append(" in " + node.getContext());
        result.append("\"");
        return result;
    }

    public static StringBuffer dotOutput(ArrayContentsKey aik, boolean edgeLabel) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(aik.getClass());
        result.append("\"");
        return result;
    }

    public static StringBuffer dotOutput(InstanceFieldKey ifk, boolean edgeLabel) {
        StringBuffer result = new StringBuffer();
        result.append("\" ");
        result.append(ifk.getField());
        result.append(" \"");
        return result;
    }

    public static StringBuffer dotOutput(CGNode node, boolean edgeLabel) {
        StringBuffer result = new StringBuffer();
        result.append(node.getMethod().getSignature());
        return result;
    }

    public static StringBuffer dotOutput(Object o, boolean edgeLabel) {
        if (o instanceof LocalPointerKey) {
            return DotWriter.dotOutput((LocalPointerKey)o, edgeLabel);
        }
        if (o instanceof AllocationSiteInNode) {
            return DotWriter.dotOutput((AllocationSiteInNode)o, edgeLabel);
        }
        if (o instanceof PropagationCallGraphBuilder.TypedPointerKey) {
            return DotWriter.dotOutput((PropagationCallGraphBuilder.TypedPointerKey)o, edgeLabel);
        }
        if (o instanceof ConcreteTypeKey) {
            return DotWriter.dotOutput((ConcreteTypeKey)o, edgeLabel);
        }
        if (o instanceof ExceptionReturnValueKey) {
            return DotWriter.dotOutput((ExceptionReturnValueKey)o, edgeLabel);
        }
        if (o instanceof ArrayContentsKey) {
            return DotWriter.dotOutput((ArrayContentsKey)o, edgeLabel);
        }
        if (o instanceof InstanceFieldKey) {
            return DotWriter.dotOutput((InstanceFieldKey)o, edgeLabel);
        }
        if (o instanceof ReturnValueKey) {
            return DotWriter.dotOutput((ReturnValueKey)o, edgeLabel);
        }
        if (o instanceof CGNode) {
            return DotWriter.dotOutput((CGNode)o, edgeLabel);
        }
        Trace.println("Object of class " + o.getClass() + " has no dot representation");
        return new StringBuffer();
    }
}

