/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.internal.runners;

import com.ibm.safe.callgraph.CallGraphEngine;
import com.ibm.safe.internal.entrypoints.EntryPointDefinition;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.runners.AbstractSolverRunner;
import com.ibm.safe.options.CommonOptions;
import com.ibm.safe.options.WholeProgramOptions;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.runners.IResultObserver;
import com.ibm.wala.util.CancelException;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;

public class WholeProgramSolverRunner
extends AbstractSolverRunner {
    public WholeProgramSolverRunner(PropertiesManager thePropertiesManager, PerformanceTracker performanceTracker, IReporter safeReporter) {
        super(thePropertiesManager, performanceTracker, safeReporter);
    }

    @Override
    public void run(IResultObserver observer, IProgressMonitor monitor) throws SafeException, CancelException, IllegalArgumentException, CoreException {
    }

    protected CallGraphEngine createCallGraphEngine(IProgressMonitor monitor) throws PropertiesException, SetUpException, CoreException {
        CommonOptions commonOptions = this.getCommonOptions();
        AbstractSolverRunner.CodeKind modulesCodeKind = null;
        try {
            modulesCodeKind = this.getModulesCodeKind(commonOptions);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (modulesCodeKind == AbstractSolverRunner.CodeKind.J2SE_J2EE_MIX) {
            throw new SetUpException("J2SE with J2EE modules are used with null-deref analysis. Separation is recommended.");
        }
        if (modulesCodeKind == AbstractSolverRunner.CodeKind.J2SE) {
            if (this.getManager().isJ2EEOptionsActivated()) {
                throw new SetUpException("J2EE option(s) used with J2SE code. Please correct.");
            }
        } else if (this.getManager().isJ2SEOptionsActivated()) {
            throw new SetUpException("J2SE option(s) used with J2EE code. Please correct.");
        }
        EntryPointDefinition[] entryPoints = this.getManager().getEntryPointDefinitions();
        CallGraphEngine cgEngine = new CallGraphEngine(this.getManager().getCallGraphKind(), this.getManager(), this.getPerformanceTracker(), monitor, modulesCodeKind != AbstractSolverRunner.CodeKind.J2SE);
        if (!this.getManager().isContradictionAnalysis() && modulesCodeKind == AbstractSolverRunner.CodeKind.J2SE && entryPoints.length == 0 && !this.getManager().isJ2SEOptionsActivated()) {
            throw new SetUpException("Entry points are required. \nSpecify them with one of next options: 'main_classes', 'makeAllMainClassesEntryPoint', entry_points' or 'entry_points_file'.");
        }
        return cgEngine;
    }

    @Override
    protected WholeProgramOptions getManager() {
        return (WholeProgramOptions)this.propertiesManager;
    }
}

