/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.internal.runners;

import com.ibm.safe.internal.exceptions.ExceptionContainer;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.runners.IResultObserver;
import com.ibm.safe.runners.ISolverRunner;
import com.ibm.safe.utils.SafeLogger;
import com.ibm.wala.util.CancelException;
import java.util.Collection;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class CompositeSolverRunner
implements ISolverRunner {
    private final Collection<ISolverRunner> solverRunners = new Stack<ISolverRunner>();

    @Override
    public void run(IResultObserver observer, IProgressMonitor monitor) throws SafeException, CancelException, IllegalArgumentException, CoreException {
        ExceptionContainer exceptContainer = new ExceptionContainer();
        boolean oneRunnerSucceeded = false;
        monitor.beginTask(null, this.solverRunners.size());
        for (ISolverRunner solverRunner : this.solverRunners) {
            try {
                solverRunner.run(observer, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                oneRunnerSucceeded = true;
            }
            catch (SetUpException except) {
                exceptContainer.addException(except);
            }
        }
        if (!exceptContainer.isEmpty()) {
            if (oneRunnerSucceeded) {
                SafeLogger.severe("Set up before analyzer run failed.", exceptContainer);
            } else {
                throw exceptContainer;
            }
        }
    }

    public void addSolverRunner(ISolverRunner solverRunner) {
        this.solverRunners.add(solverRunner);
    }

    public boolean isEmpty() {
        return this.solverRunners.isEmpty();
    }
}

