/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.internal.reporting;

import com.ibm.safe.internal.reporting.LogReporter;
import com.ibm.safe.internal.reporting.StandardOutputReporter;
import com.ibm.safe.internal.reporting.XMLReporter;
import com.ibm.safe.reporting.CompositeReporter;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.utils.SafeLogger;
import javax.xml.parsers.ParserConfigurationException;

public final class ReporterFactory {
    public static IReporter createDefaultReporter(String analysisResultFileName) {
        CompositeReporter reporter = new CompositeReporter();
        reporter.addReporter(new StandardOutputReporter());
        reporter.addReporter(new LogReporter());
        ReporterFactory.addXMLReporter(reporter, analysisResultFileName);
        return reporter;
    }

    public static IReporter createLogAndXMLReporter(String analysisResultFileName) {
        CompositeReporter reporter = new CompositeReporter();
        reporter.addReporter(new LogReporter());
        ReporterFactory.addXMLReporter(reporter, analysisResultFileName);
        return reporter;
    }

    public static IReporter createXMLAndConsoleReporter(String analysisResultFileName) {
        CompositeReporter reporter = new CompositeReporter();
        reporter.addReporter(new StandardOutputReporter());
        ReporterFactory.addXMLReporter(reporter, analysisResultFileName);
        return reporter;
    }

    private ReporterFactory() {
    }

    private static void addXMLReporter(CompositeReporter reporter, String analysisResultFilename) {
        try {
            reporter.addReporter(new XMLReporter(analysisResultFilename));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SafeLogger.warning("Unable to create XML reporter.");
        }
    }
}

