/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.controller;

import com.ibm.safe.rules.IRule;
import java.io.File;
import java.util.Collection;

public class RulesManager {
    public static final String LIST_REGEX_SEPARATOR = "[,;]\\s*";
    protected final IRule[] rules;

    protected RulesManager(IRule[] theRules) {
        this.rules = theRules;
    }

    protected void applyFilters(Collection<IRule> finalRules, Collection<IRule> allRules, String propertyValue) {
        if (propertyValue != null) {
            String[] selectedXMI = propertyValue.split(LIST_REGEX_SEPARATOR);
            if (selectedXMI.length > 0) {
                for (IRule rule : allRules) {
                    String resource = rule.getFileName();
                    if (resource != null) {
                        String xmiFileName = resource.substring(resource.lastIndexOf(File.separatorChar) + 1);
                        String fileName = xmiFileName.substring(0, xmiFileName.lastIndexOf(46));
                        int i = 0;
                        while (i < selectedXMI.length) {
                            if (fileName.equals(selectedXMI[i])) {
                                finalRules.add(rule);
                            }
                            ++i;
                        }
                        continue;
                    }
                    finalRules.add(rule);
                }
            }
        } else {
            finalRules.addAll(allRules);
        }
    }
}

