/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.callgraph;

import com.ibm.safe.internal.entrypoints.EntryPointDefinition;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class SelectiveEntryPoints
implements Iterable<Entrypoint> {
    private final Collection<Entrypoint> entryPoints = new ArrayList<Entrypoint>(10);

    public SelectiveEntryPoints(AnalysisScope analysisScope, IClassHierarchy classHierarchy, EntryPointDefinition[] entryPointDefs) throws SetUpException {
        for (IClass clazz : classHierarchy) {
            int i = 0;
            while (i < entryPointDefs.length) {
                if (clazz.getName().toString().equals(entryPointDefs[i].getClassName()) && !clazz.isInterface() && this.isApplicationClass(analysisScope, clazz)) {
                    for (IMethod method : clazz.getDeclaredMethods()) {
                        if (method.isAbstract() || !this.isSameMethod(method.getReference(), entryPointDefs[i].getMethodName(), entryPointDefs[i].getMethodDescriptor())) continue;
                        this.entryPoints.add((Entrypoint)new DefaultEntrypoint(method.getReference(), classHierarchy));
                    }
                }
                ++i;
            }
        }
        if (this.entryPoints.isEmpty()) {
            throw new SetUpException("No valid entry points have been detected for the analysis.");
        }
    }

    @Override
    public Iterator<Entrypoint> iterator() {
        return this.entryPoints.iterator();
    }

    private boolean isApplicationClass(AnalysisScope scope, IClass clazz) {
        return scope.getApplicationLoader().equals((Object)clazz.getClassLoader().getReference());
    }

    private boolean isSameMethod(MethodReference methodRef, String entryMethodName, String entryMethodDescriptor) {
        return methodRef.getName().toString().equals(entryMethodName) && methodRef.getDescriptor().toString().equals(entryMethodDescriptor);
    }
}

