/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.callgraph;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.AllApplicationEntrypoints;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.util.Iterator;

public class SafeEntryPoints {
    public static final String NO_VALID_ENTRYPOINTS = "No valid entry points have been detected for the analysis.";
    private static final int DEBUG_LEVEL = 0;

    public static Iterable<Entrypoint> makeSingleMainEntrypoint(AnalysisScope scope, final ClassHierarchy cha, String className) {
        SafeEntryPoints.validateClassName(className);
        Atom mainMethodAtom = Atom.findOrCreateAsciiAtom((String)"main");
        TypeReference T = TypeReference.findOrCreate((ClassLoaderReference)scope.getApplicationLoader(), (TypeName)TypeName.string2TypeName((String)className));
        MethodReference main = MethodReference.findOrCreate((TypeReference)T, (Atom)mainMethodAtom, (Descriptor)Descriptor.findOrCreateUTF8((String)"([Ljava/lang/String;)V"));
        IClass klass = cha.lookupClass(T);
        if (klass == null) {
            throw new RuntimeException("could not load app client entrypoint " + T);
        }
        final IMethod m = cha.resolveMethod(klass, main.getSelector());
        if (m == null) {
            return null;
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return new NonNullSingletonIterator((Object)new DefaultEntrypoint(m, (IClassHierarchy)cha));
            }
        };
    }

    public static Iterable<Entrypoint> makeAllEntrypoints(AnalysisScope scope, ClassHierarchy cha) {
        return new AllApplicationEntrypoints(scope, (IClassHierarchy)cha);
    }

    private static void validateClassName(String className) {
        if (className.indexOf("L") != 0) {
            Assertions.productionAssertion((boolean)false, (String)("Expected class name to start with L " + className));
        }
        if (className.indexOf(".") > 0) {
            Assertions.productionAssertion((boolean)false, (String)("Expected class name formatted with /, not . " + className));
        }
    }
}

