/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.ui.wizards;

import edu.cuny.hunter.streamrefactoring.core.messages.Messages;
import edu.cuny.hunter.streamrefactoring.core.refactorings.OptimizeStreamsRefactoringProcessor;
import edu.cuny.hunter.streamrefactoring.core.utils.Util;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class OptimizeStreamRefactoringWizard
extends RefactoringWizard {
    public static void startRefactoring(IJavaProject[] javaProjects, Shell shell, Optional<IProgressMonitor> monitor) throws JavaModelException {
        ProcessorBasedRefactoring refactoring = Util.createRefactoring((IJavaProject[])javaProjects, monitor);
        OptimizeStreamRefactoringWizard wizard = new OptimizeStreamRefactoringWizard((Refactoring)refactoring);
        new RefactoringStarter().activate((RefactoringWizard)wizard, shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public OptimizeStreamRefactoringWizard(Refactoring refactoring) {
        super(refactoring, 0);
        this.setWindowTitle(Messages.Name);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new OptimizeStreamsInputPage());
    }

    private static class OptimizeStreamsInputPage
    extends UserInputWizardPage {
        private static final String DESCRIPTION = Messages.Name;
        private static final String DIALOG_SETTING_SECTION = "OptimizeStreams";
        private static final String K_FOR_STREAMS = "kForStreams";
        public static final String PAGE_NAME = "OptimizeStreamsInputPage";
        private static final String USE_IMPLICIT_ENTRY_POINTS = "useImplicitEntryPoints";
        private static final String USE_IMPLICIT_JAVAFX_ENTRY_POINTS = "useImplicitJavaFXEntryPoints";
        private static final String USE_IMPLICIT_JMH_ENTRY_POINTS = "useImplicitJMHEntryPoints";
        private static final String USE_IMPLICIT_TEST_ENTRY_POINTS = "useImplicitTestEntryPoints";
        private OptimizeStreamsRefactoringProcessor processor;
        IDialogSettings settings;

        public OptimizeStreamsInputPage() {
            super(PAGE_NAME);
            this.setDescription(DESCRIPTION);
        }

        private void addBooleanButton(String text, final String key, final Consumer<Boolean> valueConsumer, Composite result) {
            Button button = new Button(result, 32);
            button.setText(text);
            boolean value = this.settings.getBoolean(key);
            valueConsumer.accept(value);
            button.setSelection(value);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selection = ((Button)e.widget).getSelection();
                    settings.put(key, selection);
                    valueConsumer.accept(selection);
                }
            });
        }

        private void addIntegerButton(String text, String key, Consumer<Integer> valueConsumer, Composite result) {
            Label label = new Label(result, 256);
            label.setText(text);
            Text textBox = new Text(result, 4);
            int value = this.settings.getInt(key);
            valueConsumer.accept(value);
            textBox.setText(String.valueOf(value));
            textBox.addModifyListener(event -> {
                int selection;
                try {
                    selection = Integer.parseInt(((Text)event.widget).getText());
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                this.settings.put(key, selection);
                valueConsumer.accept(selection);
            });
        }

        public void createControl(Composite parent) {
            ProcessorBasedRefactoring processorBasedRefactoring = (ProcessorBasedRefactoring)this.getRefactoring();
            RefactoringProcessor refactoringProcessor = processorBasedRefactoring.getProcessor();
            this.setProcessor((OptimizeStreamsRefactoringProcessor)refactoringProcessor);
            this.loadSettings();
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            result.setLayout((Layout)layout);
            Label doit = new Label(result, 64);
            doit.setText("Optimize Java 8 Streams for increased parallelism and efficiency.");
            doit.setLayoutData((Object)new GridData());
            Label separator = new Label(result, 258);
            separator.setLayoutData((Object)new GridData(4, 1, true, false));
            this.addBooleanButton("Automatically discover standard entry points (main methods).", USE_IMPLICIT_ENTRY_POINTS, arg_0 -> ((OptimizeStreamsRefactoringProcessor)this.getProcessor()).setUseImplicitEntrypoints(arg_0), result);
            this.addBooleanButton("Automatically discover test-based entry points (JUnit).", USE_IMPLICIT_TEST_ENTRY_POINTS, arg_0 -> ((OptimizeStreamsRefactoringProcessor)this.getProcessor()).setUseImplicitTestEntrypoints(arg_0), result);
            this.addBooleanButton("Automatically discover benchmark entry points (JMH).", USE_IMPLICIT_JMH_ENTRY_POINTS, arg_0 -> ((OptimizeStreamsRefactoringProcessor)this.getProcessor()).setUseImplicitBenchmarkEntrypoints(arg_0), result);
            this.addBooleanButton("Automatically discover GUI entry points (JavaFX).", USE_IMPLICIT_JAVAFX_ENTRY_POINTS, arg_0 -> ((OptimizeStreamsRefactoringProcessor)this.getProcessor()).setUseImplicitJavaFXEntrypoints(arg_0), result);
            Composite compositeForIntegerButton = new Composite(result, 0);
            GridLayout layoutForIntegerButton = new GridLayout(2, false);
            compositeForIntegerButton.setLayout((Layout)layoutForIntegerButton);
            this.addIntegerButton("k value to use for streams for kCFA: ", K_FOR_STREAMS, arg_0 -> ((OptimizeStreamsRefactoringProcessor)this.getProcessor()).setNForStreams(arg_0), compositeForIntegerButton);
            this.updateStatus();
            Dialog.applyDialogFont((Control)result);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "optimize_streams_wizard_page_context");
        }

        private OptimizeStreamsRefactoringProcessor getProcessor() {
            return this.processor;
        }

        private void loadSettings() {
            int value;
            this.settings = this.getDialogSettings().getSection(DIALOG_SETTING_SECTION);
            if (this.settings == null) {
                this.settings = this.getDialogSettings().addNewSection(DIALOG_SETTING_SECTION);
                this.settings.put(USE_IMPLICIT_ENTRY_POINTS, this.getProcessor().getUseImplicitEntrypoints());
                this.settings.put(USE_IMPLICIT_TEST_ENTRY_POINTS, this.getProcessor().getUseImplicitTestEntrypoints());
                this.settings.put(USE_IMPLICIT_JMH_ENTRY_POINTS, this.getProcessor().getUseImplicitBenchmarkEntrypoints());
                this.settings.put(USE_IMPLICIT_JAVAFX_ENTRY_POINTS, this.getProcessor().getUseImplicitBenchmarkEntrypoints());
                this.settings.put(K_FOR_STREAMS, this.getProcessor().getNForStreams());
            }
            this.processor.setUseImplicitEntrypoints(this.settings.getBoolean(USE_IMPLICIT_ENTRY_POINTS));
            this.processor.setUseImplicitTestEntrypoints(this.settings.getBoolean(USE_IMPLICIT_TEST_ENTRY_POINTS));
            this.processor.setUseImplicitBenchmarkEntrypoints(this.settings.getBoolean(USE_IMPLICIT_JMH_ENTRY_POINTS));
            this.processor.setUseImplicitJavaFXEntrypoints(this.settings.getBoolean(USE_IMPLICIT_JAVAFX_ENTRY_POINTS));
            try {
                value = this.settings.getInt(K_FOR_STREAMS);
            }
            catch (NumberFormatException numberFormatException) {
                this.settings.put(K_FOR_STREAMS, this.getProcessor().getNForStreams());
                value = this.settings.getInt(K_FOR_STREAMS);
            }
            this.processor.setNForStreams(value);
        }

        private void setProcessor(OptimizeStreamsRefactoringProcessor processor) {
            this.processor = processor;
        }

        private void updateStatus() {
            this.setPageComplete(true);
        }
    }
}

