/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntVector;
import com.ibm.wala.util.intset.SparseIntVector;
import com.ibm.wala.util.math.Logs;
import java.io.Serializable;
import java.util.Vector;

public class TwoLevelIntVector
implements IntVector,
Serializable {
    private static final int PAGE_SIZE = 4096;
    private static final int LOG_PAGE_SIZE = Logs.log2(4096);
    int maxIndex = -1;
    private final Vector<SparseIntVector> data = new Vector();
    private final int defaultValue;

    TwoLevelIntVector(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public int get(int x) {
        int page = this.getPageNumber(x);
        if (page >= this.data.size()) {
            return this.defaultValue;
        }
        IntVector v = this.data.get(page);
        if (v == null) {
            return this.defaultValue;
        }
        int localX = this.toLocalIndex(x, page);
        return v.get(localX);
    }

    private int toLocalIndex(int x, int page) {
        return x - this.getFirstIndexOnPage(page);
    }

    private int getFirstIndexOnPage(int page) {
        return page << LOG_PAGE_SIZE;
    }

    private int getPageNumber(int x) {
        return x >> LOG_PAGE_SIZE;
    }

    @Override
    public void set(int x, int value) {
        this.maxIndex = Math.max(this.maxIndex, x);
        int page = this.getPageNumber(x);
        IntVector v = this.findOrCreatePage(page);
        int localX = this.toLocalIndex(x, page);
        v.set(localX, value);
    }

    private IntVector findOrCreatePage(int page) {
        if (page >= this.data.size()) {
            SparseIntVector v = new SparseIntVector(this.defaultValue);
            this.data.setSize(page + 1);
            this.data.add(page, v);
            return v;
        }
        SparseIntVector v = this.data.get(page);
        if (v == null) {
            v = new SparseIntVector(this.defaultValue);
            this.data.set(page, v);
        }
        return v;
    }

    public void performVerboseAction() {
        System.err.println("stats of " + this.getClass());
        System.err.println("data: size = " + this.data.size());
    }

    @Override
    public int getMaxIndex() {
        return this.maxIndex;
    }
}

