/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableMapping;
import java.io.Serializable;
import java.util.Iterator;

public class SlowNumberedNodeManager<T>
implements NumberedNodeManager<T>,
Serializable {
    private final MutableMapping<T> map = MutableMapping.make();

    @Override
    public int getNumber(T obj) {
        return this.map.getMappedIndex(obj);
    }

    @Override
    public T getNode(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("number must be >= 0");
        }
        T result = this.map.getMappedObject(number);
        return result;
    }

    @Override
    public int getMaxNumber() {
        return this.map.getMaximumIndex();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.iterator();
    }

    @Override
    public int getNumberOfNodes() {
        return this.map.getSize();
    }

    @Override
    public void addNode(T n) {
        if (n == null) {
            throw new IllegalArgumentException("n is null");
        }
        this.map.add(n);
    }

    @Override
    public void removeNode(T n) {
        this.map.deleteMappedObject(n);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Nodes:\n");
        int i = 0;
        while (i <= this.getMaxNumber()) {
            result.append(i).append("  ");
            result.append(this.map.getMappedObject(i));
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    @Override
    public boolean containsNode(T N) {
        return this.getNumber(N) != -1;
    }

    @Override
    public Iterator<T> iterateNodes(IntSet s) {
        return new NumberedNodeIterator(s, this);
    }
}

