/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.citytech.refactoring.common.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;

public abstract class RefactoringProcessor
extends org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor {
    protected Map<ICompilationUnit, CompilationUnitRewrite> compilationUnitToCompilationUnitRewriteMap = new HashMap<ICompilationUnit, CompilationUnitRewrite>();
    protected CodeGenerationSettings settings;
    protected Map<ITypeRoot, CompilationUnit> typeRootToCompilationUnitMap = new HashMap<ITypeRoot, CompilationUnit>();

    public RefactoringProcessor(CodeGenerationSettings settings) {
        this.settings = settings;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.clearCaches();
        return new RefactoringStatus();
    }

    public void clearCaches() {
        this.getTypeRootToCompilationUnitMap().clear();
        this.getCompilationUnitToCompilationUnitRewriteMap().clear();
    }

    protected CompilationUnit getCompilationUnit(ITypeRoot root, IProgressMonitor pm) {
        CompilationUnit compilationUnit = this.getTypeRootToCompilationUnitMap().get(root);
        if (compilationUnit == null) {
            compilationUnit = RefactoringASTParser.parseWithASTProvider((ITypeRoot)root, (boolean)true, (IProgressMonitor)pm);
            this.getTypeRootToCompilationUnitMap().put(root, compilationUnit);
        }
        return compilationUnit;
    }

    protected CompilationUnitRewrite getCompilationUnitRewrite(ICompilationUnit unit, CompilationUnit root) {
        CompilationUnitRewrite rewrite = this.getCompilationUnitToCompilationUnitRewriteMap().get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit, root);
            this.getCompilationUnitToCompilationUnitRewriteMap().put(unit, rewrite);
        }
        return rewrite;
    }

    protected Map<ICompilationUnit, CompilationUnitRewrite> getCompilationUnitToCompilationUnitRewriteMap() {
        return this.compilationUnitToCompilationUnitRewriteMap;
    }

    protected Map<ITypeRoot, CompilationUnit> getTypeRootToCompilationUnitMap() {
        return this.typeRootToCompilationUnitMap;
    }

    protected void manageCompilationUnit(TextEditBasedChangeManager manager, CompilationUnitRewrite rewrite, Optional<IProgressMonitor> monitor) throws CoreException {
        monitor.ifPresent(m -> m.beginTask("Creating change ...", -1));
        CompilationUnitChange change = rewrite.createChange(false, monitor.orElseGet(NullProgressMonitor::new));
        if (change != null) {
            change.setTextType("java");
        }
        manager.manage(rewrite.getCu(), (TextEditBasedChange)change);
    }
}

