/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.wala;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallString;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallStringContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallStringContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.cfa.nCFAContextSelector;
import com.ibm.wala.types.TypeReference;
import edu.cuny.hunter.streamrefactoring.core.analysis.Util;
import edu.cuny.hunter.streamrefactoring.core.wala.CallStringWithReceivers;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class nCFAContextWithReceiversSelector
extends nCFAContextSelector {
    protected static final int CONTEXT_LENGTH_FOR_STREAMS_DEFAULT = 2;
    private static final Logger LOGGER = Logger.getLogger("edu.cuny.hunter.streamrefactoring");
    protected Map<CallStringTriple, CallStringWithReceivers> callStringWithReceiversMap = new HashMap<CallStringTriple, CallStringWithReceivers>();
    private int contextLengthForStreams = 2;

    public nCFAContextWithReceiversSelector(int n, ContextSelector base) {
        super(n, base);
    }

    public nCFAContextWithReceiversSelector(int n, ContextSelector base, int nToUseForStreams) {
        super(n, base);
        LOGGER.fine(() -> "Using N = " + nToUseForStreams + ".");
        this.contextLengthForStreams = nToUseForStreams;
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] actualParameters) {
        Context baseContext = this.base.getCalleeTarget(caller, site, callee, actualParameters);
        CallStringWithReceivers cs = this.getCallString(caller, site, callee, actualParameters);
        if (cs == null) {
            return baseContext;
        }
        if (baseContext == Everywhere.EVERYWHERE) {
            return new CallStringContext((CallString)cs);
        }
        return new CallStringContextSelector.CallStringContextPair((CallString)cs, baseContext);
    }

    protected CallStringWithReceivers getCallString(CGNode caller, CallSiteReference site, IMethod target, InstanceKey[] actualParameters) {
        CallString callString;
        CallStringTriple triple = new CallStringTriple(caller, site, target);
        if (this.getCallStringWithReceiversMap().containsKey(triple)) {
            CallStringWithReceivers ret = this.getCallStringWithReceiversMap().get(triple);
            if (actualParameters != null && actualParameters.length > 0) {
                ret.addPossibleReceiver(actualParameters[0]);
            }
            return ret;
        }
        CallStringWithReceivers ret = null;
        int length = this.getLength(caller, site, target);
        ret = length > 0 ? ((callString = (CallString)caller.getContext().get(CALL_STRING)) != null ? new CallStringWithReceivers(site, caller.getMethod(), length, callString) : new CallStringWithReceivers(site, caller.getMethod())) : null;
        if (ret != null && actualParameters != null && actualParameters.length > 0) {
            ret.addPossibleReceiver(actualParameters[0]);
        }
        this.getCallStringWithReceiversMap().put(triple, ret);
        return ret;
    }

    protected Map<CallStringTriple, CallStringWithReceivers> getCallStringWithReceiversMap() {
        return this.callStringWithReceiversMap;
    }

    public int getContextLengthForStreams() {
        return this.contextLengthForStreams;
    }

    protected int getLength(CGNode caller, CallSiteReference site, IMethod target) {
        TypeReference typeToCheck = Util.getEvaluationType(target);
        boolean implementsBaseStream = Util.implementsBaseStream(typeToCheck, target.getClassHierarchy());
        if (implementsBaseStream) {
            int lengthForStreams = this.getContextLengthForStreams();
            LOGGER.finer(() -> "Using N = " + lengthForStreams + ".");
            return lengthForStreams;
        }
        return super.getLength(caller, site, target);
    }

    protected void setContextLengthForStreams(int contextLengthForStreams) {
        this.contextLengthForStreams = contextLengthForStreams;
    }

    protected class CallStringTriple {
        CGNode node;
        CallSiteReference site;
        IMethod target;

        public CallStringTriple(CGNode node, CallSiteReference site, IMethod target) {
            this.node = node;
            this.site = site;
            this.target = target;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CallStringTriple) {
                CallStringTriple rhs = (CallStringTriple)obj;
                return this.node.equals(rhs.node) && this.site.equals((Object)rhs.site) && this.target.equals(rhs.target);
            }
            return false;
        }

        public int hashCode() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.node.hashCode());
            builder.append(this.site.hashCode());
            builder.append(this.target.hashCode());
            return builder.toString().hashCode();
        }
    }
}

