/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.utils;

import edu.cuny.hunter.streamrefactoring.core.refactorings.ConvertToParallelStreamRefactoringProcessor;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public final class Util {
    public static ConvertToParallelStreamRefactoringProcessor createConvertToParallelStreamRefactoringProcessor(IJavaProject[] projects, boolean useImplicitEntrypoints, boolean useImplicitTestEntrypoints, boolean useImplicitBenchmarkEntrypoints, boolean useImplicitJavaFXEntrypoints, Optional<IProgressMonitor> monitor) throws JavaModelException {
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)projects[0]);
        ConvertToParallelStreamRefactoringProcessor processor = new ConvertToParallelStreamRefactoringProcessor(projects, settings, false, useImplicitEntrypoints, useImplicitTestEntrypoints, useImplicitBenchmarkEntrypoints, useImplicitJavaFXEntrypoints, monitor);
        return processor;
    }

    public static ConvertToParallelStreamRefactoringProcessor createConvertToParallelStreamRefactoringProcessor(IJavaProject[] projects, int nForStreams, boolean useImplicitEntrypoints, boolean useImplicitTestEntrypoints, boolean useImplicitBenchmarkEntrypoints, boolean useImplicitJavaFXEntrypoints, Optional<IProgressMonitor> monitor) throws JavaModelException {
        ConvertToParallelStreamRefactoringProcessor processor = Util.createConvertToParallelStreamRefactoringProcessor(projects, useImplicitEntrypoints, useImplicitTestEntrypoints, useImplicitBenchmarkEntrypoints, useImplicitJavaFXEntrypoints, monitor);
        processor.setNForStreams(nForStreams);
        return processor;
    }

    public static ConvertToParallelStreamRefactoringProcessor createConvertToParallelStreamRefactoringProcessor(IJavaProject[] projects, Optional<IProgressMonitor> monitor) throws JavaModelException {
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)projects[0]);
        ConvertToParallelStreamRefactoringProcessor processor = new ConvertToParallelStreamRefactoringProcessor(projects, settings, monitor);
        return processor;
    }

    public static ProcessorBasedRefactoring createRefactoring() throws JavaModelException {
        ConvertToParallelStreamRefactoringProcessor processor = new ConvertToParallelStreamRefactoringProcessor();
        return new ProcessorBasedRefactoring((RefactoringProcessor)processor);
    }

    public static ProcessorBasedRefactoring createRefactoring(IJavaProject[] projects, Optional<IProgressMonitor> monitor) throws JavaModelException {
        ConvertToParallelStreamRefactoringProcessor processor = Util.createConvertToParallelStreamRefactoringProcessor(projects, monitor);
        return new ProcessorBasedRefactoring((RefactoringProcessor)processor);
    }

    public static edu.cuny.citytech.refactoring.common.core.Refactoring createRefactoring(final Refactoring refactoring) {
        return new edu.cuny.citytech.refactoring.common.core.Refactoring(){

            public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return refactoring.checkFinalConditions(pm);
            }

            public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return refactoring.checkInitialConditions(pm);
            }

            public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return refactoring.createChange(pm);
            }

            public String getName() {
                return refactoring.getName();
            }
        };
    }

    public static String getMethodIdentifier(IMethod method) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(method.getElementName()) + "(");
        ILocalVariable[] parameters = method.getParameters();
        int i = 0;
        while (i < parameters.length) {
            sb.append(Util.getQualifiedNameFromTypeSignature(parameters[i].getTypeSignature(), method.getDeclaringType()));
            if (i != parameters.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getQualifiedNameFromTypeSignature(String typeSignature, IType declaringType) throws JavaModelException {
        typeSignature = Signature.getTypeErasure((String)typeSignature);
        String signatureQualifier = Signature.getSignatureQualifier((String)typeSignature);
        String signatureSimpleName = Signature.getSignatureSimpleName((String)typeSignature);
        String simpleName = signatureQualifier.isEmpty() ? signatureSimpleName : String.valueOf(signatureQualifier) + '.' + signatureSimpleName;
        boolean isArray = false;
        if (simpleName.endsWith("[]")) {
            isArray = true;
            simpleName = simpleName.substring(0, simpleName.lastIndexOf(91));
        }
        String[][] allResults = declaringType.resolveType(simpleName);
        String fullName = null;
        if (allResults != null) {
            String[] nameParts = allResults[0];
            if (nameParts != null) {
                StringBuilder fullNameBuilder = new StringBuilder();
                String[] stringArray = nameParts;
                int n = nameParts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (fullNameBuilder.length() > 0) {
                        fullNameBuilder.append('.');
                    }
                    if (part != null) {
                        fullNameBuilder.append(part);
                    }
                    ++n2;
                }
                fullName = fullNameBuilder.toString();
            }
        } else {
            fullName = simpleName;
        }
        if (isArray) {
            fullName = String.valueOf(fullName) + "[]";
        }
        return fullName;
    }

    public static ASTNode stripParenthesizedExpressions(ASTNode node) {
        if (node != null && node.getNodeType() == 36) {
            ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)node;
            return Util.stripParenthesizedExpressions((ASTNode)parenthesizedExpression.getExpression());
        }
        return node;
    }

    private Util() {
    }
}

