/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;

public class SourceBuffer {
    private String[] lines;
    private final CAstSourcePositionMap.Position p;

    public SourceBuffer(CAstSourcePositionMap.Position p) throws IOException {
        this.p = p;
        BufferedReader reader = new BufferedReader(p.getReader());
        String currentLine = null;
        ArrayList<String> lines = new ArrayList<String>();
        int offset = 0;
        int line = 0;
        do {
            if ((currentLine = reader.readLine()) == null) {
                this.lines = new String[0];
                return;
            }
            offset += currentLine.length() + 1;
            ++line;
        } while (!(p.getLastOffset() >= 0 ? p.getFirstOffset() <= offset : p.getFirstLine() <= line));
        if (p.getLastOffset() >= 0) {
            if (p.getFirstOffset() == offset) {
                lines.add("\n");
            } else {
                int startOffset = p.getFirstOffset() - (offset - currentLine.length() - 1);
                if (offset > p.getLastOffset()) {
                    int endOffset = p.getLastOffset() - (offset - currentLine.length() - 1);
                    lines.add(currentLine.substring(startOffset, endOffset));
                } else {
                    lines.add(currentLine.substring(startOffset));
                }
            }
        } else {
            lines.add(currentLine.substring(p.getFirstCol()));
        }
        while (!(p.getLastOffset() >= 0 ? p.getLastOffset() < offset : p.getLastLine() < line)) {
            currentLine = reader.readLine();
            if (currentLine == null) {
                offset = p.getLastOffset();
                break;
            }
            offset += currentLine.length() + 1;
            ++line;
            if (p.getLastOffset() >= 0) {
                if (offset > p.getLastOffset()) {
                    lines.add(currentLine.substring(0, currentLine.length() - (offset - p.getLastOffset()) + 1));
                    continue;
                }
                lines.add(currentLine);
                continue;
            }
            if (p.getLastLine() == line) {
                lines.add(currentLine.substring(0, p.getLastCol()));
                continue;
            }
            lines.add(currentLine);
        }
        this.lines = lines.toArray(new String[lines.size()]);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.lines.length) {
            if (i == this.lines.length - 1) {
                result.append(this.lines[i]);
            } else {
                result.append(this.lines[i]).append("\n");
            }
            ++i;
        }
        return result.toString();
    }

    public void substitute(CAstSourcePositionMap.Position range, String newText) {
        String[] newTextLines;
        int endLine;
        int startLine = range.getFirstLine() - this.p.getFirstLine();
        if (startLine != (endLine = range.getLastLine() - this.p.getFirstLine())) {
            String[] newLines = new String[this.lines.length - (endLine - startLine)];
            int i = 0;
            while (i < startLine) {
                newLines[i] = this.lines[i];
                ++i;
            }
            newLines[i++] = String.valueOf(this.lines[startLine].substring(0, range.getFirstCol())) + this.lines[endLine].substring(range.getLastCol());
            while (i < newLines.length) {
                newLines[i] = this.lines[i + (endLine - startLine)];
                ++i;
            }
            this.lines = newLines;
            endLine = startLine;
            final CAstSourcePositionMap.Position hack = range;
            range = new AbstractSourcePosition(){

                public int getFirstLine() {
                    return hack.getFirstLine();
                }

                public int getLastLine() {
                    return hack.getFirstLine();
                }

                public int getFirstCol() {
                    return hack.getFirstCol();
                }

                public int getLastCol() {
                    return hack.getFirstCol();
                }

                public int getFirstOffset() {
                    return hack.getFirstOffset();
                }

                public int getLastOffset() {
                    return hack.getFirstOffset();
                }

                @Override
                public URL getURL() {
                    return hack.getURL();
                }

                @Override
                public Reader getReader() throws IOException {
                    return hack.getReader();
                }

                public String getFileName() {
                    return hack.getFileName();
                }
            };
        }
        if ((newTextLines = newText.split("\n")).length == 1) {
            this.lines[startLine] = String.valueOf(this.lines[startLine].substring(0, range.getFirstCol())) + newTextLines[0] + this.lines[startLine].substring(range.getLastCol() + 1);
        } else {
            String[] newLines = new String[this.lines.length + newTextLines.length - 1];
            int i = 0;
            while (i < startLine) {
                newLines[i] = this.lines[i];
                ++i;
            }
            newLines[i++] = String.valueOf(this.lines[startLine].substring(0, range.getFirstCol())) + newTextLines[0];
            int j = 1;
            while (j < newTextLines.length - 1) {
                this.lines[i++] = newTextLines[j];
                ++j;
            }
            newLines[i++] = String.valueOf(newTextLines[newTextLines.length - 1]) + this.lines[endLine].substring(range.getLastCol() + 1);
            while (i < newLines.length) {
                newLines[i] = this.lines[i - newTextLines.length + 1];
                ++i;
            }
            this.lines = newLines;
        }
    }
}

