/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.ir.cfg.AstInducedCFG;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.Function;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;

public class AstCallGraph
extends ExplicitCallGraph {
    public AstCallGraph(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
        super(cha, options, cache);
    }

    protected ExplicitCallGraph.ExplicitNode makeNode(IMethod method, Context context) {
        return new AstCGNode(method, context);
    }

    protected CGNode makeFakeRootNode() throws CancelException {
        return this.findOrCreateNode((IMethod)new AstFakeRoot(FakeRootMethod.rootMethod, this.cha, this.options, this.getAnalysisCache()), (Context)Everywhere.EVERYWHERE);
    }

    public class AstCGNode
    extends ExplicitCallGraph.ExplicitNode {
        private Set<Function<Object, Object>> callbacks;
        private IR cachedIR;
        private DefUse cachedDU;

        private AstCGNode(IMethod method, Context context) {
            super((ExplicitCallGraph)AstCallGraph.this, method, context);
        }

        private void fireCallbacks() {
            if (this.callbacks != null) {
                boolean done = false;
                while (!done) {
                    try {
                        Iterator<Function<Object, Object>> x = this.callbacks.iterator();
                        while (x.hasNext()) {
                            x.next().apply(null);
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        done = false;
                        continue;
                    }
                    done = true;
                }
            }
        }

        private boolean hasCallback(Function<Object, Object> callback) {
            return this.callbacks != null && this.callbacks.contains(callback);
        }

        private boolean hasAllCallbacks(Set<Function<Object, Object>> callbacks) {
            return callbacks != null && callbacks.containsAll(callbacks);
        }

        public void addCallback(Function<Object, Object> callback) {
            if (!this.hasCallback(callback)) {
                if (this.callbacks == null) {
                    this.callbacks = HashSetFactory.make((int)1);
                }
                this.callbacks.add(callback);
                Iterator ps = this.getCallGraph().getPredNodes((Object)this);
                while (ps.hasNext()) {
                    ((AstCGNode)((Object)ps.next())).addCallback(callback);
                }
            }
        }

        public void addAllCallbacks(Set<Function<Object, Object>> callback) {
            if (!this.hasAllCallbacks(this.callbacks)) {
                if (this.callbacks == null) {
                    this.callbacks = HashSetFactory.make((int)1);
                }
                this.callbacks.addAll(callback);
                Iterator ps = this.getCallGraph().getPredNodes((Object)this);
                while (ps.hasNext()) {
                    ((AstCGNode)((Object)ps.next())).addAllCallbacks(callback);
                }
            }
        }

        public void clearMutatedCache(CallSiteReference cs) {
            this.targets.remove(cs.getProgramCounter());
        }

        public boolean addTarget(CallSiteReference site, CGNode node) {
            if (super.addTarget(site, node)) {
                if (((AstCGNode)node).callbacks != null) {
                    ((AstCGNode)node).fireCallbacks();
                    this.addAllCallbacks(((AstCGNode)node).callbacks);
                }
                return true;
            }
            return false;
        }
    }

    public static class AstFakeRoot
    extends AbstractRootMethod {
        public AstFakeRoot(MethodReference rootMethod, IClass declaringClass, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            super(rootMethod, declaringClass, cha, options, cache);
        }

        public AstFakeRoot(MethodReference rootMethod, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            super(rootMethod, cha, options, cache);
        }

        public InducedCFG makeControlFlowGraph(SSAInstruction[] statements) {
            return new AstInducedCFG(statements, (IMethod)this, (Context)Everywhere.EVERYWHERE);
        }

        public AstLexicalRead addGlobalRead(TypeReference type, String name) {
            AstLexicalRead s = new AstLexicalRead(this.statements.size(), this.nextLocal++, null, name, type);
            this.statements.add(s);
            return s;
        }
    }

    public static abstract class ScriptFakeRoot
    extends AstFakeRoot {
        public ScriptFakeRoot(MethodReference rootMethod, IClass declaringClass, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            super(rootMethod, declaringClass, cha, options, cache);
        }

        public ScriptFakeRoot(MethodReference rootMethod, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            super(rootMethod, cha, options, cache);
        }

        public abstract SSAAbstractInvokeInstruction addDirectCall(int var1, int[] var2, CallSiteReference var3);
    }
}

