/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.util;

import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.ide.classloader.EclipseSourceDirectoryTreeModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;

public abstract class EclipseProjectPath<E, P> {
    private final Set<String> bundlesProcessed = HashSetFactory.make();
    protected final Map<ILoader, List<Module>> modules = new HashMap<ILoader, List<Module>>();
    protected final Collection<E> alreadyResolved = HashSetFactory.make();
    private final AnalysisScopeType scopeType;

    protected abstract P makeProject(IProject var1);

    protected abstract E resolve(E var1);

    protected abstract void resolveClasspathEntry(P var1, E var2, ILoader var3, boolean var4, boolean var5);

    protected abstract void resolveProjectClasspathEntries(P var1, boolean var2);

    protected EclipseProjectPath(AnalysisScopeType scopeType) throws IOException, CoreException {
        this.scopeType = scopeType;
        Loader[] loaderArray = Loader.values();
        int n = loaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Loader loader = loaderArray[n2];
            MapUtil.findOrCreateList(this.modules, (Object)loader);
            ++n2;
        }
    }

    public EclipseProjectPath create(IProject project) throws CoreException, IOException {
        assert (project != null);
        if (project == null) {
            throw new IllegalArgumentException("null project");
        }
        boolean includeSource = this.scopeType != AnalysisScopeType.NO_SOURCE;
        this.resolveProjectClasspathEntries(this.makeProject(project), includeSource);
        if (this.isPluginProject(project)) {
            this.resolvePluginClassPath(project, includeSource);
        }
        return this;
    }

    protected void resolveLibraryPathEntry(ILoader loader, IPath p) {
        JarFile j;
        File file = EclipseProjectPath.makeAbsolute(p).toFile();
        try {
            j = new JarFile(file);
        }
        catch (ZipException zipException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        if (this.isPrimordialJarFile(j)) {
            List s = MapUtil.findOrCreateList(this.modules, (Object)loader);
            s.add(file.isDirectory() ? new BinaryDirectoryTreeModule(file) : new JarFileModule(j));
        }
    }

    protected void resolveSourcePathEntry(ILoader loader, boolean includeSource, boolean cpeFromMainProject, IPath p, IPath o, IPath[] excludePaths, String fileExtension) {
        if (includeSource) {
            List s = MapUtil.findOrCreateList(this.modules, (Object)loader);
            s.add(new EclipseSourceDirectoryTreeModule(p, excludePaths, fileExtension));
        } else if (o != null) {
            File output = EclipseProjectPath.makeAbsolute(o).toFile();
            List s = MapUtil.findOrCreateList(this.modules, (Object)(cpeFromMainProject ? Loader.APPLICATION : loader));
            s.add(new BinaryDirectoryTreeModule(output));
        }
    }

    protected void resolveProjectPathEntry(ILoader loader, boolean includeSource, IPath p) {
        IPath projectPath = EclipseProjectPath.makeAbsolute(p);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject project = (IProject)root.getContainerForLocation(projectPath);
        try {
            P javaProject = this.makeProject(project);
            if (javaProject != null) {
                if (this.isPluginProject(project)) {
                    this.resolvePluginClassPath(project, includeSource);
                }
                this.resolveProjectClasspathEntries(javaProject, this.scopeType == AnalysisScopeType.SOURCE_FOR_PROJ_AND_LINKED_PROJS ? includeSource : false);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            Assertions.UNREACHABLE();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    private void resolvePluginClassPath(IProject p, boolean includeSource) throws CoreException, IOException {
        BundleDescription bd;
        IPluginModelBase model = this.findModel(p);
        if (!model.isInSync() || model.isDisposed()) {
            model.load();
        }
        if ((bd = model.getBundleDescription()) == null) {
            System.err.println("model.isDisposed(): " + model.isDisposed());
            System.err.println("model.isInSync(): " + model.isInSync());
            System.err.println("model.isEnabled(): " + model.isEnabled());
            System.err.println("model.isLoaded(): " + model.isLoaded());
            System.err.println("model.isValid(): " + model.isValid());
        }
        int i = 0;
        while (i < 3 && bd == null) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
            bd = this.findModel(p).getBundleDescription();
            ++i;
        }
        if (bd == null) {
            throw new IllegalStateException("bundle description was null for " + p);
        }
        this.resolveBundleDescriptionClassPath(this.makeProject(p), bd, Loader.APPLICATION, includeSource);
    }

    private void resolveBundleDescriptionClassPath(P project, BundleDescription bd, Loader loader, boolean includeSource) throws CoreException, IOException {
        ImportPackageSpecification b;
        assert (bd != null);
        if (this.alreadyProcessed(bd)) {
            return;
        }
        this.bundlesProcessed.add(bd.getName());
        ArrayList l = new ArrayList();
        ClasspathUtilCore.addLibraries((IPluginModelBase)this.findModel(bd), l);
        this.resolveClasspathEntries(project, l, loader, includeSource, false);
        ImportPackageSpecification[] importPackageSpecificationArray = bd.getImportPackages();
        int n = importPackageSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            b = importPackageSpecificationArray[n2];
            this.resolveBundleDescriptionClassPath(project, b.getBundle(), Loader.EXTENSION, includeSource);
            ++n2;
        }
        importPackageSpecificationArray = bd.getResolvedRequires();
        n = importPackageSpecificationArray.length;
        n2 = 0;
        while (n2 < n) {
            b = importPackageSpecificationArray[n2];
            this.resolveBundleDescriptionClassPath(project, (BundleDescription)b, Loader.EXTENSION, includeSource);
            ++n2;
        }
        importPackageSpecificationArray = bd.getFragments();
        n = importPackageSpecificationArray.length;
        n2 = 0;
        while (n2 < n) {
            b = importPackageSpecificationArray[n2];
            this.resolveBundleDescriptionClassPath(project, (BundleDescription)b, Loader.EXTENSION, includeSource);
            ++n2;
        }
    }

    private boolean alreadyProcessed(BundleDescription bd) {
        return this.bundlesProcessed.contains(bd.getName());
    }

    private boolean isPluginProject(IProject project) {
        IPluginModelBase model = this.findModel(project);
        if (model == null) {
            return false;
        }
        return model.getPluginBase().getId() != null;
    }

    protected boolean isPrimordialJarFile(JarFile j) {
        return true;
    }

    protected void resolveClasspathEntries(P project, List l, ILoader loader, boolean includeSource, boolean entriesFromTopLevelProject) {
        int i = 0;
        while (i < l.size()) {
            this.resolveClasspathEntry(project, this.resolve(l.get(i)), loader, includeSource, entriesFromTopLevelProject);
            ++i;
        }
    }

    public static IPath makeAbsolute(IPath p) {
        IPath absolutePath = p;
        if (p.toFile().exists()) {
            return p;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(p);
        if (resource != null && resource.exists()) {
            absolutePath = resource.getLocation();
        }
        return absolutePath;
    }

    public AnalysisScope toAnalysisScope(ClassLoader classLoader, File exclusionsFile) throws IOException {
        AnalysisScope scope = AnalysisScopeReader.readJavaScope((String)"SyntheticJ2SEModel.txt", (File)exclusionsFile, (ClassLoader)classLoader);
        return this.toAnalysisScope(scope);
    }

    public AnalysisScope toAnalysisScope(AnalysisScope scope) {
        for (ILoader loader : this.modules.keySet()) {
            for (Module m : this.modules.get(loader)) {
                scope.addToScope(loader.ref(), m);
            }
        }
        return scope;
    }

    public AnalysisScope toAnalysisScope(File exclusionsFile) throws IOException {
        return this.toAnalysisScope(this.getClass().getClassLoader(), exclusionsFile);
    }

    public AnalysisScope toAnalysisScope() throws IOException {
        return this.toAnalysisScope(this.getClass().getClassLoader(), null);
    }

    public Collection<Module> getModules(ILoader loader, boolean binary) {
        return Collections.unmodifiableCollection((Collection)this.modules.get(loader));
    }

    public String toString() {
        try {
            return this.toAnalysisScope((File)null).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error in toString()";
        }
    }

    private IPluginModelBase findModel(IProject p) {
        return PDECore.getDefault().getModelManager().findModel(p);
    }

    private IPluginModelBase findModel(BundleDescription bd) {
        return PDECore.getDefault().getModelManager().findModel(bd);
    }

    public static enum AnalysisScopeType {
        NO_SOURCE,
        SOURCE_FOR_PROJ,
        SOURCE_FOR_PROJ_AND_LINKED_PROJS;

    }

    public static interface ILoader {
        public ClassLoaderReference ref();
    }

    public static enum Loader implements ILoader
    {
        APPLICATION(ClassLoaderReference.Application),
        EXTENSION(ClassLoaderReference.Extension),
        PRIMORDIAL(ClassLoaderReference.Primordial);

        private ClassLoaderReference ref;

        private Loader(ClassLoaderReference ref) {
            this.ref = ref;
        }

        @Override
        public ClassLoaderReference ref() {
            return this.ref;
        }
    }
}

