/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.util;

import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.ide.plugin.CorePlugin;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class EclipseFileProvider
extends FileProvider {
    private final Plugin plugIn;

    public EclipseFileProvider() {
        this(null);
    }

    public EclipseFileProvider(Plugin plugIn) {
        this.plugIn = plugIn;
    }

    public Module getJarFileModule(String fileName, ClassLoader loader) throws IOException {
        Module module;
        if (CorePlugin.getDefault() == null) {
            return this.getJarFileFromClassLoader(fileName, loader);
        }
        if (this.plugIn != null) {
            return this.getFromPlugin(this.plugIn, fileName);
        }
        if (CorePlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (module = EclipseUtil.getJarFileModule(fileName)) != null) {
            return module;
        }
        return this.getFromPlugin(CorePlugin.getDefault(), fileName);
    }

    private JarFileModule getFromPlugin(Plugin p, String fileName) throws IOException {
        URL url = this.getFileURLFromPlugin(p, fileName);
        if (url == null) {
            return null;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (JarFile jar = new JarFile(this.filePathFromURL(url));){
            return new JarFileModule(jar);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL getFileURLFromPlugin(Plugin p, String fileName) throws IOException {
        try {
            URL url = FileLocator.find((Bundle)p.getBundle(), (IPath)new Path(fileName), null);
            if (url == null) {
                String libFileName = "lib/" + fileName;
                url = FileLocator.find((Bundle)p.getBundle(), (IPath)new Path(libFileName), null);
                if (url == null) {
                    String binFileName = "bin/" + fileName;
                    url = FileLocator.find((Bundle)p.getBundle(), (IPath)new Path(binFileName), null);
                    if (url == null) {
                        File f = new File(fileName);
                        if (!f.exists()) {
                            return null;
                        }
                        url = f.toURI().toURL();
                    }
                }
            }
            url = FileLocator.toFileURL((URL)url);
            return this.fixupFileURLSpaces(url);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new IOException("failure to get file URL for " + fileName);
        }
    }

    private URL fixupFileURLSpaces(URL url) {
        String urlString = url.toExternalForm();
        StringBuffer fixedUpUrl = new StringBuffer();
        int lastIndex = 0;
        while (true) {
            int spaceIndex;
            if ((spaceIndex = urlString.indexOf(32, lastIndex)) < 0) break;
            fixedUpUrl.append(urlString.substring(lastIndex, spaceIndex));
            fixedUpUrl.append("%20");
            lastIndex = spaceIndex + 1;
        }
        fixedUpUrl.append(urlString.substring(lastIndex));
        try {
            return new URL(fixedUpUrl.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public URL getResource(String fileName, ClassLoader loader) throws IOException {
        CorePlugin p;
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        CorePlugin corePlugin = p = this.plugIn == null ? CorePlugin.getDefault() : this.plugIn;
        if (p == null && loader == null) {
            throw new IllegalArgumentException("null loader");
        }
        return p == null ? loader.getResource(fileName) : FileLocator.find((Bundle)p.getBundle(), (IPath)new Path(fileName), null);
    }

    public File getFile(String fileName, ClassLoader loader) throws IOException {
        CorePlugin p;
        CorePlugin corePlugin = p = this.plugIn == null ? CorePlugin.getDefault() : this.plugIn;
        if (p == null) {
            return this.getFileFromClassLoader(fileName, loader);
        }
        try {
            return this.getFileFromPlugin(p, fileName);
        }
        catch (IOException iOException) {
            return this.getFileFromClassLoader(fileName, loader);
        }
    }

    public File getFileFromPlugin(Plugin p, String fileName) throws IOException {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        URL url = this.getFileURLFromPlugin(p, fileName);
        if (url == null) {
            throw new FileNotFoundException(fileName);
        }
        return new File(this.filePathFromURL(url));
    }

    public static String getWalaCorePluginHome() {
        if (CorePlugin.getDefault() == null) {
            return null;
        }
        String install = Platform.getInstallLocation().getURL().getPath();
        Bundle b = Platform.getBundle((String)"com.ibm.wala.core");
        String l = b.getLocation();
        if (l.startsWith("update@")) {
            l = l.replace("update@", "");
        }
        if (l.startsWith("reference:file:")) {
            return l.replace("reference:file:", "");
        }
        return String.valueOf(install) + File.separator + l;
    }

    private static final class EclipseUtil {
        private static Object workspaceRoot = null;
        private static Method workspaceRoot_getFile = null;

        private EclipseUtil() {
        }

        public static Module getJarFileModule(String fileName) {
            try {
                if (workspaceRoot_getFile == null) {
                    Class<?> cls = Class.forName("org.eclipse.core.resources.ResourcesPlugin");
                    Method getWorkspaceMethod = cls.getDeclaredMethod("getWorkspace", new Class[0]);
                    Object workspace = getWorkspaceMethod.invoke(null, new Object[0]);
                    Method getRoot = workspace.getClass().getDeclaredMethod("getRoot", new Class[0]);
                    workspaceRoot = getRoot.invoke(workspace, new Object[0]);
                    workspaceRoot_getFile = workspaceRoot.getClass().getMethod("getFile", IPath.class);
                }
                Path path = new Path(fileName);
                if (workspaceRoot_getFile.invoke(workspaceRoot, path) != null) {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (JarFile jar = new JarFile(fileName, false);){
                        return new JarFileModule(jar);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception exception) {}
            return null;
        }
    }
}

