/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.ui;

import com.ibm.wala.ide.ui.AbstractJFaceRunner;
import com.ibm.wala.util.PlatformUtil;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.viz.NodeDecorator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SWTTreeViewer
extends AbstractJFaceRunner {
    protected Graph graphInput;
    protected Collection<? extends Object> rootsInput = null;
    protected NodeDecorator nodeDecoratorInput = null;
    protected final List<IAction> popUpActions = new LinkedList<IAction>();

    public Graph getGraphInput() {
        return this.graphInput;
    }

    public void setGraphInput(Graph newGraphInput) {
        this.graphInput = newGraphInput;
    }

    public Collection<? extends Object> getRootsInput() {
        return this.rootsInput;
    }

    public void setRootsInput(Collection<? extends Object> newRootsInput) {
        this.rootsInput = newRootsInput;
    }

    public NodeDecorator getNodeDecoratorInput() {
        return this.nodeDecoratorInput;
    }

    public void setNodeDecoratorInput(NodeDecorator newNodeDecoratorInput) {
        this.nodeDecoratorInput = newNodeDecoratorInput;
    }

    public List<IAction> getPopUpActions() {
        return this.popUpActions;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(", graphInput: ");
        result.append(this.graphInput);
        result.append(", rootsInput: ");
        result.append(this.rootsInput);
        result.append(", NodeDecoratorInput: ");
        result.append(this.nodeDecoratorInput);
        result.append(", popUpActions: ");
        result.append(this.popUpActions);
        result.append(')');
        return result.toString();
    }

    public void run() throws WalaException {
        if (this.getRootsInput() == null) {
            throw new WalaException("null roots input in " + this.getClass());
        }
        final GraphViewer w = new GraphViewer(this.getGraphInput());
        this.setApplicationWindow(w);
        w.setBlockOnOpen(true);
        if (PlatformUI.isWorkbenchRunning()) {
            Display d = PlatformUI.getWorkbench().getDisplay();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        w.open();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            if (this.isBlockInput()) {
                d.syncExec(r);
            } else {
                d.asyncExec(r);
            }
        } else if (PlatformUtil.onMacOSX()) {
            w.open();
            Display.getCurrent().dispose();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    w.open();
                    Display.getCurrent().dispose();
                }
            };
            Thread t = new Thread(r);
            t.start();
            if (this.isBlockInput()) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    throw new WalaException("unexpected interruption", (Throwable)e);
                }
            }
        }
    }

    public IStructuredSelection getSelection() throws IllegalStateException {
        GraphViewer viewer = (GraphViewer)this.getApplicationWindow();
        if (viewer == null || viewer.treeViewer == null) {
            throw new IllegalStateException();
        }
        return (IStructuredSelection)viewer.treeViewer.getSelection();
    }

    private class GraphViewer
    extends ApplicationWindow {
        private final Graph graph;
        private TreeViewer treeViewer;

        public GraphViewer(Graph graph) throws WalaException {
            super(null);
            this.graph = graph;
            if (graph == null) {
                throw new WalaException("null graph for SWT viewer");
            }
        }

        protected Control createContents(Composite parent) {
            this.treeViewer = new TreeViewer(parent);
            this.treeViewer.setContentProvider((IContentProvider)new GraphContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new GraphLabelProvider());
            this.treeViewer.setInput((Object)SWTTreeViewer.this.getGraphInput());
            if (SWTTreeViewer.this.getPopUpActions().size() > 0) {
                MenuManager mm = new MenuManager();
                this.treeViewer.getTree().setMenu(mm.createContextMenu((Control)this.treeViewer.getTree()));
                Iterator<IAction> it = SWTTreeViewer.this.getPopUpActions().iterator();
                while (it.hasNext()) {
                    mm.add(it.next());
                }
            }
            return this.treeViewer.getTree();
        }

        private class GraphContentProvider
        implements ITreeContentProvider {
            private GraphContentProvider() {
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                Object[] result = new Object[GraphViewer.this.graph.getSuccNodeCount(parentElement)];
                int i = 0;
                Iterator it = GraphViewer.this.graph.getSuccNodes(parentElement);
                while (it.hasNext()) {
                    result[i++] = it.next();
                }
                return result;
            }

            public Object getParent(Object element) {
                Assertions.UNREACHABLE();
                return null;
            }

            public boolean hasChildren(Object element) {
                return GraphViewer.this.graph.getSuccNodeCount(element) > 0;
            }

            public Object[] getElements(Object inputElement) {
                Collection<? extends Object> roots = SWTTreeViewer.this.getRootsInput();
                Assertions.productionAssertion((roots != null ? 1 : 0) != 0);
                Assertions.productionAssertion((roots.size() >= 1 ? 1 : 0) != 0);
                return roots.toArray();
            }
        }

        private class GraphLabelProvider
        extends LabelProvider {
            final NodeDecorator d;

            private GraphLabelProvider() {
                this.d = SWTTreeViewer.this.getNodeDecoratorInput();
            }

            public String getText(Object element) {
                try {
                    return this.d == null ? super.getText(element) : this.d.getLabel(element);
                }
                catch (WalaException e) {
                    e.printStackTrace();
                    Assertions.UNREACHABLE();
                    return null;
                }
            }
        }
    }
}

