/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.client;

import com.ibm.wala.ide.client.EclipseProjectAnalysisEngine;
import com.ibm.wala.ide.plugin.CorePlugin;
import com.ibm.wala.ide.util.EclipseFileProvider;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;

public abstract class EclipseProjectSourceAnalysisEngine<P, I extends InstanceKey>
extends EclipseProjectAnalysisEngine<P, I> {
    public static final String defaultFileExt = "java";
    final String fileExt;

    public EclipseProjectSourceAnalysisEngine(P project) throws IOException, CoreException {
        this(project, defaultFileExt);
    }

    public EclipseProjectSourceAnalysisEngine(P project, String fileExt) throws IOException, CoreException {
        super(project);
        this.fileExt = fileExt;
        try {
            this.setExclusionsFile(new EclipseFileProvider().getFileFromPlugin(CorePlugin.getDefault(), "J2SEClassHierarchyExclusions.txt").getAbsolutePath());
        }
        catch (IOException iOException) {
            try {
                this.setExclusionsFile(new FileProvider().getFile("J2SEClassHierarchyExclusions.txt", ((Object)((Object)this)).getClass().getClassLoader()).getAbsolutePath());
            }
            catch (IOException iOException2) {
                Assertions.UNREACHABLE((String)"Cannot find exclusions file");
            }
        }
    }

    public abstract IAnalysisCacheView makeDefaultCache();

    protected abstract ClassLoaderReference getSourceLoader();

    public AnalysisOptions getDefaultOptions(Iterable<Entrypoint> entrypoints) {
        AnalysisOptions options = new AnalysisOptions(this.getScope(), entrypoints);
        SSAOptions ssaOptions = new SSAOptions();
        ssaOptions.setDefaultValues(new SSAOptions.DefaultValues(){

            public int getDefaultValue(SymbolTable symtab, int valueNumber) {
                return symtab.getDefaultValue(valueNumber);
            }
        });
        options.setSSAOptions(ssaOptions);
        return options;
    }
}

