/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.client;

import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.ide.util.EclipseProjectPath;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.io.FileProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public abstract class EclipseProjectAnalysisEngine<P, I extends InstanceKey>
extends AbstractAnalysisEngine<I> {
    protected final P project;
    protected final IPath workspaceRootPath;
    protected EclipseProjectPath<?, P> ePath;

    public EclipseProjectAnalysisEngine(P project) throws IOException, CoreException {
        this.project = project;
        this.workspaceRootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        assert (project != null);
        assert (this.workspaceRootPath != null);
    }

    protected abstract EclipseProjectPath<?, P> createProjectPath(P var1) throws IOException, CoreException;

    protected abstract CallGraphBuilder getCallGraphBuilder(IClassHierarchy var1, AnalysisOptions var2, IAnalysisCacheView var3);

    protected abstract AnalysisScope makeAnalysisScope();

    public void buildAnalysisScope() throws IOException {
        block11: {
            try {
                this.ePath = this.createProjectPath(this.project);
                this.scope = this.ePath.toAnalysisScope(this.makeAnalysisScope());
                if (this.getExclusionsFile() == null) break block11;
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream is = new File(this.getExclusionsFile()).exists() ? new FileInputStream(this.getExclusionsFile()) : FileProvider.class.getClassLoader().getResourceAsStream(this.getExclusionsFile());){
                    this.scope.setExclusions((SetOfClasses)new FileOfClasses(is));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException e) {
                if ($assertionsDisabled) break block11;
                throw new AssertionError((Object)e.getMessage());
            }
        }
    }

    public EclipseProjectPath<?, P> getEclipseProjectPath() {
        return this.ePath;
    }

    public IClassHierarchy getClassHierarchy() {
        if (super.getClassHierarchy() == null) {
            this.setClassHierarchy(this.buildClassHierarchy());
        }
        return super.getClassHierarchy();
    }
}

