/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.controller;

import com.ibm.safe.controller.AbstractSafeController;
import com.ibm.safe.controller.BasicResultObserver;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.runners.CompositeSolverRunner;
import com.ibm.safe.lightweight.controller.LightweightRulesManager;
import com.ibm.safe.lightweight.controller.StructuralSolverRunner;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.rules.DummyRule;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.runners.IResultObserver;
import com.ibm.safe.runners.ISolverRunner;
import com.ibm.safe.typestate.controller.TypeStateSolverRunner;
import com.ibm.safe.typestate.controller.TypestateRulesManager;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.options.TypestateProperties;
import com.ibm.safe.utils.SafeLogger;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.util.CancelException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GenericSafeController
extends AbstractSafeController {
    public static final String NO_SOLVER_OPTIONS = "No solver options have been identified.\nAt least one structural or typestate option and rule should be activated.";

    public GenericSafeController(PropertiesManager thePropertiesManager) {
        super(thePropertiesManager);
    }

    public void execute(IRule[] rules, IReporter reporter, IProgressMonitor monitor) throws SafeException, CancelException, IllegalArgumentException, CoreException {
        if (!(this.isMining() || rules != null && rules.length != 0)) {
            throw new SetUpException("No rules");
        }
        CompositeSolverRunner solverRunner = new CompositeSolverRunner();
        PerformanceTracker perfoTracker = this.shouldUsePerfomanceTracker() ? new PerformanceTracker("Safe engine tracking report\n", PerformanceTracker.Kind.GLOBAL) : null;
        IRule[] typeStateRules = new IRule[]{};
        if (this.hasTypeStateOptionsActivated()) {
            TypestateRulesManager typestateRulesManager = new TypestateRulesManager(rules);
            typestateRulesManager.applyFilters(this.propertiesManager);
            typeStateRules = typestateRulesManager.getTypeStateRules();
        }
        IRule[] structuralRules = new IRule[]{};
        if (this.hasStructuralOptionsActivated()) {
            LightweightRulesManager lwRulesManager = new LightweightRulesManager(rules);
            lwRulesManager.applyFilters(this.propertiesManager);
            structuralRules = lwRulesManager.getStructuralRules();
        }
        this.reportRulesActivated(reporter, structuralRules, typeStateRules);
        if (this.hasStructuralOptionsActivated() && structuralRules.length > 0) {
            solverRunner.addSolverRunner((ISolverRunner)new StructuralSolverRunner(this.propertiesManager, structuralRules, perfoTracker, reporter));
        }
        if (this.hasTypeStateOptionsActivated() && (typeStateRules.length > 0 || this.propertiesManager.getBooleanValue((PropertiesManager.IPropertyDescriptor)TypestateProperties.Props.MINE_DFA))) {
            solverRunner.addSolverRunner(this.getTypeStateSolverRunner(this.propertiesManager, typeStateRules, perfoTracker, reporter));
        }
        if (solverRunner.isEmpty()) {
            throw new SetUpException(NO_SOLVER_OPTIONS);
        }
        this.execute(solverRunner, perfoTracker, reporter, reporter, monitor);
    }

    public ISolverRunner getTypeStateSolverRunner(PropertiesManager properties, IRule[] rules, PerformanceTracker perfoTracker, IReporter reporter) {
        TypeStateOptions tso = new TypeStateOptions(properties, rules);
        return new TypeStateSolverRunner(tso, rules, perfoTracker, reporter);
    }

    protected void execute(CompositeSolverRunner solverRunner, PerformanceTracker perfoTracker, IReporter originalReporter, IReporter realReporter, IProgressMonitor monitor) throws SafeException, CancelException, IllegalArgumentException, CoreException {
        try {
            try {
                if (this.shouldCreateDomoReport()) {
                    Trace.setTraceFile((String)this.propertiesManager.getStringValue((PropertiesManager.IPropertyDescriptor)CommonProperties.Props.DOMO_REPORT));
                }
                if (this.isVerboseMode()) {
                    this.displaySafeVersion(realReporter);
                }
                BasicResultObserver resultObserver = new BasicResultObserver(realReporter);
                monitor.beginTask(null, 1);
                solverRunner.run((IResultObserver)resultObserver, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                originalReporter.reportAnalysisStatus(resultObserver.getAnalysisStatus());
                originalReporter.reportNumberOfFindings(resultObserver.getNumberOfFindings());
            }
            catch (SafeException except) {
                realReporter.reportException((Throwable)except);
                throw except;
            }
        }
        finally {
            if (perfoTracker != null) {
                realReporter.reportPerformanceTracking(perfoTracker);
            }
            try {
                realReporter.produceFinalReport();
            }
            catch (Exception except) {
                except.printStackTrace();
                SafeLogger.severe((String)"Unable to create XML report.", (Throwable)except);
            }
        }
    }

    protected void reportRulesActivated(IReporter reporter, IRule[] structuralRules, IRule[] typeStateRules) throws PropertiesException {
        if (!this.isMining() && !this.hasNullDerefOptionsActivated() && structuralRules.length == 0 && typeStateRules.length == 0) {
            throw new PropertiesException("No SAFE rules have been activated.");
        }
        if (this.hasStructuralOptionsActivated()) {
            this.reportStructuralRulesActivated(reporter, structuralRules);
        }
        if (this.hasTypeStateOptionsActivated()) {
            this.reportStructuralRulesActivated(reporter, typeStateRules);
        }
    }

    protected void reportStructuralRulesActivated(IReporter reporter, IRule[] rules) throws PropertiesException {
        if (this.isMining()) {
            DummyRule miningRule = new DummyRule("mining");
            reporter.reportRuleLoading((IRule)miningRule);
            reporter.reportNumberOfRulesActivated(1);
        } else {
            int i = 0;
            while (i < rules.length) {
                reporter.reportRuleLoading(rules[i]);
                ++i;
            }
            if (rules.length > 0) {
                reporter.reportNumberOfRulesActivated(rules.length);
            }
        }
    }
}

