window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"cutlet": {"fullname": "cutlet", "modulename": "cutlet", "kind": "module", "doc": "<p><a href=\"https://polm-cutlet-demo-demo-0tur8v.streamlit.app/\"><img src=\"https://static.streamlit.io/badges/streamlit_badge_black_white.svg\" alt=\"Open in Streamlit\" /></a>\n<a href=\"https://pypi.org/project/cutlet/\"><img src=\"https://badge.fury.io/py/cutlet.svg\" alt=\"Current PyPI packages\" /></a></p>\n\n<h1 id=\"cutlet\">cutlet</h1>\n\n<p><img src=\"https://github.com/polm/cutlet/raw/master/cutlet.png\" width=125 height=125 alt=\"cutlet by Irasutoya\" /></p>\n\n<p>Cutlet is a tool to convert Japanese to romaji. Check out the <a href=\"https://polm-cutlet-demo-demo-0tur8v.streamlit.app/\">interactive demo</a>! Also see the <a href=\"https://polm.github.io/cutlet/cutlet.html\">docs</a> and the <a href=\"https://www.dampfkraft.com/nlp/cutlet-python-romaji-converter.html\">original blog post</a>. </p>\n\n<p><strong>issue\u3092\u82f1\u8a9e\u3067\u66f8\u304f\u5fc5\u8981\u306f\u3042\u308a\u307e\u305b\u3093\u3002</strong></p>\n\n<p>Features:</p>\n\n<ul>\n<li>support for <a href=\"https://en.wikipedia.org/wiki/Hepburn_romanization\">Modified Hepburn</a>, <a href=\"https://en.wikipedia.org/wiki/Kunrei-shiki_romanization\">Kunreisiki</a>, <a href=\"https://en.wikipedia.org/wiki/Nihon-shiki_romanization\">Nihonsiki</a> systems</li>\n<li>custom overrides for individual mappings</li>\n<li>custom overrides for specific words</li>\n<li>built in exceptions list (Tokyo, Osaka, etc.)</li>\n<li>uses foreign spelling when available in UniDic</li>\n<li>proper nouns are capitalized</li>\n<li>slug mode for url generation</li>\n</ul>\n\n<p>Things not supported:</p>\n\n<ul>\n<li>traditional Hepburn n-to-m: Shimbashi</li>\n<li>macrons or circumflexes: T\u014dky\u014d, T\u00f4ky\u00f4</li>\n<li>passport Hepburn: Satoh (but you can use an exception)</li>\n<li>hyphenating words</li>\n<li>Traditional Hepburn in general is not supported</li>\n</ul>\n\n<p>Internally, cutlet uses <a href=\"https://github.com/polm/fugashi\">fugashi</a>, so you can\nuse the same dictionary you use for normal tokenization.</p>\n\n<h2 id=\"installation\">Installation</h2>\n\n<p>Cutlet can be installed through pip as usual.</p>\n\n<pre><code>pip install cutlet\n</code></pre>\n\n<p>Note that if you don't have a MeCab dictionary installed you'll also have to\ninstall one. If you're just getting started\n<a href=\"https://github.com/polm/unidic-lite\">unidic-lite</a> is a good choice.</p>\n\n<pre><code>pip install unidic-lite\n</code></pre>\n\n<h2 id=\"usage\">Usage</h2>\n\n<p>A command-line script is included for quick testing. Just use <code>cutlet</code> and each\nline of stdin will be treated as a sentence. You can specify the system to use\n(<code>hepburn</code>, <code>kunrei</code>, <code>nippon</code>, or <code>nihon</code>) as the first argument.</p>\n\n<pre><code>$ cutlet\n\u30ed\u30fc\u30de\u5b57\u5909\u63db\u30d7\u30ed\u30b0\u30e9\u30e0\u4f5c\u3063\u3066\u307f\u305f\u3002\nRoma ji henkan program tsukutte mita.\n</code></pre>\n\n<p>In code:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">cutlet</span>\n<span class=\"n\">katsu</span> <span class=\"o\">=</span> <span class=\"n\">cutlet</span><span class=\"o\">.</span><span class=\"n\">Cutlet</span><span class=\"p\">()</span>\n<span class=\"n\">katsu</span><span class=\"o\">.</span><span class=\"n\">romaji</span><span class=\"p\">(</span><span class=\"s2\">&quot;\u30ab\u30c4\u30ab\u30ec\u30fc\u306f\u7f8e\u5473\u3057\u3044&quot;</span><span class=\"p\">)</span>\n<span class=\"c1\"># =&gt; &#39;Cutlet curry wa oishii&#39;</span>\n\n<span class=\"c1\"># you can print a slug suitable for urls</span>\n<span class=\"n\">katsu</span><span class=\"o\">.</span><span class=\"n\">slug</span><span class=\"p\">(</span><span class=\"s2\">&quot;\u30ab\u30c4\u30ab\u30ec\u30fc\u306f\u7f8e\u5473\u3057\u3044&quot;</span><span class=\"p\">)</span>\n<span class=\"c1\"># =&gt; &#39;cutlet-curry-wa-oishii&#39;</span>\n\n<span class=\"c1\"># You can disable using foreign spelling too</span>\n<span class=\"n\">katsu</span><span class=\"o\">.</span><span class=\"n\">use_foreign_spelling</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n<span class=\"n\">katsu</span><span class=\"o\">.</span><span class=\"n\">romaji</span><span class=\"p\">(</span><span class=\"s2\">&quot;\u30ab\u30c4\u30ab\u30ec\u30fc\u306f\u7f8e\u5473\u3057\u3044&quot;</span><span class=\"p\">)</span>\n<span class=\"c1\"># =&gt; &#39;Katsu karee wa oishii&#39;</span>\n\n<span class=\"c1\"># kunreisiki, nihonsiki work too</span>\n<span class=\"n\">katu</span> <span class=\"o\">=</span> <span class=\"n\">cutlet</span><span class=\"o\">.</span><span class=\"n\">Cutlet</span><span class=\"p\">(</span><span class=\"s1\">&#39;kunrei&#39;</span><span class=\"p\">)</span>\n<span class=\"n\">katu</span><span class=\"o\">.</span><span class=\"n\">romaji</span><span class=\"p\">(</span><span class=\"s2\">&quot;\u5bcc\u58eb\u5c71&quot;</span><span class=\"p\">)</span>\n<span class=\"c1\"># =&gt; &#39;Huzi yama&#39;</span>\n\n<span class=\"c1\"># comparison</span>\n<span class=\"n\">nkatu</span> <span class=\"o\">=</span> <span class=\"n\">cutlet</span><span class=\"o\">.</span><span class=\"n\">Cutlet</span><span class=\"p\">(</span><span class=\"s1\">&#39;nihon&#39;</span><span class=\"p\">)</span>\n\n<span class=\"n\">sent</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;\u5f7c\u5973\u306f\u738b\u3078\u306e\u624b\u7d19\u3092\u8aad\u307f\u4e0a\u3052\u305f\u3002&quot;</span>\n<span class=\"n\">katsu</span><span class=\"o\">.</span><span class=\"n\">romaji</span><span class=\"p\">(</span><span class=\"n\">sent</span><span class=\"p\">)</span>\n<span class=\"c1\"># =&gt; &#39;Kanojo wa ou e no tegami wo yomiageta.&#39;</span>\n<span class=\"n\">katu</span><span class=\"o\">.</span><span class=\"n\">romaji</span><span class=\"p\">(</span><span class=\"n\">sent</span><span class=\"p\">)</span>\n<span class=\"c1\"># =&gt; &#39;Kanozyo wa ou e no tegami o yomiageta.&#39;</span>\n<span class=\"n\">nkatu</span><span class=\"o\">.</span><span class=\"n\">romaji</span><span class=\"p\">(</span><span class=\"n\">sent</span><span class=\"p\">)</span>\n<span class=\"c1\"># =&gt; &#39;Kanozyo ha ou he no tegami wo yomiageta.&#39;</span>\n</code></pre>\n</div>\n\n<h2 id=\"alternatives\">Alternatives</h2>\n\n<ul>\n<li><a href=\"http://kakasi.namazu.org/index.html.ja\">kakasi</a>: Historically important, but not updated since 2014. </li>\n<li><a href=\"https://github.com/miurahr/pykakasi\">pykakasi</a>: self contained, it does segmentation on its own and uses its own dictionary.</li>\n<li><a href=\"https://github.com/hexenq/kuroshiro\">kuroshiro</a>: Javascript based.</li>\n<li><a href=\"https://github.com/gojp/kana\">kana</a>: Go based.</li>\n</ul>\n"}, "cutlet.Cutlet": {"fullname": "cutlet.Cutlet", "modulename": "cutlet", "qualname": "Cutlet", "kind": "class", "doc": "<p></p>\n"}, "cutlet.Cutlet.__init__": {"fullname": "cutlet.Cutlet.__init__", "modulename": "cutlet", "qualname": "Cutlet.__init__", "kind": "function", "doc": "<p>Create a Cutlet object, which holds configuration as well as\ntokenizer state.</p>\n\n<p><code>system</code> is <code>hepburn</code> by default, and may also be <code>kunrei</code> or\n<code>nihon</code>. <code>nippon</code> is permitted as a synonym for <code>nihon</code>.</p>\n\n<p>If <code>use_foreign_spelling</code> is true, output will use the foreign spelling\nprovided in a UniDic lemma when available. For example, \"\u30ab\u30c4\" will\nbecome \"cutlet\" instead of \"katsu\".</p>\n\n<p>If <code>ensure_ascii</code> is true, any non-ASCII characters that can't be\nromanized will be replaced with <code>?</code>. If false, they will be passed\nthrough.</p>\n\n<p>Typical usage:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">katsu</span> <span class=\"o\">=</span> <span class=\"n\">Cutlet</span><span class=\"p\">()</span>\n<span class=\"n\">roma</span> <span class=\"o\">=</span> <span class=\"n\">katsu</span><span class=\"o\">.</span><span class=\"n\">romaji</span><span class=\"p\">(</span><span class=\"s2\">&quot;\u30ab\u30c4\u30ab\u30ec\u30fc\u3092\u98df\u3079\u305f&quot;</span><span class=\"p\">)</span>\n<span class=\"c1\"># &quot;Cutlet curry wo tabeta&quot;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">system</span><span class=\"o\">=</span><span class=\"s1\">&#39;hepburn&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">use_foreign_spelling</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">ensure_ascii</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">mecab_args</span><span class=\"o\">=</span><span class=\"s1\">&#39;&#39;</span></span>)</span>"}, "cutlet.Cutlet.system": {"fullname": "cutlet.Cutlet.system", "modulename": "cutlet", "qualname": "Cutlet.system", "kind": "variable", "doc": "<p></p>\n"}, "cutlet.Cutlet.tagger": {"fullname": "cutlet.Cutlet.tagger", "modulename": "cutlet", "qualname": "Cutlet.tagger", "kind": "variable", "doc": "<p></p>\n"}, "cutlet.Cutlet.exceptions": {"fullname": "cutlet.Cutlet.exceptions", "modulename": "cutlet", "qualname": "Cutlet.exceptions", "kind": "variable", "doc": "<p></p>\n"}, "cutlet.Cutlet.use_tch": {"fullname": "cutlet.Cutlet.use_tch", "modulename": "cutlet", "qualname": "Cutlet.use_tch", "kind": "variable", "doc": "<p></p>\n"}, "cutlet.Cutlet.use_wa": {"fullname": "cutlet.Cutlet.use_wa", "modulename": "cutlet", "qualname": "Cutlet.use_wa", "kind": "variable", "doc": "<p></p>\n"}, "cutlet.Cutlet.use_he": {"fullname": "cutlet.Cutlet.use_he", "modulename": "cutlet", "qualname": "Cutlet.use_he", "kind": "variable", "doc": "<p></p>\n"}, "cutlet.Cutlet.use_wo": {"fullname": "cutlet.Cutlet.use_wo", "modulename": "cutlet", "qualname": "Cutlet.use_wo", "kind": "variable", "doc": "<p></p>\n"}, "cutlet.Cutlet.use_foreign_spelling": {"fullname": "cutlet.Cutlet.use_foreign_spelling", "modulename": "cutlet", "qualname": "Cutlet.use_foreign_spelling", "kind": "variable", "doc": "<p></p>\n"}, "cutlet.Cutlet.ensure_ascii": {"fullname": "cutlet.Cutlet.ensure_ascii", "modulename": "cutlet", "qualname": "Cutlet.ensure_ascii", "kind": "variable", "doc": "<p></p>\n"}, "cutlet.Cutlet.add_exception": {"fullname": "cutlet.Cutlet.add_exception", "modulename": "cutlet", "qualname": "Cutlet.add_exception", "kind": "function", "doc": "<p>Add an exception to the internal list.</p>\n\n<p>An exception overrides a whole token, for example to replace \"Toukyou\"\nwith \"Tokyo\". Note that it must match the tokenizer output and be a\nsingle token to work. To replace longer phrases, you'll need to use a\ndifferent strategy, like string replacement.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span>, </span><span class=\"param\"><span class=\"n\">val</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "cutlet.Cutlet.update_mapping": {"fullname": "cutlet.Cutlet.update_mapping", "modulename": "cutlet", "qualname": "Cutlet.update_mapping", "kind": "function", "doc": "<p>Update mapping table for a single kana.</p>\n\n<p>This can be used to mix common systems, or to modify particular\ndetails. For example, you can use <code>update_mapping(\"\u3062\", \"di\")</code> to\ndifferentiate \u3062 and \u3058 in Hepburn.</p>\n\n<p>Example usage:</p>\n\n<pre><code>cut = Cutlet()\ncut.romaji(\"\u304a\u8336\u6f2c\u3051\") # Ochazuke\ncut.update_mapping(\"\u3065\", \"du\")\ncut.romaji(\"\u304a\u8336\u6f2c\u3051\") # Ochaduke\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span>, </span><span class=\"param\"><span class=\"n\">val</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "cutlet.Cutlet.slug": {"fullname": "cutlet.Cutlet.slug", "modulename": "cutlet", "qualname": "Cutlet.slug", "kind": "function", "doc": "<p>Generate a URL-friendly slug.</p>\n\n<p>After converting the input to romaji using <code>Cutlet.romaji</code> and making\nthe result lower-case, any runs of non alpha-numeric characters are\nreplaced with a single hyphen. Any leading or trailing hyphens are\nstripped.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">text</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "cutlet.Cutlet.romaji_tokens": {"fullname": "cutlet.Cutlet.romaji_tokens", "modulename": "cutlet", "qualname": "Cutlet.romaji_tokens", "kind": "function", "doc": "<p>Build a list of tokens from input nodes.</p>\n\n<p>If <code>capitalize</code> is true, then the first letter of the first token will be\ncapitalized. This is typically the desired behavior if the input is a\ncomplete sentence.</p>\n\n<p>If <code>title</code> is true, then words will be capitalized as in a book title.\nThis means most words will be capitalized, but some parts of speech\n(particles, endings) will not.</p>\n\n<p>If the text was not normalized before being tokenized, the output is\nundefined. For details of normalization, see <code>normalize_text</code>.</p>\n\n<p>The number of output tokens will equal the number of input nodes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">words</span>, </span><span class=\"param\"><span class=\"n\">capitalize</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">title</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "cutlet.Cutlet.romaji": {"fullname": "cutlet.Cutlet.romaji", "modulename": "cutlet", "qualname": "Cutlet.romaji", "kind": "function", "doc": "<p>Build a complete string from input text.</p>\n\n<p>If <code>capitalize</code> is true, then the first letter of the text will be\ncapitalized. This is typically the desired behavior if the input is a\ncomplete sentence.</p>\n\n<p>If <code>title</code> is true, then words will be capitalized as in a book title.\nThis means most words will be capitalized, but some parts of speech\n(particles, endings) will not.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">text</span>, </span><span class=\"param\"><span class=\"n\">capitalize</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">title</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "cutlet.Cutlet.romaji_word": {"fullname": "cutlet.Cutlet.romaji_word", "modulename": "cutlet", "qualname": "Cutlet.romaji_word", "kind": "function", "doc": "<p>Return the romaji for a single word (node).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">word</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "cutlet.Cutlet.map_kana": {"fullname": "cutlet.Cutlet.map_kana", "modulename": "cutlet", "qualname": "Cutlet.map_kana", "kind": "function", "doc": "<p>Given a list of kana, convert them to romaji.</p>\n\n<p>The exact romaji resulting from a kana sequence depend on the preceding\nor following kana, so this handles that conversion.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">kana</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "cutlet.Cutlet.get_single_mapping": {"fullname": "cutlet.Cutlet.get_single_mapping", "modulename": "cutlet", "qualname": "Cutlet.get_single_mapping", "kind": "function", "doc": "<p>Given a single kana and its neighbors, return the mapped romaji.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">pk</span>, </span><span class=\"param\"><span class=\"n\">kk</span>, </span><span class=\"param\"><span class=\"n\">nk</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}}, "docInfo": {"cutlet": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 753}, "cutlet.Cutlet": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "cutlet.Cutlet.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 59, "bases": 0, "doc": 181}, "cutlet.Cutlet.system": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "cutlet.Cutlet.tagger": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "cutlet.Cutlet.exceptions": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "cutlet.Cutlet.use_tch": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "cutlet.Cutlet.use_wa": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "cutlet.Cutlet.use_he": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "cutlet.Cutlet.use_wo": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "cutlet.Cutlet.use_foreign_spelling": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "cutlet.Cutlet.ensure_ascii": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "cutlet.Cutlet.add_exception": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 56}, "cutlet.Cutlet.update_mapping": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 71}, "cutlet.Cutlet.slug": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 48}, "cutlet.Cutlet.romaji_tokens": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 119}, "cutlet.Cutlet.romaji": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 77}, "cutlet.Cutlet.romaji_word": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "cutlet.Cutlet.map_kana": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 35}, "cutlet.Cutlet.get_single_mapping": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 14}}, "length": 20, "save": true}, "index": {"qualname": {"root": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.system": {"tf": 1}, "cutlet.Cutlet.tagger": {"tf": 1}, "cutlet.Cutlet.exceptions": {"tf": 1}, "cutlet.Cutlet.use_tch": {"tf": 1}, "cutlet.Cutlet.use_wa": {"tf": 1}, "cutlet.Cutlet.use_he": {"tf": 1}, "cutlet.Cutlet.use_wo": {"tf": 1}, "cutlet.Cutlet.use_foreign_spelling": {"tf": 1}, "cutlet.Cutlet.ensure_ascii": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}, "cutlet.Cutlet.romaji_word": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 19}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"cutlet.Cutlet.system": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.use_foreign_spelling": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"cutlet.Cutlet.tagger": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"cutlet.Cutlet.use_tch": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1, "s": {"docs": {"cutlet.Cutlet.exceptions": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.ensure_ascii": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.use_tch": {"tf": 1}, "cutlet.Cutlet.use_wa": {"tf": 1}, "cutlet.Cutlet.use_he": {"tf": 1}, "cutlet.Cutlet.use_wo": {"tf": 1}, "cutlet.Cutlet.use_foreign_spelling": {"tf": 1}}, "df": 5}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {"cutlet.Cutlet.use_wa": {"tf": 1}}, "df": 1}, "o": {"docs": {"cutlet.Cutlet.use_wo": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.romaji_word": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.use_he": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.use_foreign_spelling": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "i": {"docs": {"cutlet.Cutlet.ensure_ascii": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 2}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "i": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}, "cutlet.Cutlet.romaji_word": {"tf": 1}}, "df": 3}}}}}}, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 1}}}}}, "fullname": {"root": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.__init__": {"tf": 1.4142135623730951}, "cutlet.Cutlet.system": {"tf": 1.4142135623730951}, "cutlet.Cutlet.tagger": {"tf": 1.4142135623730951}, "cutlet.Cutlet.exceptions": {"tf": 1.4142135623730951}, "cutlet.Cutlet.use_tch": {"tf": 1.4142135623730951}, "cutlet.Cutlet.use_wa": {"tf": 1.4142135623730951}, "cutlet.Cutlet.use_he": {"tf": 1.4142135623730951}, "cutlet.Cutlet.use_wo": {"tf": 1.4142135623730951}, "cutlet.Cutlet.use_foreign_spelling": {"tf": 1.4142135623730951}, "cutlet.Cutlet.ensure_ascii": {"tf": 1.4142135623730951}, "cutlet.Cutlet.add_exception": {"tf": 1.4142135623730951}, "cutlet.Cutlet.update_mapping": {"tf": 1.4142135623730951}, "cutlet.Cutlet.slug": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_word": {"tf": 1.4142135623730951}, "cutlet.Cutlet.map_kana": {"tf": 1.4142135623730951}, "cutlet.Cutlet.get_single_mapping": {"tf": 1.4142135623730951}}, "df": 20}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"cutlet.Cutlet.system": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.use_foreign_spelling": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"cutlet.Cutlet.tagger": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"cutlet.Cutlet.use_tch": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1, "s": {"docs": {"cutlet.Cutlet.exceptions": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.ensure_ascii": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.use_tch": {"tf": 1}, "cutlet.Cutlet.use_wa": {"tf": 1}, "cutlet.Cutlet.use_he": {"tf": 1}, "cutlet.Cutlet.use_wo": {"tf": 1}, "cutlet.Cutlet.use_foreign_spelling": {"tf": 1}}, "df": 5}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {"cutlet.Cutlet.use_wa": {"tf": 1}}, "df": 1}, "o": {"docs": {"cutlet.Cutlet.use_wo": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.romaji_word": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.use_he": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.use_foreign_spelling": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "i": {"docs": {"cutlet.Cutlet.ensure_ascii": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 2}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "i": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}, "cutlet.Cutlet.romaji_word": {"tf": 1}}, "df": 3}}}}}}, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 1}}}}}, "annotation": {"root": {"docs": {}, "df": 0}}, "default_value": {"root": {"docs": {}, "df": 0}}, "signature": {"root": {"3": {"9": {"docs": {"cutlet.Cutlet.__init__": {"tf": 2}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"cutlet.Cutlet.__init__": {"tf": 6.6332495807108}, "cutlet.Cutlet.add_exception": {"tf": 4.242640687119285}, "cutlet.Cutlet.update_mapping": {"tf": 4.242640687119285}, "cutlet.Cutlet.slug": {"tf": 3.7416573867739413}, "cutlet.Cutlet.romaji_tokens": {"tf": 5.477225575051661}, "cutlet.Cutlet.romaji": {"tf": 5.477225575051661}, "cutlet.Cutlet.romaji_word": {"tf": 3.7416573867739413}, "cutlet.Cutlet.map_kana": {"tf": 3.7416573867739413}, "cutlet.Cutlet.get_single_mapping": {"tf": 4.69041575982343}}, "df": 9, "s": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}, "cutlet.Cutlet.romaji_word": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 8}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "i": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}, "k": {"docs": {"cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 2}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.romaji_word": {"tf": 1}}, "df": 1, "s": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}}}}}}}, "p": {"docs": {}, "df": 0, "k": {"docs": {"cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "k": {"docs": {"cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 1}}}}, "bases": {"root": {"docs": {}, "df": 0}}, "doc": {"root": {"2": {"0": {"1": {"4": {"docs": {"cutlet": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "3": {"9": {"docs": {"cutlet": {"tf": 4.242640687119285}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"cutlet": {"tf": 19.6468827043885}, "cutlet.Cutlet": {"tf": 1.7320508075688772}, "cutlet.Cutlet.__init__": {"tf": 9.055385138137417}, "cutlet.Cutlet.system": {"tf": 1.7320508075688772}, "cutlet.Cutlet.tagger": {"tf": 1.7320508075688772}, "cutlet.Cutlet.exceptions": {"tf": 1.7320508075688772}, "cutlet.Cutlet.use_tch": {"tf": 1.7320508075688772}, "cutlet.Cutlet.use_wa": {"tf": 1.7320508075688772}, "cutlet.Cutlet.use_he": {"tf": 1.7320508075688772}, "cutlet.Cutlet.use_wo": {"tf": 1.7320508075688772}, "cutlet.Cutlet.use_foreign_spelling": {"tf": 1.7320508075688772}, "cutlet.Cutlet.ensure_ascii": {"tf": 1.7320508075688772}, "cutlet.Cutlet.add_exception": {"tf": 2.449489742783178}, "cutlet.Cutlet.update_mapping": {"tf": 4.898979485566356}, "cutlet.Cutlet.slug": {"tf": 2.8284271247461903}, "cutlet.Cutlet.romaji_tokens": {"tf": 4.58257569495584}, "cutlet.Cutlet.romaji": {"tf": 3.605551275463989}, "cutlet.Cutlet.romaji_word": {"tf": 1.7320508075688772}, "cutlet.Cutlet.map_kana": {"tf": 2.449489742783178}, "cutlet.Cutlet.get_single_mapping": {"tf": 1.7320508075688772}}, "df": 20, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 2}}, "df": 1, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 4}, "cutlet.Cutlet.__init__": {"tf": 2}, "cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}}, "df": 4}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}}, "df": 2}}}}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2, "d": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.7320508075688772}, "cutlet.Cutlet.romaji": {"tf": 1.7320508075688772}}, "df": 3}}}}}}}}}, "n": {"docs": {"cutlet": {"tf": 2.449489742783178}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1.4142135623730951}}, "df": 3}, "s": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"cutlet": {"tf": 2}, "cutlet.Cutlet.__init__": {"tf": 2}, "cutlet.Cutlet.romaji_tokens": {"tf": 2.23606797749979}, "cutlet.Cutlet.romaji": {"tf": 2}}, "df": 4, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {"cutlet": {"tf": 2}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 5, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"cutlet": {"tf": 1.7320508075688772}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.7320508075688772}, "cutlet.Cutlet.romaji": {"tf": 1.4142135623730951}}, "df": 3}}}}, "f": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.__init__": {"tf": 1.7320508075688772}, "cutlet.Cutlet.romaji_tokens": {"tf": 2}, "cutlet.Cutlet.romaji": {"tf": 1.7320508075688772}}, "df": 4}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 2, "s": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 2}}}, "a": {"docs": {"cutlet": {"tf": 2.449489742783178}, "cutlet.Cutlet.__init__": {"tf": 1.7320508075688772}, "cutlet.Cutlet.add_exception": {"tf": 1.7320508075688772}, "cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.7320508075688772}, "cutlet.Cutlet.romaji": {"tf": 1.7320508075688772}, "cutlet.Cutlet.romaji_word": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1.4142135623730951}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 10, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1.4142135623730951}}, "df": 2, "d": {"docs": {"cutlet": {"tf": 1.7320508075688772}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 6}, "y": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1.4142135623730951}}, "df": 2}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1.4142135623730951}}, "df": 2}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"cutlet": {"tf": 1.7320508075688772}, "cutlet.Cutlet.__init__": {"tf": 1.7320508075688772}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "i": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2, "o": {"docs": {"cutlet": {"tf": 2.23606797749979}, "cutlet.Cutlet.add_exception": {"tf": 2.23606797749979}, "cutlet.Cutlet.update_mapping": {"tf": 1.7320508075688772}, "cutlet.Cutlet.slug": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 5, "o": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "k": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "o": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 2}, "d": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 2.449489742783178}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1.4142135623730951}, "cutlet.Cutlet.slug": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_tokens": {"tf": 2.8284271247461903}, "cutlet.Cutlet.romaji": {"tf": 2}, "cutlet.Cutlet.romaji_word": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1.4142135623730951}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 9, "y": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}, "n": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji": {"tf": 1.4142135623730951}}, "df": 2}, "m": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji": {"tf": 1.4142135623730951}, "cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 4}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 4}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji": {"tf": 1.4142135623730951}}, "df": 3}}}, "\u014d": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "y": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "\u00f4": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "y": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 1.7320508075688772}}, "df": 1}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji": {"tf": 1.4142135623730951}}, "df": 2}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "j": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}}, "i": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2, "j": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 2.6457513110645907}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1.4142135623730951}, "cutlet.Cutlet.slug": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_word": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1.4142135623730951}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 7}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1.4142135623730951}}, "df": 1, "d": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}}, "df": 2}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.romaji_word": {"tf": 1}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "u": {"docs": {"cutlet": {"tf": 1.7320508075688772}}, "df": 1, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "r": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 2}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 2, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "f": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 2.449489742783178}, "cutlet.Cutlet.romaji": {"tf": 1.4142135623730951}, "cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "n": {"docs": {"cutlet": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "i": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"cutlet": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "u": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 2}, "n": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 2}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 3}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2, "s": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "m": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "y": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet": {"tf": 1.7320508075688772}, "cutlet.Cutlet.__init__": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"cutlet": {"tf": 1.7320508075688772}, "cutlet.Cutlet.slug": {"tf": 1}}, "df": 2}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "h": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "o": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 2, "m": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "y": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}, "cutlet.Cutlet.romaji_word": {"tf": 1}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 5}}}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1}, "d": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}, "t": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 3}}, "e": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.__init__": {"tf": 2}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.7320508075688772}, "cutlet.Cutlet.romaji": {"tf": 1.7320508075688772}}, "df": 6, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}}}, "y": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"cutlet": {"tf": 1.7320508075688772}}, "df": 1}}, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"cutlet": {"tf": 2.6457513110645907}, "cutlet.Cutlet.__init__": {"tf": 1.4142135623730951}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji_word": {"tf": 1}}, "df": 6, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1.7320508075688772}, "cutlet.Cutlet.__init__": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 3}}}}, "m": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "x": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 2.23606797749979}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 3}}}}}, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "v": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {"cutlet": {"tf": 2.6457513110645907}, "cutlet.Cutlet.__init__": {"tf": 1.7320508075688772}}, "df": 2}}, "u": {"docs": {"cutlet": {"tf": 1.7320508075688772}}, "df": 1}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "o": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "z": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "o": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}}}, "a": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1.7320508075688772}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 4}}, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.__init__": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {"cutlet": {"tf": 1.7320508075688772}}, "df": 1, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"cutlet": {"tf": 1.7320508075688772}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 3, "e": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1, "d": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}}}}}}}}}}, "n": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}}, "df": 2}, "d": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.romaji_word": {"tf": 1}}, "df": 1, "s": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2, "r": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.romaji_word": {"tf": 1}}, "df": 1, "s": {"docs": {"cutlet": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji_tokens": {"tf": 1.4142135623730951}, "cutlet.Cutlet.romaji": {"tf": 1.4142135623730951}}, "df": 3}}, "k": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 2}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 2}, "cutlet.Cutlet.romaji_tokens": {"tf": 2.23606797749979}, "cutlet.Cutlet.romaji": {"tf": 2}}, "df": 4}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}}, "df": 3}}}, "a": {"docs": {"cutlet": {"tf": 2.23606797749979}}, "df": 1, "s": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1.4142135623730951}}, "df": 3}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.map_kana": {"tf": 1}}, "df": 4}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1.4142135623730951}}, "df": 1}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}, "l": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"cutlet.Cutlet.__init__": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}, "cutlet.Cutlet.romaji": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"cutlet.Cutlet.add_exception": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 2.449489742783178}, "cutlet.Cutlet.__init__": {"tf": 1.4142135623730951}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 4, "s": {"docs": {"cutlet": {"tf": 1.7320508075688772}}, "df": 1}, "d": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.__init__": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"cutlet": {"tf": 1.7320508075688772}, "cutlet.Cutlet.__init__": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"cutlet.Cutlet.romaji_tokens": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "l": {"docs": {"cutlet": {"tf": 1}, "cutlet.Cutlet.slug": {"tf": 1}}, "df": 2, "s": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"cutlet.Cutlet.update_mapping": {"tf": 1.7320508075688772}}, "df": 1, "d": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"cutlet.Cutlet.slug": {"tf": 1}}, "df": 1}}, "l": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {"cutlet": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "d": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"cutlet": {"tf": 2.6457513110645907}}, "df": 1}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"cutlet.Cutlet.map_kana": {"tf": 1}, "cutlet.Cutlet.get_single_mapping": {"tf": 1}}, "df": 2}}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {"cutlet": {"tf": 3}, "cutlet.Cutlet.add_exception": {"tf": 1}, "cutlet.Cutlet.update_mapping": {"tf": 1}}, "df": 3}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"cutlet": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"cutlet": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"cutlet": {"tf": 3.1622776601683795}, "cutlet.Cutlet.__init__": {"tf": 2}}, "df": 2}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();