# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/), and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

<!--
Boilerplate to copy paste and adapt at each release

Take this line and fix version with current ($CV)
## [Unreleased](https://github.com/plx-pdg/plx/compare/$CV...HEAD)

### Added
### Changed

## [$CV without v!](https://github.com/plx-pdg/plx/compare/$CV before...$CV now) - $DATE
-->

## [Unreleased](https://github.com/plx-pdg/plx/compare/v0.2.0...HEAD)

### Added
### Changed

## [0.2.0](https://github.com/plx-pdg/plx/compare/v0.1.2...v0.2.0) - 2024-09-06

### Added
- Home page with ASCII art, quick help and tagline
- Help page to see all shortcuts and alternatives
- List page to browse skills and exos list
- Exo preview inside List page to show exo instruction without starting to compile it
- Train page to do an exo from start to end
- Automatic reload of checks when saving one of the exo files
- Open `$EDITOR` (only GUI IDE right now) when opening a new exo
- Show checks details with a nice word level diff generated by `similar`.
- Show a Solution page with basic syntax highlighting via `syntect`
- Support an exo structure with course - skills - exo hierarchy, with metadata described in TOML
- Enable parsing TOML files directly into Rust structs using `serde` and `toml` crates.
- Generate a lot of various errors for parsing, process and workers execution. We don't display them yet. When running `plx` in a folder without `course.toml`, the TUI will not start. It only displays skills and exos that were successfully parsed.
- Create examples exos for manual and automated testings under folder `examples`
- Switch to next exo when exo is done
- Start to store exo state (In progress, Done) but this is not fully working, therefore not displayed
- Create a logo ! Inspired from Delibay and PRJS gradient styles
- Write logs to `debug.log` via crate `log` and `simplelog` to see events received by core and not make noise in the UI

### Changed
- Run CI with macos runner, in addition to Ubuntu and Windows
- Rewrite a concise README in English and include it for `crates.io` release

## [0.1.2](https://github.com/plx-pdg/plx/compare/v0.1.1...v0.1.2) - 2024-08-26

### Added
- Trivial change to show CI release

## [0.1.1](https://github.com/plx-pdg/plx/compare/v0.1.0..v0.1.1) - 2024-08-21

### Added
- Add CI/CD jobs for build+test+formatting+tag+release (this release is used to test everything is working).
- Do a small change in `main.rs` output to see changes

## [0.1.0](https://github.com/plx-pdg/plx/compare/ceae2aa..v0.1.0) - 2024-08-19

### Added
- Create an empty Rust crate to reserve the name on [`crates.io`](https://crates.io/crates/plx) with Markdown excluded (it will be reincluded later) when the main README will be rewritten in English and be shorter...
- Define `license-file = "LICENSE"`  in `Cargo.toml` and create a `LICENSE` file with `All rights reserved` mention, just to be able to run `cargo publish`. There is no SPDX license identifier for "proprietary".
- Write first version of README in french with WHY and context details, in addition to the learning experience and the planned features.
