/**
 * Generated by orval v7.3.0 🍺
 * Do not edit manually.
 * Plotwist
 * OpenAPI spec version: 0.1.0
 */
import {
  useMutation,
  useQuery,
  useSuspenseQuery
} from '@tanstack/react-query'
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseQueryResult,
  MutationFunction,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult,
  UseSuspenseQueryOptions,
  UseSuspenseQueryResult
} from '@tanstack/react-query'
import type {
  GetMe200,
  GetUserById201,
  GetUserById409,
  GetUserById500,
  GetUsersAvailableEmail200,
  GetUsersAvailableEmail409,
  GetUsersAvailableEmailParams,
  GetUsersAvailableUsername200,
  GetUsersAvailableUsername409,
  GetUsersAvailableUsernameParams,
  GetUsersUsername200,
  PatchUser200,
  PatchUserBody,
  PatchUserPassword200,
  PatchUserPasswordBody,
  PostUsersCreate201,
  PostUsersCreate409,
  PostUsersCreate500,
  PostUsersCreateBody
} from './endpoints.schemas'
import { axiosInstance } from '../services/axios-instance';




/**
 * Create a user
 */
export const postUsersCreate = (
    postUsersCreateBody: PostUsersCreateBody,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<PostUsersCreate201>(
      {url: `/users/create`, method: 'POST',
      headers: {'Content-Type': 'application/json', },
      data: postUsersCreateBody, signal
    },
      );
    }
  


export const getPostUsersCreateMutationOptions = <TError = PostUsersCreate409 | PostUsersCreate500,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsersCreate>>, TError,{data: PostUsersCreateBody}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof postUsersCreate>>, TError,{data: PostUsersCreateBody}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postUsersCreate>>, {data: PostUsersCreateBody}> = (props) => {
          const {data} = props ?? {};

          return  postUsersCreate(data,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostUsersCreateMutationResult = NonNullable<Awaited<ReturnType<typeof postUsersCreate>>>
    export type PostUsersCreateMutationBody = PostUsersCreateBody
    export type PostUsersCreateMutationError = PostUsersCreate409 | PostUsersCreate500

    export const usePostUsersCreate = <TError = PostUsersCreate409 | PostUsersCreate500,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsersCreate>>, TError,{data: PostUsersCreateBody}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof postUsersCreate>>,
        TError,
        {data: PostUsersCreateBody},
        TContext
      > => {

      const mutationOptions = getPostUsersCreateMutationOptions(options);

      return useMutation(mutationOptions);
    }
    /**
 * Check if this username is available
 */
export const getUsersAvailableUsername = (
    params: GetUsersAvailableUsernameParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUsersAvailableUsername200>(
      {url: `/users/available-username`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetUsersAvailableUsernameQueryKey = (params: GetUsersAvailableUsernameParams,) => {
    return [`/users/available-username`, ...(params ? [params]: [])] as const;
    }

    
export const getGetUsersAvailableUsernameQueryOptions = <TData = Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError = GetUsersAvailableUsername409>(params: GetUsersAvailableUsernameParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersAvailableUsernameQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersAvailableUsername>>> = ({ signal }) => getUsersAvailableUsername(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUsersAvailableUsernameQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersAvailableUsername>>>
export type GetUsersAvailableUsernameQueryError = GetUsersAvailableUsername409


export function useGetUsersAvailableUsername<TData = Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError = GetUsersAvailableUsername409>(
 params: GetUsersAvailableUsernameParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersAvailableUsername>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersAvailableUsername<TData = Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError = GetUsersAvailableUsername409>(
 params: GetUsersAvailableUsernameParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersAvailableUsername>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersAvailableUsername<TData = Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError = GetUsersAvailableUsername409>(
 params: GetUsersAvailableUsernameParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUsersAvailableUsername<TData = Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError = GetUsersAvailableUsername409>(
 params: GetUsersAvailableUsernameParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUsersAvailableUsernameQueryOptions(params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUsersAvailableUsernameSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError = GetUsersAvailableUsername409>(params: GetUsersAvailableUsernameParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersAvailableUsernameQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersAvailableUsername>>> = ({ signal }) => getUsersAvailableUsername(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUsersAvailableUsernameSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersAvailableUsername>>>
export type GetUsersAvailableUsernameSuspenseQueryError = GetUsersAvailableUsername409


export function useGetUsersAvailableUsernameSuspense<TData = Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError = GetUsersAvailableUsername409>(
 params: GetUsersAvailableUsernameParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersAvailableUsernameSuspense<TData = Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError = GetUsersAvailableUsername409>(
 params: GetUsersAvailableUsernameParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersAvailableUsernameSuspense<TData = Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError = GetUsersAvailableUsername409>(
 params: GetUsersAvailableUsernameParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUsersAvailableUsernameSuspense<TData = Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError = GetUsersAvailableUsername409>(
 params: GetUsersAvailableUsernameParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableUsername>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUsersAvailableUsernameSuspenseQueryOptions(params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Check if this email is available
 */
export const getUsersAvailableEmail = (
    params: GetUsersAvailableEmailParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUsersAvailableEmail200>(
      {url: `/users/available-email`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetUsersAvailableEmailQueryKey = (params: GetUsersAvailableEmailParams,) => {
    return [`/users/available-email`, ...(params ? [params]: [])] as const;
    }

    
export const getGetUsersAvailableEmailQueryOptions = <TData = Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError = GetUsersAvailableEmail409>(params: GetUsersAvailableEmailParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersAvailableEmailQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersAvailableEmail>>> = ({ signal }) => getUsersAvailableEmail(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUsersAvailableEmailQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersAvailableEmail>>>
export type GetUsersAvailableEmailQueryError = GetUsersAvailableEmail409


export function useGetUsersAvailableEmail<TData = Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError = GetUsersAvailableEmail409>(
 params: GetUsersAvailableEmailParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersAvailableEmail>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersAvailableEmail<TData = Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError = GetUsersAvailableEmail409>(
 params: GetUsersAvailableEmailParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersAvailableEmail>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersAvailableEmail<TData = Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError = GetUsersAvailableEmail409>(
 params: GetUsersAvailableEmailParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUsersAvailableEmail<TData = Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError = GetUsersAvailableEmail409>(
 params: GetUsersAvailableEmailParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUsersAvailableEmailQueryOptions(params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUsersAvailableEmailSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError = GetUsersAvailableEmail409>(params: GetUsersAvailableEmailParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersAvailableEmailQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersAvailableEmail>>> = ({ signal }) => getUsersAvailableEmail(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUsersAvailableEmailSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersAvailableEmail>>>
export type GetUsersAvailableEmailSuspenseQueryError = GetUsersAvailableEmail409


export function useGetUsersAvailableEmailSuspense<TData = Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError = GetUsersAvailableEmail409>(
 params: GetUsersAvailableEmailParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersAvailableEmailSuspense<TData = Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError = GetUsersAvailableEmail409>(
 params: GetUsersAvailableEmailParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersAvailableEmailSuspense<TData = Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError = GetUsersAvailableEmail409>(
 params: GetUsersAvailableEmailParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUsersAvailableEmailSuspense<TData = Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError = GetUsersAvailableEmail409>(
 params: GetUsersAvailableEmailParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersAvailableEmail>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUsersAvailableEmailSuspenseQueryOptions(params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user by username
 */
export const getUsersUsername = (
    username: string,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUsersUsername200>(
      {url: `/users/${username}`, method: 'GET', signal
    },
      );
    }
  

export const getGetUsersUsernameQueryKey = (username: string,) => {
    return [`/users/${username}`] as const;
    }

    
export const getGetUsersUsernameQueryOptions = <TData = Awaited<ReturnType<typeof getUsersUsername>>, TError = unknown>(username: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersUsernameQueryKey(username);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersUsername>>> = ({ signal }) => getUsersUsername(username, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(username), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUsersUsernameQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersUsername>>>
export type GetUsersUsernameQueryError = unknown


export function useGetUsersUsername<TData = Awaited<ReturnType<typeof getUsersUsername>>, TError = unknown>(
 username: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersUsername>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersUsername<TData = Awaited<ReturnType<typeof getUsersUsername>>, TError = unknown>(
 username: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersUsername>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersUsername<TData = Awaited<ReturnType<typeof getUsersUsername>>, TError = unknown>(
 username: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUsersUsername<TData = Awaited<ReturnType<typeof getUsersUsername>>, TError = unknown>(
 username: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUsersUsernameQueryOptions(username,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUsersUsernameSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUsersUsername>>, TError = unknown>(username: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersUsernameQueryKey(username);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersUsername>>> = ({ signal }) => getUsersUsername(username, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUsersUsernameSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersUsername>>>
export type GetUsersUsernameSuspenseQueryError = unknown


export function useGetUsersUsernameSuspense<TData = Awaited<ReturnType<typeof getUsersUsername>>, TError = unknown>(
 username: string, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersUsernameSuspense<TData = Awaited<ReturnType<typeof getUsersUsername>>, TError = unknown>(
 username: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUsersUsernameSuspense<TData = Awaited<ReturnType<typeof getUsersUsername>>, TError = unknown>(
 username: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUsersUsernameSuspense<TData = Awaited<ReturnType<typeof getUsersUsername>>, TError = unknown>(
 username: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUsersUsername>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUsersUsernameSuspenseQueryOptions(username,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user by
 */
export const getUserById = (
    id: string,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserById201>(
      {url: `/user/by/${id}`, method: 'GET', signal
    },
      );
    }
  

export const getGetUserByIdQueryKey = (id: string,) => {
    return [`/user/by/${id}`] as const;
    }

    
export const getGetUserByIdQueryOptions = <TData = Awaited<ReturnType<typeof getUserById>>, TError = GetUserById409 | GetUserById500>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserByIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserById>>> = ({ signal }) => getUserById(id, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserByIdQueryResult = NonNullable<Awaited<ReturnType<typeof getUserById>>>
export type GetUserByIdQueryError = GetUserById409 | GetUserById500


export function useGetUserById<TData = Awaited<ReturnType<typeof getUserById>>, TError = GetUserById409 | GetUserById500>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserById>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserById<TData = Awaited<ReturnType<typeof getUserById>>, TError = GetUserById409 | GetUserById500>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserById>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserById<TData = Awaited<ReturnType<typeof getUserById>>, TError = GetUserById409 | GetUserById500>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserById<TData = Awaited<ReturnType<typeof getUserById>>, TError = GetUserById409 | GetUserById500>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserByIdQueryOptions(id,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserByIdSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserById>>, TError = GetUserById409 | GetUserById500>(id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserByIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserById>>> = ({ signal }) => getUserById(id, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserByIdSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserById>>>
export type GetUserByIdSuspenseQueryError = GetUserById409 | GetUserById500


export function useGetUserByIdSuspense<TData = Awaited<ReturnType<typeof getUserById>>, TError = GetUserById409 | GetUserById500>(
 id: string, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserByIdSuspense<TData = Awaited<ReturnType<typeof getUserById>>, TError = GetUserById409 | GetUserById500>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserByIdSuspense<TData = Awaited<ReturnType<typeof getUserById>>, TError = GetUserById409 | GetUserById500>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserByIdSuspense<TData = Awaited<ReturnType<typeof getUserById>>, TError = GetUserById409 | GetUserById500>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserById>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserByIdSuspenseQueryOptions(id,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get me
 */
export const getMe = (
    
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetMe200>(
      {url: `/me`, method: 'GET', signal
    },
      );
    }
  

export const getGetMeQueryKey = () => {
    return [`/me`] as const;
    }

    
export const getGetMeQueryOptions = <TData = Awaited<ReturnType<typeof getMe>>, TError = unknown>( options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetMeQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getMe>>> = ({ signal }) => getMe(signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetMeQueryResult = NonNullable<Awaited<ReturnType<typeof getMe>>>
export type GetMeQueryError = unknown


export function useGetMe<TData = Awaited<ReturnType<typeof getMe>>, TError = unknown>(
  options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMe>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetMe<TData = Awaited<ReturnType<typeof getMe>>, TError = unknown>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMe>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetMe<TData = Awaited<ReturnType<typeof getMe>>, TError = unknown>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetMe<TData = Awaited<ReturnType<typeof getMe>>, TError = unknown>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetMeQueryOptions(options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetMeSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getMe>>, TError = unknown>( options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetMeQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getMe>>> = ({ signal }) => getMe(signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetMeSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getMe>>>
export type GetMeSuspenseQueryError = unknown


export function useGetMeSuspense<TData = Awaited<ReturnType<typeof getMe>>, TError = unknown>(
  options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetMeSuspense<TData = Awaited<ReturnType<typeof getMe>>, TError = unknown>(
  options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetMeSuspense<TData = Awaited<ReturnType<typeof getMe>>, TError = unknown>(
  options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetMeSuspense<TData = Awaited<ReturnType<typeof getMe>>, TError = unknown>(
  options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getMe>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetMeSuspenseQueryOptions(options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Update user
 */
export const patchUser = (
    patchUserBody: PatchUserBody,
 ) => {
      
      
      return axiosInstance<PatchUser200>(
      {url: `/user`, method: 'PATCH',
      headers: {'Content-Type': 'application/json', },
      data: patchUserBody
    },
      );
    }
  


export const getPatchUserMutationOptions = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof patchUser>>, TError,{data: PatchUserBody}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof patchUser>>, TError,{data: PatchUserBody}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof patchUser>>, {data: PatchUserBody}> = (props) => {
          const {data} = props ?? {};

          return  patchUser(data,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PatchUserMutationResult = NonNullable<Awaited<ReturnType<typeof patchUser>>>
    export type PatchUserMutationBody = PatchUserBody
    export type PatchUserMutationError = unknown

    export const usePatchUser = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof patchUser>>, TError,{data: PatchUserBody}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof patchUser>>,
        TError,
        {data: PatchUserBody},
        TContext
      > => {

      const mutationOptions = getPatchUserMutationOptions(options);

      return useMutation(mutationOptions);
    }
    /**
 * Update user password
 */
export const patchUserPassword = (
    patchUserPasswordBody: PatchUserPasswordBody,
 ) => {
      
      
      return axiosInstance<PatchUserPassword200>(
      {url: `/user/password`, method: 'PATCH',
      headers: {'Content-Type': 'application/json', },
      data: patchUserPasswordBody
    },
      );
    }
  


export const getPatchUserPasswordMutationOptions = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof patchUserPassword>>, TError,{data: PatchUserPasswordBody}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof patchUserPassword>>, TError,{data: PatchUserPasswordBody}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof patchUserPassword>>, {data: PatchUserPasswordBody}> = (props) => {
          const {data} = props ?? {};

          return  patchUserPassword(data,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PatchUserPasswordMutationResult = NonNullable<Awaited<ReturnType<typeof patchUserPassword>>>
    export type PatchUserPasswordMutationBody = PatchUserPasswordBody
    export type PatchUserPasswordMutationError = unknown

    export const usePatchUserPassword = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof patchUserPassword>>, TError,{data: PatchUserPasswordBody}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof patchUserPassword>>,
        TError,
        {data: PatchUserPasswordBody},
        TContext
      > => {

      const mutationOptions = getPatchUserPasswordMutationOptions(options);

      return useMutation(mutationOptions);
    }
    