/**
 * Generated by orval v7.3.0 🍺
 * Do not edit manually.
 * Plotwist
 * OpenAPI spec version: 0.1.0
 */
import {
  useQuery,
  useSuspenseQuery
} from '@tanstack/react-query'
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseQueryResult,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseQueryOptions,
  UseQueryResult,
  UseSuspenseQueryOptions,
  UseSuspenseQueryResult
} from '@tanstack/react-query'
import type {
  GetUserIdBestReviews200,
  GetUserIdBestReviewsParams,
  GetUserIdItemsStatus200,
  GetUserIdMostWatchedSeries200,
  GetUserIdMostWatchedSeriesParams,
  GetUserIdReviewsCount200,
  GetUserIdStats200,
  GetUserIdTotalHours200,
  GetUserIdWatchedCast200,
  GetUserIdWatchedCastParams,
  GetUserIdWatchedCountries200,
  GetUserIdWatchedCountriesParams,
  GetUserIdWatchedGenres200,
  GetUserIdWatchedGenresParams
} from './endpoints.schemas'
import { axiosInstance } from '../services/axios-instance';




/**
 * Get user stats
 */
export const getUserIdStats = (
    id: string,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserIdStats200>(
      {url: `/user/${id}/stats`, method: 'GET', signal
    },
      );
    }
  

export const getGetUserIdStatsQueryKey = (id: string,) => {
    return [`/user/${id}/stats`] as const;
    }

    
export const getGetUserIdStatsQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdStats>>, TError = unknown>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdStatsQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdStats>>> = ({ signal }) => getUserIdStats(id, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdStatsQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdStats>>>
export type GetUserIdStatsQueryError = unknown


export function useGetUserIdStats<TData = Awaited<ReturnType<typeof getUserIdStats>>, TError = unknown>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdStats>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdStats<TData = Awaited<ReturnType<typeof getUserIdStats>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdStats>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdStats<TData = Awaited<ReturnType<typeof getUserIdStats>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdStats<TData = Awaited<ReturnType<typeof getUserIdStats>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdStatsQueryOptions(id,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserIdStatsSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdStats>>, TError = unknown>(id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdStatsQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdStats>>> = ({ signal }) => getUserIdStats(id, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdStatsSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdStats>>>
export type GetUserIdStatsSuspenseQueryError = unknown


export function useGetUserIdStatsSuspense<TData = Awaited<ReturnType<typeof getUserIdStats>>, TError = unknown>(
 id: string, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdStatsSuspense<TData = Awaited<ReturnType<typeof getUserIdStats>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdStatsSuspense<TData = Awaited<ReturnType<typeof getUserIdStats>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdStatsSuspense<TData = Awaited<ReturnType<typeof getUserIdStats>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdStats>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdStatsSuspenseQueryOptions(id,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user total hours
 */
export const getUserIdTotalHours = (
    id: string,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserIdTotalHours200>(
      {url: `/user/${id}/total-hours`, method: 'GET', signal
    },
      );
    }
  

export const getGetUserIdTotalHoursQueryKey = (id: string,) => {
    return [`/user/${id}/total-hours`] as const;
    }

    
export const getGetUserIdTotalHoursQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdTotalHours>>, TError = unknown>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdTotalHoursQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdTotalHours>>> = ({ signal }) => getUserIdTotalHours(id, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdTotalHoursQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdTotalHours>>>
export type GetUserIdTotalHoursQueryError = unknown


export function useGetUserIdTotalHours<TData = Awaited<ReturnType<typeof getUserIdTotalHours>>, TError = unknown>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdTotalHours>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdTotalHours<TData = Awaited<ReturnType<typeof getUserIdTotalHours>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdTotalHours>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdTotalHours<TData = Awaited<ReturnType<typeof getUserIdTotalHours>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdTotalHours<TData = Awaited<ReturnType<typeof getUserIdTotalHours>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdTotalHoursQueryOptions(id,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserIdTotalHoursSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdTotalHours>>, TError = unknown>(id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdTotalHoursQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdTotalHours>>> = ({ signal }) => getUserIdTotalHours(id, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdTotalHoursSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdTotalHours>>>
export type GetUserIdTotalHoursSuspenseQueryError = unknown


export function useGetUserIdTotalHoursSuspense<TData = Awaited<ReturnType<typeof getUserIdTotalHours>>, TError = unknown>(
 id: string, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdTotalHoursSuspense<TData = Awaited<ReturnType<typeof getUserIdTotalHours>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdTotalHoursSuspense<TData = Awaited<ReturnType<typeof getUserIdTotalHours>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdTotalHoursSuspense<TData = Awaited<ReturnType<typeof getUserIdTotalHours>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdTotalHours>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdTotalHoursSuspenseQueryOptions(id,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user reviews count
 */
export const getUserIdReviewsCount = (
    id: string,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserIdReviewsCount200>(
      {url: `/user/${id}/reviews-count`, method: 'GET', signal
    },
      );
    }
  

export const getGetUserIdReviewsCountQueryKey = (id: string,) => {
    return [`/user/${id}/reviews-count`] as const;
    }

    
export const getGetUserIdReviewsCountQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError = unknown>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdReviewsCountQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdReviewsCount>>> = ({ signal }) => getUserIdReviewsCount(id, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdReviewsCountQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdReviewsCount>>>
export type GetUserIdReviewsCountQueryError = unknown


export function useGetUserIdReviewsCount<TData = Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError = unknown>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdReviewsCount>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdReviewsCount<TData = Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdReviewsCount>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdReviewsCount<TData = Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdReviewsCount<TData = Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdReviewsCountQueryOptions(id,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserIdReviewsCountSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError = unknown>(id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdReviewsCountQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdReviewsCount>>> = ({ signal }) => getUserIdReviewsCount(id, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdReviewsCountSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdReviewsCount>>>
export type GetUserIdReviewsCountSuspenseQueryError = unknown


export function useGetUserIdReviewsCountSuspense<TData = Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError = unknown>(
 id: string, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdReviewsCountSuspense<TData = Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdReviewsCountSuspense<TData = Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdReviewsCountSuspense<TData = Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdReviewsCount>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdReviewsCountSuspenseQueryOptions(id,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user most watched series
 */
export const getUserIdMostWatchedSeries = (
    id: string,
    params?: GetUserIdMostWatchedSeriesParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserIdMostWatchedSeries200>(
      {url: `/user/${id}/most-watched-series`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetUserIdMostWatchedSeriesQueryKey = (id: string,
    params?: GetUserIdMostWatchedSeriesParams,) => {
    return [`/user/${id}/most-watched-series`, ...(params ? [params]: [])] as const;
    }

    
export const getGetUserIdMostWatchedSeriesQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError = unknown>(id: string,
    params?: GetUserIdMostWatchedSeriesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdMostWatchedSeriesQueryKey(id,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>> = ({ signal }) => getUserIdMostWatchedSeries(id,params, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdMostWatchedSeriesQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>>
export type GetUserIdMostWatchedSeriesQueryError = unknown


export function useGetUserIdMostWatchedSeries<TData = Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError = unknown>(
 id: string,
    params: undefined |  GetUserIdMostWatchedSeriesParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdMostWatchedSeries<TData = Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError = unknown>(
 id: string,
    params?: GetUserIdMostWatchedSeriesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdMostWatchedSeries<TData = Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError = unknown>(
 id: string,
    params?: GetUserIdMostWatchedSeriesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdMostWatchedSeries<TData = Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError = unknown>(
 id: string,
    params?: GetUserIdMostWatchedSeriesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdMostWatchedSeriesQueryOptions(id,params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserIdMostWatchedSeriesSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError = unknown>(id: string,
    params?: GetUserIdMostWatchedSeriesParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdMostWatchedSeriesQueryKey(id,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>> = ({ signal }) => getUserIdMostWatchedSeries(id,params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdMostWatchedSeriesSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>>
export type GetUserIdMostWatchedSeriesSuspenseQueryError = unknown


export function useGetUserIdMostWatchedSeriesSuspense<TData = Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError = unknown>(
 id: string,
    params: undefined |  GetUserIdMostWatchedSeriesParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdMostWatchedSeriesSuspense<TData = Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError = unknown>(
 id: string,
    params?: GetUserIdMostWatchedSeriesParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdMostWatchedSeriesSuspense<TData = Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError = unknown>(
 id: string,
    params?: GetUserIdMostWatchedSeriesParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdMostWatchedSeriesSuspense<TData = Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError = unknown>(
 id: string,
    params?: GetUserIdMostWatchedSeriesParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdMostWatchedSeries>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdMostWatchedSeriesSuspenseQueryOptions(id,params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user watched genres
 */
export const getUserIdWatchedGenres = (
    id: string,
    params?: GetUserIdWatchedGenresParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserIdWatchedGenres200>(
      {url: `/user/${id}/watched-genres`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetUserIdWatchedGenresQueryKey = (id: string,
    params?: GetUserIdWatchedGenresParams,) => {
    return [`/user/${id}/watched-genres`, ...(params ? [params]: [])] as const;
    }

    
export const getGetUserIdWatchedGenresQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError = unknown>(id: string,
    params?: GetUserIdWatchedGenresParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdWatchedGenresQueryKey(id,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdWatchedGenres>>> = ({ signal }) => getUserIdWatchedGenres(id,params, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdWatchedGenresQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdWatchedGenres>>>
export type GetUserIdWatchedGenresQueryError = unknown


export function useGetUserIdWatchedGenres<TData = Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError = unknown>(
 id: string,
    params: undefined |  GetUserIdWatchedGenresParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdWatchedGenres>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedGenres<TData = Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedGenresParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdWatchedGenres>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedGenres<TData = Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedGenresParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdWatchedGenres<TData = Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedGenresParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdWatchedGenresQueryOptions(id,params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserIdWatchedGenresSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError = unknown>(id: string,
    params?: GetUserIdWatchedGenresParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdWatchedGenresQueryKey(id,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdWatchedGenres>>> = ({ signal }) => getUserIdWatchedGenres(id,params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdWatchedGenresSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdWatchedGenres>>>
export type GetUserIdWatchedGenresSuspenseQueryError = unknown


export function useGetUserIdWatchedGenresSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError = unknown>(
 id: string,
    params: undefined |  GetUserIdWatchedGenresParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedGenresSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedGenresParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedGenresSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedGenresParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdWatchedGenresSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedGenresParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedGenres>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdWatchedGenresSuspenseQueryOptions(id,params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user watched cast
 */
export const getUserIdWatchedCast = (
    id: string,
    params?: GetUserIdWatchedCastParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserIdWatchedCast200>(
      {url: `/user/${id}/watched-cast`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetUserIdWatchedCastQueryKey = (id: string,
    params?: GetUserIdWatchedCastParams,) => {
    return [`/user/${id}/watched-cast`, ...(params ? [params]: [])] as const;
    }

    
export const getGetUserIdWatchedCastQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError = unknown>(id: string,
    params?: GetUserIdWatchedCastParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdWatchedCastQueryKey(id,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdWatchedCast>>> = ({ signal }) => getUserIdWatchedCast(id,params, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdWatchedCastQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdWatchedCast>>>
export type GetUserIdWatchedCastQueryError = unknown


export function useGetUserIdWatchedCast<TData = Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError = unknown>(
 id: string,
    params: undefined |  GetUserIdWatchedCastParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdWatchedCast>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedCast<TData = Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCastParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdWatchedCast>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedCast<TData = Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCastParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdWatchedCast<TData = Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCastParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdWatchedCastQueryOptions(id,params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserIdWatchedCastSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError = unknown>(id: string,
    params?: GetUserIdWatchedCastParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdWatchedCastQueryKey(id,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdWatchedCast>>> = ({ signal }) => getUserIdWatchedCast(id,params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdWatchedCastSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdWatchedCast>>>
export type GetUserIdWatchedCastSuspenseQueryError = unknown


export function useGetUserIdWatchedCastSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError = unknown>(
 id: string,
    params: undefined |  GetUserIdWatchedCastParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedCastSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCastParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedCastSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCastParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdWatchedCastSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCastParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCast>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdWatchedCastSuspenseQueryOptions(id,params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user watched countries
 */
export const getUserIdWatchedCountries = (
    id: string,
    params?: GetUserIdWatchedCountriesParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserIdWatchedCountries200>(
      {url: `/user/${id}/watched-countries`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetUserIdWatchedCountriesQueryKey = (id: string,
    params?: GetUserIdWatchedCountriesParams,) => {
    return [`/user/${id}/watched-countries`, ...(params ? [params]: [])] as const;
    }

    
export const getGetUserIdWatchedCountriesQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError = unknown>(id: string,
    params?: GetUserIdWatchedCountriesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdWatchedCountriesQueryKey(id,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdWatchedCountries>>> = ({ signal }) => getUserIdWatchedCountries(id,params, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdWatchedCountriesQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdWatchedCountries>>>
export type GetUserIdWatchedCountriesQueryError = unknown


export function useGetUserIdWatchedCountries<TData = Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError = unknown>(
 id: string,
    params: undefined |  GetUserIdWatchedCountriesParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdWatchedCountries>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedCountries<TData = Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCountriesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdWatchedCountries>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedCountries<TData = Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCountriesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdWatchedCountries<TData = Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCountriesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdWatchedCountriesQueryOptions(id,params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserIdWatchedCountriesSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError = unknown>(id: string,
    params?: GetUserIdWatchedCountriesParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdWatchedCountriesQueryKey(id,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdWatchedCountries>>> = ({ signal }) => getUserIdWatchedCountries(id,params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdWatchedCountriesSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdWatchedCountries>>>
export type GetUserIdWatchedCountriesSuspenseQueryError = unknown


export function useGetUserIdWatchedCountriesSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError = unknown>(
 id: string,
    params: undefined |  GetUserIdWatchedCountriesParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedCountriesSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCountriesParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdWatchedCountriesSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCountriesParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdWatchedCountriesSuspense<TData = Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError = unknown>(
 id: string,
    params?: GetUserIdWatchedCountriesParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdWatchedCountries>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdWatchedCountriesSuspenseQueryOptions(id,params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user best reviews
 */
export const getUserIdBestReviews = (
    id: string,
    params?: GetUserIdBestReviewsParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserIdBestReviews200>(
      {url: `/user/${id}/best-reviews`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetUserIdBestReviewsQueryKey = (id: string,
    params?: GetUserIdBestReviewsParams,) => {
    return [`/user/${id}/best-reviews`, ...(params ? [params]: [])] as const;
    }

    
export const getGetUserIdBestReviewsQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdBestReviews>>, TError = unknown>(id: string,
    params?: GetUserIdBestReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdBestReviewsQueryKey(id,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdBestReviews>>> = ({ signal }) => getUserIdBestReviews(id,params, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdBestReviewsQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdBestReviews>>>
export type GetUserIdBestReviewsQueryError = unknown


export function useGetUserIdBestReviews<TData = Awaited<ReturnType<typeof getUserIdBestReviews>>, TError = unknown>(
 id: string,
    params: undefined |  GetUserIdBestReviewsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdBestReviews>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdBestReviews<TData = Awaited<ReturnType<typeof getUserIdBestReviews>>, TError = unknown>(
 id: string,
    params?: GetUserIdBestReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdBestReviews>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdBestReviews<TData = Awaited<ReturnType<typeof getUserIdBestReviews>>, TError = unknown>(
 id: string,
    params?: GetUserIdBestReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdBestReviews<TData = Awaited<ReturnType<typeof getUserIdBestReviews>>, TError = unknown>(
 id: string,
    params?: GetUserIdBestReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdBestReviewsQueryOptions(id,params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserIdBestReviewsSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdBestReviews>>, TError = unknown>(id: string,
    params?: GetUserIdBestReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdBestReviewsQueryKey(id,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdBestReviews>>> = ({ signal }) => getUserIdBestReviews(id,params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdBestReviewsSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdBestReviews>>>
export type GetUserIdBestReviewsSuspenseQueryError = unknown


export function useGetUserIdBestReviewsSuspense<TData = Awaited<ReturnType<typeof getUserIdBestReviews>>, TError = unknown>(
 id: string,
    params: undefined |  GetUserIdBestReviewsParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdBestReviewsSuspense<TData = Awaited<ReturnType<typeof getUserIdBestReviews>>, TError = unknown>(
 id: string,
    params?: GetUserIdBestReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdBestReviewsSuspense<TData = Awaited<ReturnType<typeof getUserIdBestReviews>>, TError = unknown>(
 id: string,
    params?: GetUserIdBestReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdBestReviewsSuspense<TData = Awaited<ReturnType<typeof getUserIdBestReviews>>, TError = unknown>(
 id: string,
    params?: GetUserIdBestReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdBestReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdBestReviewsSuspenseQueryOptions(id,params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user items status
 */
export const getUserIdItemsStatus = (
    id: string,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserIdItemsStatus200>(
      {url: `/user/${id}/items-status`, method: 'GET', signal
    },
      );
    }
  

export const getGetUserIdItemsStatusQueryKey = (id: string,) => {
    return [`/user/${id}/items-status`] as const;
    }

    
export const getGetUserIdItemsStatusQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError = unknown>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdItemsStatusQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdItemsStatus>>> = ({ signal }) => getUserIdItemsStatus(id, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdItemsStatusQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdItemsStatus>>>
export type GetUserIdItemsStatusQueryError = unknown


export function useGetUserIdItemsStatus<TData = Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError = unknown>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdItemsStatus>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdItemsStatus<TData = Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserIdItemsStatus>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdItemsStatus<TData = Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdItemsStatus<TData = Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdItemsStatusQueryOptions(id,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserIdItemsStatusSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError = unknown>(id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserIdItemsStatusQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserIdItemsStatus>>> = ({ signal }) => getUserIdItemsStatus(id, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserIdItemsStatusSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserIdItemsStatus>>>
export type GetUserIdItemsStatusSuspenseQueryError = unknown


export function useGetUserIdItemsStatusSuspense<TData = Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError = unknown>(
 id: string, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdItemsStatusSuspense<TData = Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserIdItemsStatusSuspense<TData = Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserIdItemsStatusSuspense<TData = Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError = unknown>(
 id: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserIdItemsStatus>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserIdItemsStatusSuspenseQueryOptions(id,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



