/**
 * Generated by orval v7.3.0 🍺
 * Do not edit manually.
 * Plotwist
 * OpenAPI spec version: 0.1.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery,
  useSuspenseQuery
} from '@tanstack/react-query'
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult,
  UseSuspenseQueryOptions,
  UseSuspenseQueryResult
} from '@tanstack/react-query'
import type {
  GetAllUserItems200,
  GetAllUserItemsParams,
  GetUserItem200,
  GetUserItemParams,
  GetUserItems200,
  GetUserItemsParams,
  PutUserItem201,
  PutUserItemBody
} from './endpoints.schemas'
import { axiosInstance } from '../services/axios-instance';




/**
 * Upsert user item
 */
export const putUserItem = (
    putUserItemBody: PutUserItemBody,
 ) => {
      
      
      return axiosInstance<PutUserItem201>(
      {url: `/user/item`, method: 'PUT',
      headers: {'Content-Type': 'application/json', },
      data: putUserItemBody
    },
      );
    }
  


export const getPutUserItemMutationOptions = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putUserItem>>, TError,{data: PutUserItemBody}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof putUserItem>>, TError,{data: PutUserItemBody}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putUserItem>>, {data: PutUserItemBody}> = (props) => {
          const {data} = props ?? {};

          return  putUserItem(data,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutUserItemMutationResult = NonNullable<Awaited<ReturnType<typeof putUserItem>>>
    export type PutUserItemMutationBody = PutUserItemBody
    export type PutUserItemMutationError = unknown

    export const usePutUserItem = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putUserItem>>, TError,{data: PutUserItemBody}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof putUserItem>>,
        TError,
        {data: PutUserItemBody},
        TContext
      > => {

      const mutationOptions = getPutUserItemMutationOptions(options);

      return useMutation(mutationOptions);
    }
    /**
 * Get user item
 */
export const getUserItem = (
    params: GetUserItemParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserItem200>(
      {url: `/user/item`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetUserItemQueryKey = (params: GetUserItemParams,) => {
    return [`/user/item`, ...(params ? [params]: [])] as const;
    }

    
export const getGetUserItemQueryOptions = <TData = Awaited<ReturnType<typeof getUserItem>>, TError = unknown>(params: GetUserItemParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserItemQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserItem>>> = ({ signal }) => getUserItem(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserItemQueryResult = NonNullable<Awaited<ReturnType<typeof getUserItem>>>
export type GetUserItemQueryError = unknown


export function useGetUserItem<TData = Awaited<ReturnType<typeof getUserItem>>, TError = unknown>(
 params: GetUserItemParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserItem>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserItem<TData = Awaited<ReturnType<typeof getUserItem>>, TError = unknown>(
 params: GetUserItemParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserItem>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserItem<TData = Awaited<ReturnType<typeof getUserItem>>, TError = unknown>(
 params: GetUserItemParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserItem<TData = Awaited<ReturnType<typeof getUserItem>>, TError = unknown>(
 params: GetUserItemParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserItemQueryOptions(params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetUserItemSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getUserItem>>, TError = unknown>(params: GetUserItemParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserItemQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserItem>>> = ({ signal }) => getUserItem(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserItemSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getUserItem>>>
export type GetUserItemSuspenseQueryError = unknown


export function useGetUserItemSuspense<TData = Awaited<ReturnType<typeof getUserItem>>, TError = unknown>(
 params: GetUserItemParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserItemSuspense<TData = Awaited<ReturnType<typeof getUserItem>>, TError = unknown>(
 params: GetUserItemParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserItemSuspense<TData = Awaited<ReturnType<typeof getUserItem>>, TError = unknown>(
 params: GetUserItemParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserItemSuspense<TData = Awaited<ReturnType<typeof getUserItem>>, TError = unknown>(
 params: GetUserItemParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getUserItem>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserItemSuspenseQueryOptions(params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get user items
 */
export const getUserItems = (
    params: GetUserItemsParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserItems200>(
      {url: `/user/items`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetUserItemsQueryKey = (params: GetUserItemsParams,) => {
    return [`/user/items`, ...(params ? [params]: [])] as const;
    }

    
export const getGetUserItemsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUserItems>>>, TError = unknown>(params: GetUserItemsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserItems>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserItemsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserItems>>> = ({ signal }) => getUserItems(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserItems>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserItemsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUserItems>>>
export type GetUserItemsInfiniteQueryError = unknown


export function useGetUserItemsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserItems>>>, TError = unknown>(
 params: GetUserItemsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserItems>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserItems>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserItemsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserItems>>>, TError = unknown>(
 params: GetUserItemsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserItems>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserItems>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserItemsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserItems>>>, TError = unknown>(
 params: GetUserItemsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserItems>>, TError, TData>>, }

  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserItemsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserItems>>>, TError = unknown>(
 params: GetUserItemsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserItems>>, TError, TData>>, }

  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserItemsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Delete user item
 */
export const deleteUserItemId = (
    id: string,
 ) => {
      
      
      return axiosInstance<void>(
      {url: `/user/item/${id}`, method: 'DELETE'
    },
      );
    }
  


export const getDeleteUserItemIdMutationOptions = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUserItemId>>, TError,{id: string}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof deleteUserItemId>>, TError,{id: string}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteUserItemId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteUserItemId(id,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteUserItemIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteUserItemId>>>
    
    export type DeleteUserItemIdMutationError = unknown

    export const useDeleteUserItemId = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUserItemId>>, TError,{id: string}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof deleteUserItemId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteUserItemIdMutationOptions(options);

      return useMutation(mutationOptions);
    }
    /**
 * Get user items
 */
export const getAllUserItems = (
    params: GetAllUserItemsParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetAllUserItems200>(
      {url: `/user/items/all`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetAllUserItemsQueryKey = (params: GetAllUserItemsParams,) => {
    return [`/user/items/all`, ...(params ? [params]: [])] as const;
    }

    
export const getGetAllUserItemsQueryOptions = <TData = Awaited<ReturnType<typeof getAllUserItems>>, TError = unknown>(params: GetAllUserItemsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetAllUserItemsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getAllUserItems>>> = ({ signal }) => getAllUserItems(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetAllUserItemsQueryResult = NonNullable<Awaited<ReturnType<typeof getAllUserItems>>>
export type GetAllUserItemsQueryError = unknown


export function useGetAllUserItems<TData = Awaited<ReturnType<typeof getAllUserItems>>, TError = unknown>(
 params: GetAllUserItemsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getAllUserItems>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetAllUserItems<TData = Awaited<ReturnType<typeof getAllUserItems>>, TError = unknown>(
 params: GetAllUserItemsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getAllUserItems>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetAllUserItems<TData = Awaited<ReturnType<typeof getAllUserItems>>, TError = unknown>(
 params: GetAllUserItemsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetAllUserItems<TData = Awaited<ReturnType<typeof getAllUserItems>>, TError = unknown>(
 params: GetAllUserItemsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetAllUserItemsQueryOptions(params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetAllUserItemsSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getAllUserItems>>, TError = unknown>(params: GetAllUserItemsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetAllUserItemsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getAllUserItems>>> = ({ signal }) => getAllUserItems(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetAllUserItemsSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getAllUserItems>>>
export type GetAllUserItemsSuspenseQueryError = unknown


export function useGetAllUserItemsSuspense<TData = Awaited<ReturnType<typeof getAllUserItems>>, TError = unknown>(
 params: GetAllUserItemsParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetAllUserItemsSuspense<TData = Awaited<ReturnType<typeof getAllUserItems>>, TError = unknown>(
 params: GetAllUserItemsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetAllUserItemsSuspense<TData = Awaited<ReturnType<typeof getAllUserItems>>, TError = unknown>(
 params: GetAllUserItemsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetAllUserItemsSuspense<TData = Awaited<ReturnType<typeof getAllUserItems>>, TError = unknown>(
 params: GetAllUserItemsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getAllUserItems>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetAllUserItemsSuspenseQueryOptions(params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



