/**
 * Generated by orval v7.3.0 🍺
 * Do not edit manually.
 * Plotwist
 * OpenAPI spec version: 0.1.0
 */
import {
  useInfiniteQuery,
  useMutation
} from '@tanstack/react-query'
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  InfiniteData,
  MutationFunction,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult
} from '@tanstack/react-query'
import type {
  GetUserActivities200,
  GetUserActivitiesParams
} from './endpoints.schemas'
import { axiosInstance } from '../services/axios-instance';




/**
 * Get user activities
 */
export const getUserActivities = (
    userId: string,
    params?: GetUserActivitiesParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetUserActivities200>(
      {url: `/user/${userId}/activities`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetUserActivitiesQueryKey = (userId: string,
    params?: GetUserActivitiesParams,) => {
    return [`/user/${userId}/activities`, ...(params ? [params]: [])] as const;
    }

    
export const getGetUserActivitiesInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUserActivities>>>, TError = unknown>(userId: string,
    params?: GetUserActivitiesParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserActivities>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserActivitiesQueryKey(userId,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserActivities>>> = ({ signal }) => getUserActivities(userId,params, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(userId), ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserActivities>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetUserActivitiesInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUserActivities>>>
export type GetUserActivitiesInfiniteQueryError = unknown


export function useGetUserActivitiesInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserActivities>>>, TError = unknown>(
 userId: string,
    params: undefined |  GetUserActivitiesParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserActivities>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserActivities>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserActivitiesInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserActivities>>>, TError = unknown>(
 userId: string,
    params?: GetUserActivitiesParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserActivities>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserActivities>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetUserActivitiesInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserActivities>>>, TError = unknown>(
 userId: string,
    params?: GetUserActivitiesParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserActivities>>, TError, TData>>, }

  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetUserActivitiesInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserActivities>>>, TError = unknown>(
 userId: string,
    params?: GetUserActivitiesParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserActivities>>, TError, TData>>, }

  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetUserActivitiesInfiniteQueryOptions(userId,params,options)

  const query = useInfiniteQuery(queryOptions) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Delete user activity
 */
export const deleteUserActivity = (
    activityId: string,
 ) => {
      
      
      return axiosInstance<void>(
      {url: `/user/activities/${activityId}`, method: 'DELETE'
    },
      );
    }
  


export const getDeleteUserActivityMutationOptions = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUserActivity>>, TError,{activityId: string}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof deleteUserActivity>>, TError,{activityId: string}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteUserActivity>>, {activityId: string}> = (props) => {
          const {activityId} = props ?? {};

          return  deleteUserActivity(activityId,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteUserActivityMutationResult = NonNullable<Awaited<ReturnType<typeof deleteUserActivity>>>
    
    export type DeleteUserActivityMutationError = unknown

    export const useDeleteUserActivity = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUserActivity>>, TError,{activityId: string}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof deleteUserActivity>>,
        TError,
        {activityId: string},
        TContext
      > => {

      const mutationOptions = getDeleteUserActivityMutationOptions(options);

      return useMutation(mutationOptions);
    }
    