/**
 * Generated by orval v7.3.0 🍺
 * Do not edit manually.
 * Plotwist
 * OpenAPI spec version: 0.1.0
 */
import {
  useMutation,
  useQuery,
  useSuspenseQuery
} from '@tanstack/react-query'
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseQueryResult,
  MutationFunction,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult,
  UseSuspenseQueryOptions,
  UseSuspenseQueryResult
} from '@tanstack/react-query'
import type {
  GetDetailedReviews200,
  GetDetailedReviewsParams,
  GetReview200,
  GetReviewParams,
  GetReviews200Item,
  GetReviewsParams,
  PostReview201,
  PostReview404,
  PostReviewBody,
  PutReviewById200,
  PutReviewByIdBody
} from './endpoints.schemas'
import { axiosInstance } from '../services/axios-instance';




/**
 * Create a review
 */
export const postReview = (
    postReviewBody: PostReviewBody,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<PostReview201>(
      {url: `/review`, method: 'POST',
      headers: {'Content-Type': 'application/json', },
      data: postReviewBody, signal
    },
      );
    }
  


export const getPostReviewMutationOptions = <TError = PostReview404,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postReview>>, TError,{data: PostReviewBody}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof postReview>>, TError,{data: PostReviewBody}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postReview>>, {data: PostReviewBody}> = (props) => {
          const {data} = props ?? {};

          return  postReview(data,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostReviewMutationResult = NonNullable<Awaited<ReturnType<typeof postReview>>>
    export type PostReviewMutationBody = PostReviewBody
    export type PostReviewMutationError = PostReview404

    export const usePostReview = <TError = PostReview404,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postReview>>, TError,{data: PostReviewBody}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof postReview>>,
        TError,
        {data: PostReviewBody},
        TContext
      > => {

      const mutationOptions = getPostReviewMutationOptions(options);

      return useMutation(mutationOptions);
    }
    /**
 * Get review
 */
export const getReview = (
    params: GetReviewParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetReview200>(
      {url: `/review`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetReviewQueryKey = (params: GetReviewParams,) => {
    return [`/review`, ...(params ? [params]: [])] as const;
    }

    
export const getGetReviewQueryOptions = <TData = Awaited<ReturnType<typeof getReview>>, TError = unknown>(params: GetReviewParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetReviewQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getReview>>> = ({ signal }) => getReview(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetReviewQueryResult = NonNullable<Awaited<ReturnType<typeof getReview>>>
export type GetReviewQueryError = unknown


export function useGetReview<TData = Awaited<ReturnType<typeof getReview>>, TError = unknown>(
 params: GetReviewParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getReview>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetReview<TData = Awaited<ReturnType<typeof getReview>>, TError = unknown>(
 params: GetReviewParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getReview>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetReview<TData = Awaited<ReturnType<typeof getReview>>, TError = unknown>(
 params: GetReviewParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetReview<TData = Awaited<ReturnType<typeof getReview>>, TError = unknown>(
 params: GetReviewParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetReviewQueryOptions(params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetReviewSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getReview>>, TError = unknown>(params: GetReviewParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetReviewQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getReview>>> = ({ signal }) => getReview(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetReviewSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getReview>>>
export type GetReviewSuspenseQueryError = unknown


export function useGetReviewSuspense<TData = Awaited<ReturnType<typeof getReview>>, TError = unknown>(
 params: GetReviewParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetReviewSuspense<TData = Awaited<ReturnType<typeof getReview>>, TError = unknown>(
 params: GetReviewParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetReviewSuspense<TData = Awaited<ReturnType<typeof getReview>>, TError = unknown>(
 params: GetReviewParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetReviewSuspense<TData = Awaited<ReturnType<typeof getReview>>, TError = unknown>(
 params: GetReviewParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReview>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetReviewSuspenseQueryOptions(params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Get reviews
 */
export const getReviews = (
    params?: GetReviewsParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetReviews200Item[]>(
      {url: `/reviews`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetReviewsQueryKey = (params?: GetReviewsParams,) => {
    return [`/reviews`, ...(params ? [params]: [])] as const;
    }

    
export const getGetReviewsQueryOptions = <TData = Awaited<ReturnType<typeof getReviews>>, TError = unknown>(params?: GetReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetReviewsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getReviews>>> = ({ signal }) => getReviews(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetReviewsQueryResult = NonNullable<Awaited<ReturnType<typeof getReviews>>>
export type GetReviewsQueryError = unknown


export function useGetReviews<TData = Awaited<ReturnType<typeof getReviews>>, TError = unknown>(
 params: undefined |  GetReviewsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getReviews>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetReviews<TData = Awaited<ReturnType<typeof getReviews>>, TError = unknown>(
 params?: GetReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getReviews>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetReviews<TData = Awaited<ReturnType<typeof getReviews>>, TError = unknown>(
 params?: GetReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetReviews<TData = Awaited<ReturnType<typeof getReviews>>, TError = unknown>(
 params?: GetReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetReviewsQueryOptions(params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetReviewsSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getReviews>>, TError = unknown>(params?: GetReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetReviewsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getReviews>>> = ({ signal }) => getReviews(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetReviewsSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getReviews>>>
export type GetReviewsSuspenseQueryError = unknown


export function useGetReviewsSuspense<TData = Awaited<ReturnType<typeof getReviews>>, TError = unknown>(
 params: undefined |  GetReviewsParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetReviewsSuspense<TData = Awaited<ReturnType<typeof getReviews>>, TError = unknown>(
 params?: GetReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetReviewsSuspense<TData = Awaited<ReturnType<typeof getReviews>>, TError = unknown>(
 params?: GetReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetReviewsSuspense<TData = Awaited<ReturnType<typeof getReviews>>, TError = unknown>(
 params?: GetReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetReviewsSuspenseQueryOptions(params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



/**
 * Delete review by id
 */
export const deleteReviewById = (
    id: string,
 ) => {
      
      
      return axiosInstance<void>(
      {url: `/review/by/${id}`, method: 'DELETE'
    },
      );
    }
  


export const getDeleteReviewByIdMutationOptions = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteReviewById>>, TError,{id: string}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof deleteReviewById>>, TError,{id: string}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteReviewById>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteReviewById(id,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteReviewByIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteReviewById>>>
    
    export type DeleteReviewByIdMutationError = unknown

    export const useDeleteReviewById = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteReviewById>>, TError,{id: string}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof deleteReviewById>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteReviewByIdMutationOptions(options);

      return useMutation(mutationOptions);
    }
    /**
 * Update review by id
 */
export const putReviewById = (
    id: string,
    putReviewByIdBody: PutReviewByIdBody,
 ) => {
      
      
      return axiosInstance<PutReviewById200>(
      {url: `/review/by/${id}`, method: 'PUT',
      headers: {'Content-Type': 'application/json', },
      data: putReviewByIdBody
    },
      );
    }
  


export const getPutReviewByIdMutationOptions = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putReviewById>>, TError,{id: string;data: PutReviewByIdBody}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof putReviewById>>, TError,{id: string;data: PutReviewByIdBody}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putReviewById>>, {id: string;data: PutReviewByIdBody}> = (props) => {
          const {id,data} = props ?? {};

          return  putReviewById(id,data,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutReviewByIdMutationResult = NonNullable<Awaited<ReturnType<typeof putReviewById>>>
    export type PutReviewByIdMutationBody = PutReviewByIdBody
    export type PutReviewByIdMutationError = unknown

    export const usePutReviewById = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putReviewById>>, TError,{id: string;data: PutReviewByIdBody}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof putReviewById>>,
        TError,
        {id: string;data: PutReviewByIdBody},
        TContext
      > => {

      const mutationOptions = getPutReviewByIdMutationOptions(options);

      return useMutation(mutationOptions);
    }
    /**
 * Get detailed reviews
 */
export const getDetailedReviews = (
    params?: GetDetailedReviewsParams,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetDetailedReviews200>(
      {url: `/detailed/reviews`, method: 'GET',
        params, signal
    },
      );
    }
  

export const getGetDetailedReviewsQueryKey = (params?: GetDetailedReviewsParams,) => {
    return [`/detailed/reviews`, ...(params ? [params]: [])] as const;
    }

    
export const getGetDetailedReviewsQueryOptions = <TData = Awaited<ReturnType<typeof getDetailedReviews>>, TError = unknown>(params?: GetDetailedReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetDetailedReviewsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getDetailedReviews>>> = ({ signal }) => getDetailedReviews(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetDetailedReviewsQueryResult = NonNullable<Awaited<ReturnType<typeof getDetailedReviews>>>
export type GetDetailedReviewsQueryError = unknown


export function useGetDetailedReviews<TData = Awaited<ReturnType<typeof getDetailedReviews>>, TError = unknown>(
 params: undefined |  GetDetailedReviewsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getDetailedReviews>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetDetailedReviews<TData = Awaited<ReturnType<typeof getDetailedReviews>>, TError = unknown>(
 params?: GetDetailedReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getDetailedReviews>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetDetailedReviews<TData = Awaited<ReturnType<typeof getDetailedReviews>>, TError = unknown>(
 params?: GetDetailedReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetDetailedReviews<TData = Awaited<ReturnType<typeof getDetailedReviews>>, TError = unknown>(
 params?: GetDetailedReviewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetDetailedReviewsQueryOptions(params,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetDetailedReviewsSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getDetailedReviews>>, TError = unknown>(params?: GetDetailedReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetDetailedReviewsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getDetailedReviews>>> = ({ signal }) => getDetailedReviews(params, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetDetailedReviewsSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getDetailedReviews>>>
export type GetDetailedReviewsSuspenseQueryError = unknown


export function useGetDetailedReviewsSuspense<TData = Awaited<ReturnType<typeof getDetailedReviews>>, TError = unknown>(
 params: undefined |  GetDetailedReviewsParams, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetDetailedReviewsSuspense<TData = Awaited<ReturnType<typeof getDetailedReviews>>, TError = unknown>(
 params?: GetDetailedReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetDetailedReviewsSuspense<TData = Awaited<ReturnType<typeof getDetailedReviews>>, TError = unknown>(
 params?: GetDetailedReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetDetailedReviewsSuspense<TData = Awaited<ReturnType<typeof getDetailedReviews>>, TError = unknown>(
 params?: GetDetailedReviewsParams, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getDetailedReviews>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetDetailedReviewsSuspenseQueryOptions(params,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



