/**
 * Generated by orval v7.3.0 🍺
 * Do not edit manually.
 * Plotwist
 * OpenAPI spec version: 0.1.0
 */
import {
  useMutation,
  useQuery,
  useSuspenseQuery
} from '@tanstack/react-query'
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseQueryResult,
  MutationFunction,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult,
  UseSuspenseQueryOptions,
  UseSuspenseQueryResult
} from '@tanstack/react-query'
import type {
  GetLikesEntityId200,
  PostLike201,
  PostLikeBody
} from './endpoints.schemas'
import { axiosInstance } from '../services/axios-instance';




/**
 * Create like
 */
export const postLike = (
    postLikeBody: PostLikeBody,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<PostLike201>(
      {url: `/like`, method: 'POST',
      headers: {'Content-Type': 'application/json', },
      data: postLikeBody, signal
    },
      );
    }
  


export const getPostLikeMutationOptions = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postLike>>, TError,{data: PostLikeBody}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof postLike>>, TError,{data: PostLikeBody}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postLike>>, {data: PostLikeBody}> = (props) => {
          const {data} = props ?? {};

          return  postLike(data,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostLikeMutationResult = NonNullable<Awaited<ReturnType<typeof postLike>>>
    export type PostLikeMutationBody = PostLikeBody
    export type PostLikeMutationError = unknown

    export const usePostLike = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postLike>>, TError,{data: PostLikeBody}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof postLike>>,
        TError,
        {data: PostLikeBody},
        TContext
      > => {

      const mutationOptions = getPostLikeMutationOptions(options);

      return useMutation(mutationOptions);
    }
    /**
 * Delete like
 */
export const deleteLikeId = (
    id: string,
 ) => {
      
      
      return axiosInstance<void>(
      {url: `/like/${id}`, method: 'DELETE'
    },
      );
    }
  


export const getDeleteLikeIdMutationOptions = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteLikeId>>, TError,{id: string}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof deleteLikeId>>, TError,{id: string}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteLikeId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteLikeId(id,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteLikeIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteLikeId>>>
    
    export type DeleteLikeIdMutationError = unknown

    export const useDeleteLikeId = <TError = unknown,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteLikeId>>, TError,{id: string}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof deleteLikeId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteLikeIdMutationOptions(options);

      return useMutation(mutationOptions);
    }
    /**
 * Get likes
 */
export const getLikesEntityId = (
    entityId: string,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetLikesEntityId200>(
      {url: `/likes/${entityId}`, method: 'GET', signal
    },
      );
    }
  

export const getGetLikesEntityIdQueryKey = (entityId: string,) => {
    return [`/likes/${entityId}`] as const;
    }

    
export const getGetLikesEntityIdQueryOptions = <TData = Awaited<ReturnType<typeof getLikesEntityId>>, TError = unknown>(entityId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetLikesEntityIdQueryKey(entityId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getLikesEntityId>>> = ({ signal }) => getLikesEntityId(entityId, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(entityId), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetLikesEntityIdQueryResult = NonNullable<Awaited<ReturnType<typeof getLikesEntityId>>>
export type GetLikesEntityIdQueryError = unknown


export function useGetLikesEntityId<TData = Awaited<ReturnType<typeof getLikesEntityId>>, TError = unknown>(
 entityId: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getLikesEntityId>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetLikesEntityId<TData = Awaited<ReturnType<typeof getLikesEntityId>>, TError = unknown>(
 entityId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getLikesEntityId>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetLikesEntityId<TData = Awaited<ReturnType<typeof getLikesEntityId>>, TError = unknown>(
 entityId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetLikesEntityId<TData = Awaited<ReturnType<typeof getLikesEntityId>>, TError = unknown>(
 entityId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetLikesEntityIdQueryOptions(entityId,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetLikesEntityIdSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getLikesEntityId>>, TError = unknown>(entityId: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetLikesEntityIdQueryKey(entityId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getLikesEntityId>>> = ({ signal }) => getLikesEntityId(entityId, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetLikesEntityIdSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getLikesEntityId>>>
export type GetLikesEntityIdSuspenseQueryError = unknown


export function useGetLikesEntityIdSuspense<TData = Awaited<ReturnType<typeof getLikesEntityId>>, TError = unknown>(
 entityId: string, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetLikesEntityIdSuspense<TData = Awaited<ReturnType<typeof getLikesEntityId>>, TError = unknown>(
 entityId: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetLikesEntityIdSuspense<TData = Awaited<ReturnType<typeof getLikesEntityId>>, TError = unknown>(
 entityId: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetLikesEntityIdSuspense<TData = Awaited<ReturnType<typeof getLikesEntityId>>, TError = unknown>(
 entityId: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getLikesEntityId>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetLikesEntityIdSuspenseQueryOptions(entityId,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



