/**
 * Generated by orval v7.3.0 🍺
 * Do not edit manually.
 * Plotwist
 * OpenAPI spec version: 0.1.0
 */
import {
  useMutation,
  useQuery,
  useSuspenseQuery
} from '@tanstack/react-query'
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseQueryResult,
  MutationFunction,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult,
  UseSuspenseQueryOptions,
  UseSuspenseQueryResult
} from '@tanstack/react-query'
import type {
  GetImportImportId200,
  GetImportImportId404,
  PostImport200,
  PostImport422,
  PostImportBody,
  PostImportParams
} from './endpoints.schemas'
import { axiosInstance } from '../services/axios-instance';




/**
 * Save imports to run
 */
export const postImport = (
    postImportBody: PostImportBody,
    params: PostImportParams,
 signal?: AbortSignal
) => {
      
      const formData = new FormData();
formData.append('file', postImportBody.file)

      return axiosInstance<PostImport200>(
      {url: `/import`, method: 'POST',
      headers: {'Content-Type': 'multipart/form-data', },
       data: formData,
        params, signal
    },
      );
    }
  


export const getPostImportMutationOptions = <TError = PostImport422,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postImport>>, TError,{data: PostImportBody;params: PostImportParams}, TContext>, }
): UseMutationOptions<Awaited<ReturnType<typeof postImport>>, TError,{data: PostImportBody;params: PostImportParams}, TContext> => {
const {mutation: mutationOptions} = options ?? {};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postImport>>, {data: PostImportBody;params: PostImportParams}> = (props) => {
          const {data,params} = props ?? {};

          return  postImport(data,params,)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostImportMutationResult = NonNullable<Awaited<ReturnType<typeof postImport>>>
    export type PostImportMutationBody = PostImportBody
    export type PostImportMutationError = PostImport422

    export const usePostImport = <TError = PostImport422,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postImport>>, TError,{data: PostImportBody;params: PostImportParams}, TContext>, }
): UseMutationResult<
        Awaited<ReturnType<typeof postImport>>,
        TError,
        {data: PostImportBody;params: PostImportParams},
        TContext
      > => {

      const mutationOptions = getPostImportMutationOptions(options);

      return useMutation(mutationOptions);
    }
    /**
 * Get detailed import
 */
export const getImportImportId = (
    importId: string,
 signal?: AbortSignal
) => {
      
      
      return axiosInstance<GetImportImportId200>(
      {url: `/import/${importId}`, method: 'GET', signal
    },
      );
    }
  

export const getGetImportImportIdQueryKey = (importId: string,) => {
    return [`/import/${importId}`] as const;
    }

    
export const getGetImportImportIdQueryOptions = <TData = Awaited<ReturnType<typeof getImportImportId>>, TError = GetImportImportId404>(importId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetImportImportIdQueryKey(importId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getImportImportId>>> = ({ signal }) => getImportImportId(importId, signal);

      

      

   return  { queryKey, queryFn, enabled: !!(importId), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetImportImportIdQueryResult = NonNullable<Awaited<ReturnType<typeof getImportImportId>>>
export type GetImportImportIdQueryError = GetImportImportId404


export function useGetImportImportId<TData = Awaited<ReturnType<typeof getImportImportId>>, TError = GetImportImportId404>(
 importId: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getImportImportId>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetImportImportId<TData = Awaited<ReturnType<typeof getImportImportId>>, TError = GetImportImportId404>(
 importId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getImportImportId>>,
          TError,
          TData
        > , 'initialData'
      >, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetImportImportId<TData = Awaited<ReturnType<typeof getImportImportId>>, TError = GetImportImportId404>(
 importId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetImportImportId<TData = Awaited<ReturnType<typeof getImportImportId>>, TError = GetImportImportId404>(
 importId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData>>, }

  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetImportImportIdQueryOptions(importId,options)

  const query = useQuery(queryOptions) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



export const getGetImportImportIdSuspenseQueryOptions = <TData = Awaited<ReturnType<typeof getImportImportId>>, TError = GetImportImportId404>(importId: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData>>, }
) => {

const {query: queryOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetImportImportIdQueryKey(importId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getImportImportId>>> = ({ signal }) => getImportImportId(importId, signal);

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseSuspenseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData> }
}

export type GetImportImportIdSuspenseQueryResult = NonNullable<Awaited<ReturnType<typeof getImportImportId>>>
export type GetImportImportIdSuspenseQueryError = GetImportImportId404


export function useGetImportImportIdSuspense<TData = Awaited<ReturnType<typeof getImportImportId>>, TError = GetImportImportId404>(
 importId: string, options: { query:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetImportImportIdSuspense<TData = Awaited<ReturnType<typeof getImportImportId>>, TError = GetImportImportId404>(
 importId: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }
export function useGetImportImportIdSuspense<TData = Awaited<ReturnType<typeof getImportImportId>>, TError = GetImportImportId404>(
 importId: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> }

export function useGetImportImportIdSuspense<TData = Awaited<ReturnType<typeof getImportImportId>>, TError = GetImportImportId404>(
 importId: string, options?: { query?:Partial<UseSuspenseQueryOptions<Awaited<ReturnType<typeof getImportImportId>>, TError, TData>>, }

  ):  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> } {

  const queryOptions = getGetImportImportIdSuspenseQueryOptions(importId,options)

  const query = useSuspenseQuery(queryOptions) as  UseSuspenseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}



