# [08云：经典编程书籍](https://github.com/platojobs/SFLOG/issues/8)

# 经典编程书籍大全

100+ 经典技术书籍，涵盖：计算机系统与网络、系统架构、算法与数据结构、前端开发、后端开发、移动开发、数据库、测试、项目与团队、程序员职业修炼、求职面试 和 编程相关的经典书籍。

这个列表综合了伯乐在线网站以往推荐[经典书籍](http://blog.jobbole.com/tag/book/)文章中的列表，以及在微信和微博中被广泛推荐的好书。虽然已经包括了100多本，覆盖的面也比较全。仍然有很多方面需要补充，而且相信还有很多没有被收录的好书。欢迎大家在 issues 中推荐或自荐。

## 计算机系统与网络

*   《[图灵的秘密:他的生平、思想及论文解读](https://www.amazon.cn/gp/product/B00AAQXKXS/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00AAQXKXS&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[计算机系统概论](https://www.amazon.cn/gp/product/B0011F9OQE/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0011F9OQE&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[深入理解Linux内核](https://www.amazon.cn/gp/product/B0011F5RYM/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0011F5RYM&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[深入Linux内核架构](https://www.amazon.cn/gp/product/B003QN7J7U/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B003QN7J7U&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[TCP/IP详解 卷1：协议](https://www.amazon.cn/gp/product/B00116OTVS/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00116OTVS&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Linux系统编程（第2版）](https://www.amazon.cn/gp/product/B00JUM2ML4/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00JUM2ML4&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Linux内核设计与实现（第3版）](https://www.amazon.cn/gp/product/B004X3Z3D4/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B004X3Z3D4&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[深入理解计算机系统（原书第3版）](https://amazon.cn/gp/product/B01N03IQK4/ref=as_li_qf_asin_il_tl?ie=UTF8&tag=vastwork-23&creative=3200&linkCode=as2&creativeASIN=B01N03IQK4&linkId=b87deba0291c05df8d8ea0d64fefb0f0)》
*   《[计算机程序的构造和解释（原书第2版）](https://www.amazon.cn/gp/product/B0011AP7RY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0011AP7RY&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[编码：隐匿在计算机软硬件背后的语言](https://www.amazon.cn/gp/product/B009RSXIB4/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B009RSXIB4&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[性能之颠：洞悉系统、企业与云计算](https://www.amazon.cn/gp/product/B0140I5WPK/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0140I5WPK&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[UNIX网络编程 卷1：套接字联网API（第3版）](https://www.amazon.cn/gp/product/B011S72JB6/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B011S72JB6&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[UNIX网络编程 卷2：进程间通信](https://www.amazon.cn/gp/product/B012R5A29O/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B012R5A29O&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Windows核心编程(第5版)](https://www.amazon.cn/gp/product/B001GS7918/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B001GS7918&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[WireShark网络分析就这么简单](https://www.amazon.cn/gp/product/B00PB5QQ84/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00PB5QQ84&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[WireShark网络分析的艺术](https://www.amazon.cn/gp/product/B01AS1OS8A/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01AS1OS8A&amp;linkCode=as2&amp;tag=vastwork-23)》

## 编程通用

*   《[设计原本](https://www.amazon.cn/dp/B00CD1EWMG/ref=sr_1_1?ie=UTF8&qid=1514903810&sr=8-1)》
*   《[编程原本](https://www.amazon.cn/gp/product/B006P7V73G/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B006P7V73G&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[代码大全](https://www.amazon.cn/gp/product/B0061XKRXA/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0061XKRXA&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[UNIX编程艺术](https://www.amazon.cn/gp/product/B008Z1IEQ8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B008Z1IEQ8&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[代码整洁之道](https://www.amazon.cn/gp/product/B0031M9GHC/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0031M9GHC&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[编程珠玑（第2版）](https://www.amazon.cn/gp/product/B00SFZH0DC/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00SFZH0DC&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[编程珠玑（续）](https://www.amazon.cn/gp/product/B0150BMQDM/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0150BMQDM&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[软件调试的艺术](https://www.amazon.cn/gp/product/B00IOAM6VE/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00IOAM6VE&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[修改代码的艺术](https://www.amazon.cn/gp/product/B00KMJ2Q1U/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00KMJ2Q1U&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[编程语言实现模式](https://www.amazon.cn/gp/product/B007HYMPBY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B007HYMPBY&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[编写可读代码的艺术](https://www.amazon.cn/gp/product/B008B4DTG4/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B008B4DTG4&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《解析极限编程：拥抱变化》
*   《[精通正则表达式（第3版）](https://www.amazon.cn/gp/product/B008UCHA58/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B008UCHA58&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[编译原理（第2版）](https://www.amazon.cn/gp/product/B001NGO85I/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B001NGO85I&amp;linkCode=as2&amp;tag=vastwork-23)》龙书
*   《[重构：改善既有代码的设计](https://www.amazon.cn/gp/product/B011LPUB42/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B011LPUB42&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[七周七语言：理解多种编程范型](https://www.amazon.cn/gp/product/B00ALPRM3M/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00ALPRM3M&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[调试九法：软硬件错误的排查之道](https://www.amazon.cn/gp/product/B00CBBLUFK/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00CBBLUFK&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《程序设计语言：实践之路（第3版）》
*   《[计算的本质：深入剖析程序和计算机](https://www.amazon.cn/gp/product/B00PG0MM3C/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00PG0MM3C&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[设计模式 : 可复用面向对象软件的基础](https://www.amazon.cn/gp/product/B001130JN8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B001130JN8&amp;linkCode=as2&amp;tag=vastwork-23)》
* 《[Head First 设计模式（中文版）](https://amazon.cn/gp/product/B0011FBU34/ref=as_li_qf_asin_il_tl?ie=UTF8&tag=vastwork-23&creative=3200&linkCode=as2&creativeASIN=B0011FBU34&linkId=cd5d20e99ff289529d6dbe2cd223f2b6) 》（感谢[@Great-Li-Xin](https://github.com/Great-Li-Xin) [推荐](https://github.com/jobbole/awesome-programming-books/issues/27) ）

## 算法与数据结构

*   《[算法（第4版）](https://www.amazon.cn/gp/product/B009OCFQ0O/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B009OCFQ0O&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[算法导论（原书第2版）](https://www.amazon.cn/gp/product/B00AK7BYJY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00AK7BYJY&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Python算法教程](https://www.amazon.cn/gp/product/B019NB0VCI/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B019NB0VCI&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[算法设计与分析基础（第3版）](https://www.amazon.cn/gp/product/B00S4HCQUI/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00S4HCQUI&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[学习 JavaScript 数据结构与算法](https://www.amazon.cn/gp/product/B016DWSF8M/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B016DWSF8M&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[数据结构与算法分析 : C++描述（第4版）](https://www.amazon.cn/gp/product/B01LDG2DSG/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01LDG2DSG&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[数据结构与算法分析 : C语言描述（第2版）](https://www.amazon.cn/gp/product/B002WC7NGS/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B002WC7NGS&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[数据结构与算法分析 : Java语言描述（第2版）](https://www.amazon.cn/gp/product/B01CNP0CG6/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01CNP0CG6&amp;linkCode=as2&amp;tag=vastwork-23)》

## 职业修炼与规划

*   《[大教堂与集市](https://www.amazon.cn/gp/product/B00KQDTZ4S/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00KQDTZ4S&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《卓有成效的程序员》
*   《[程序员的职业素养](https://www.amazon.cn/gp/product/B01LZJ8L9J/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01LZJ8L9J&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[程序员修炼之道：从小工到专家](https://www.amazon.cn/gp/product/B004GV08CY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B004GV08CY&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[软件开发者路线图：从学徒到高手](https://www.amazon.cn/gp/product/B00H6X6LD4/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00H6X6LD4&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[我编程，我快乐: 程序员职业规划之道](https://www.amazon.cn/gp/product/B00CBBKDGM/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00CBBKDGM&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[程序员的思维修炼：开发认知潜能的九堂课](https://www.amazon.cn/gp/product/B007VARUIM/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B007VARUIM&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[高效程序员的45个习惯：敏捷开发修炼之道(修订版)](https://www.amazon.cn/gp/product/B00OA9L3NU/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00OA9L3NU&amp;linkCode=as2&amp;tag=vastwork-23)》

## 大师访谈

*   《[编程大师智慧](https://www.amazon.cn/gp/product/B00451BP72/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00451BP72&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[编程大师访谈录](https://www.amazon.cn/gp/product/B00ALPRKMA/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00ALPRKMA&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[编程人生 : 15位软件先驱访谈录](https://www.amazon.cn/gp/product/B00QA7GA2Y/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00QA7GA2Y&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[奇思妙想 : 15位计算机天才及其重大发现](https://www.amazon.cn/gp/product/B007ED88CI/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B007ED88CI&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[图灵和ACM图灵奖](https://www.amazon.cn/gp/product/B008G80O9K/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B008G80O9K&amp;linkCode=as2&amp;tag=vastwork-23)》


## 架构/性能

*   《[架构即未来](https://www.amazon.cn/图书/dp/B01DXW29IM/ref=sr_1_1?s=books&ie=UTF8&qid=1496288348&sr=1-1)》
*   《[微服务设计](https://www.amazon.cn/gp/product/B01ER75V6O/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01ER75V6O&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[大数据日知录](https://www.amazon.cn/gp/product/B00NGW4EAG/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00NGW4EAG&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[企业应用架构模式](https://www.amazon.cn/gp/product/B003LBSRDM/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B003LBSRDM&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Web性能权威指南](https://www.amazon.cn/gp/product/B00JMKWHFU/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00JMKWHFU&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[SRE：Google运维解密](https://www.amazon.cn/gp/product/B01M0EHQ43/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01M0EHQ43&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[发布！软件的设计与部署](https://www.amazon.cn/gp/product/B0153178XM/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0153178XM&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[高扩展性网站的 50 条原则](https://www.amazon.cn/gp/product/B01HZFHQQI/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01HZFHQQI&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[大型网站技术架构:核心原理与案例分析](https://www.amazon.cn/gp/product/B00F3Z26G8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00F3Z26G8&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[恰如其分的软件架构：风险驱动的设计方法](https://www.amazon.cn/gp/product/B00EP6TGAU/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00EP6TGAU&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[软件系统架构：使用视点和视角与利益相关者合作（第2版）](https://www.amazon.cn/gp/product/B00CMMUXC4/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00CMMUXC4&amp;linkCode=as2&amp;tag=vastwork-23)》

## Linux / Unix

*   《[Linux/Unix 系统编程手册](https://amazon.cn/gp/product/B00HLA8TYG/ref=as_li_qf_asin_il_tl?ie=UTF8&amp;tag=vastwork-23&amp;creative=3200&amp;linkCode=as2&amp;creativeASIN=B00HLA8TYG&amp;linkId=2d246600ae289155a09ec47545d584f6)》（感谢[@geekgao](https://github.com/geekgao) 的推荐）
*   《[Unix 环境高级编程(第3版)](https://amazon.cn/gp/product/B00KMR129E/ref=as_li_qf_asin_il_tl?ie=UTF8&amp;tag=vastwork-23&amp;creative=3200&amp;linkCode=as2&amp;creativeASIN=B00KMR129E&amp;linkId=9655c290f9d97c4d7e80093839cc5944)》
*   《Unix/Linux 编程实践教程》
*   《[鸟哥的 Linux 私房菜（基础学习篇）](https://amazon.cn/gp/product/B003TJNO98/ref=as_li_qf_asin_il_tl?ie=UTF8&amp;tag=vastwork-23&amp;creative=3200&amp;linkCode=as2&amp;creativeASIN=B003TJNO98&amp;linkId=dda37757175b431dedc5e20212021f21)》和《[鸟哥的 Linux 私房菜（服务器架设篇）](https://amazon.cn/gp/product/B008AEI8A2/ref=as_li_qf_asin_il_tl?ie=UTF8&amp;tag=vastwork-23&amp;creative=3200&amp;linkCode=as2&amp;creativeASIN=B008AEI8A2&amp;linkId=35f878fbebb2f66ae8c4fc3e76914ff6)》
*   《[Linux 命令行与 shell 脚本编程大全（第3版）](https://amazon.cn/gp/product/B0719GT5W1/ref=as_li_qf_asin_il_tl?ie=UTF8&amp;tag=vastwork-23&amp;creative=3200&amp;linkCode=as2&amp;creativeASIN=B0719GT5W1&amp;linkId=aeef8bc8651bd9e5f363527b86d1229a)》
*   《[只是为了好玩 : Linux 之父林纳斯自传](https://amazon.cn/gp/product/B00MB51SAI/ref=as_li_qf_asin_il_tl?ie=UTF8&amp;tag=vastwork-23&amp;creative=3200&amp;linkCode=as2&amp;creativeASIN=B00MB51SAI&amp;linkId=b22fe2eaac93168eae25d9bab11fe30c)》

## Web前端

*   《[高性能 JavaScript](https://www.amazon.cn/gp/product/B013SGB2AO/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B013SGB2AO&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[锋利的 jQuery（第2版）](https://www.amazon.cn/gp/product/B0089TDFNS/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0089TDFNS&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[JavaScript 忍者秘籍](https://www.amazon.cn/gp/product/B016DWSEWO/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B016DWSEWO&amp;linkCode=as2&amp;tag=vastwork-23)》（感谢[@joker-danta](https://github.com/jobbole/awesome-programming-books/issues?q=is%3Aissue+is%3Aopen+author%3Ajoker-danta) 补充推荐）
*   《[编写可维护的 JavaScript](https://www.amazon.cn/gp/product/B00BQ7RMW0/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00BQ7RMW0&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[你不知道的 JavaScript（上）](https://www.amazon.cn/gp/product/B00W34DZ8K/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00W34DZ8K&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[你不知道的 JavaScript（中）](https://www.amazon.cn/gp/product/B01LMYXGAI/ref=pd_sim_14_1?ie=UTF8&psc=1&refRID=4JRMK10EFJQHDAG8MCZF)》
*   《[JavaScript 权威指南（第6版）](https://www.amazon.cn/gp/product/B007VISQ1Y/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B007VISQ1Y&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[JavaScript 语言精粹（修订版）](https://www.amazon.cn/gp/product/B0097CON2S/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0097CON2S&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[JavaScript DOM编程艺术 （第2版）](https://www.amazon.cn/gp/product/B004VJM5KE/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B004VJM5KE&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[JavaScript 高级程序设计（第3版）](https://www.amazon.cn/gp/product/B007OQQVMY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B007OQQVMY&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[JavaScript 异步编程：设计快速响应的网络应用](https://www.amazon.cn/gp/product/B00JVLEYY2/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00JVLEYY2&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[JavaScript设计模式与开发实践](https://www.amazon.cn/gp/product/B00XJ2AU3S/ref=pd_bxgy_14_img_3?ie=UTF8&psc=1&refRID=4JRMK10EFJQHDAG8MCZF)》
*   《[JavaScript框架设计（第2版）](https://www.amazon.cn/gp/product/B07574N7Y2/ref=pd_sim_14_7?ie=UTF8&psc=1&refRID=W48SJ7HFN2TXAQ1VAA8K)》
*   《[Effective JavaScript：编写高质量JavaScript代码的68个有效方法](https://www.amazon.cn/gp/product/B00GMXI1QY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00GMXI1QY&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[HTML5 权威指南](https://www.amazon.cn/gp/product/B00H706BIG/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00H706BIG&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[HTML5 秘籍（第2版）](https://www.amazon.cn/gp/product/B015316VJY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B015316VJY&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[HTML5 与 CSS3 基础教程（第八版）](https://www.amazon.cn/gp/product/B00K58535O/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00K58535O&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[CSS 揭秘](https://www.amazon.cn/gp/product/B01ET3FO86/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01ET3FO86&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[CSS 设计指南（第3版）](https://www.amazon.cn/gp/product/B00M2DKZ1W/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00M2DKZ1W&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[CSS 权威指南（第3版）](https://www.amazon.cn/gp/product/B0011F5SIC/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0011F5SIC&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[深入浅出 HTML 与 CSS](https://www.amazon.cn/gp/product/B01LXL42O5/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01LXL42O5&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[ES6 标准入门（第三版）](https://www.amazon.cn/ES6%E6%A0%87%E5%87%86%E5%85%A5%E9%97%A8-%E9%98%AE%E4%B8%80%E5%B3%B0/dp/B0755547ZZ/ref=sr_1_3?s=books&ie=UTF8&qid=1510299626&sr=1-3&keywords=Ecmascript)》
*   《[深入理解 ES6](https://www.amazon.cn/%E6%B7%B1%E5%85%A5%E7%90%86%E8%A7%A3ES6-Nicholas-C-Zakas/dp/B071GW3JDP/ref=sr_1_1?s=books&ie=UTF8&qid=1510299626&sr=1-1&keywords=Ecmascript)》

## Java开发

*   《[Java8 实战](https://www.amazon.cn/gp/product/B01ER75QC8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01ER75QC8&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Java并发编程实战](https://www.amazon.cn/gp/product/B0077K9XHW/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0077K9XHW&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Java性能权威指南](https://www.amazon.cn/gp/product/B01DLB7Z66/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01DLB7Z66&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Java程序员修炼之道](https://www.amazon.cn/gp/product/B00E0D2OX4/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00E0D2OX4&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[实战Java高并发程序设计](https://www.amazon.cn/gp/product/B017MEN094/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B017MEN094&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Java编程思想 （第4版）](https://www.amazon.cn/gp/product/B0011F7WU4/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0011F7WU4&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[深入理解Java虚拟机（第2版）](https://www.amazon.cn/gp/product/B01HI0BUF8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01HI0BUF8&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Effective java 中文版（第2版）](https://www.amazon.cn/gp/product/B001PTGR52/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B001PTGR52&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Java核心技术·卷1：基础知识（原书第9版）](https://www.amazon.cn/gp/product/B01M22BGUQ/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01M22BGUQ&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Java核心技术·卷2：高级特性（原书第9版）](https://www.amazon.cn/gp/product/B00IK7SM6O/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00IK7SM6O&amp;linkCode=as2&amp;tag=vastwork-23)》

## .NET/.NET Core

*   《[C# 6.0 本质论](https://www.amazon.cn/C-6-0%E6%9C%AC%E8%B4%A8%E8%AE%BA-%E9%A9%AC%E5%85%8B%C2%B7%E7%B1%B3%E5%87%AF%E5%88%A9%E6%96%AF/dp/B01N7U95UK/ref=sr_1_1?s=books&ie=UTF8&qid=1510299751&sr=1-1&keywords=C%23+%E6%9C%AC%E8%B4%A8%E8%AE%BA)》
*   《[果壳中的C#：C#5.0权威指南](https://www.amazon.cn/%E6%9E%9C%E5%A3%B3%E4%B8%AD%E7%9A%84C-C-5-0%E6%9D%83%E5%A8%81%E6%8C%87%E5%8D%97-%E9%98%BF%E5%9D%9D%E5%93%88%E7%91%9E/dp/B00G51PUDA/ref=sr_1_1?s=books&ie=UTF8&qid=1510299796&sr=1-1&keywords=%E6%9E%9C%E5%A3%B3%E4%B8%AD%E7%9A%84C%23)》
*   《你必须知道的.NET（第2版）》
*   《[深入理解C#（第3版）](https://www.amazon.cn/gp/product/B00J94AG2A/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00J94AG2A&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《Effective C#: 50 Specific Ways to Improve Your C#, Third Edition》
*   《More Effective C# (Includes Content Update Program): 50 Specific Ways to Improve Your C#, 2nd edition》
*   《[Async in C# 5.0: Unleash the Power of Async](https://www.amazon.cn/Async-in-C-5-0-Unleash-the-Power-of-Async-Davies-Alex/dp/1449337163/ref=sr_1_1?s=books&ie=UTF8&qid=1510299899&sr=1-1&keywords=Async+in+C%23+5.0)》
*   《[C#并发编程经典实例](https://www.amazon.cn/C-%E5%B9%B6%E5%8F%91%E7%BC%96%E7%A8%8B%E7%BB%8F%E5%85%B8%E5%AE%9E%E4%BE%8B-%E5%85%8B%E5%88%A9%E9%87%8C/dp/B00QVLZEQ2/ref=sr_1_1?s=books&ie=UTF8&qid=1510299937&sr=1-1&keywords=C%23%E5%B9%B6%E5%8F%91%E7%BC%96%E7%A8%8B%E7%BB%8F%E5%85%B8%E5%AE%9E%E4%BE%8B)》
*   《[C#多线程编程实战(原书第2版)](https://www.amazon.cn/C-%E5%A4%9A%E7%BA%BF%E7%A8%8B%E7%BC%96%E7%A8%8B%E5%AE%9E%E6%88%98-%E6%98%93%E6%A0%BC%E6%81%A9%C2%B7%E9%98%BF%E6%A0%BC%E4%BD%9B%E6%B8%A9/dp/B06XHXV5FQ/ref=sr_1_1?s=books&ie=UTF8&qid=1510299974&sr=1-1&keywords=C%23%E5%A4%9A%E7%BA%BF%E7%A8%8B%E7%BC%96%E7%A8%8B%E5%AE%9E%E6%88%98)》
*   《[CLR via C#（第4版）](https://www.amazon.cn/gp/product/B00P8VZ8T4/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00P8VZ8T4&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《.NET本质论 第1卷:公共语言运行库》
*   《.NET探秘 : MSIL权威指南》
*   《Pro .NET Performance》
*   《Shared Source CLI Essentials》
*   《.NET 高级调试》
*   《Microsoft.NET 和 Windows 应用程序调试》
*   《微软.NET 程序的加密与解密》
*   《[.NET Development Using the Compiler API](https://www.amazon.cn/NET-Development-Using-the-Compiler-API-Bock-Jason/dp/1484221109/ref=sr_1_1?s=books&ie=UTF8&qid=1510300116&sr=1-1&keywords=.NET+Development+Using+the+Compiler+API)》
*   《.NET设计规范 : 约定、惯用法与模式》
*   《[编写高性能的.NET代码](https://www.amazon.cn/gp/product/B074JS9HWX/ref=pd_sim_14_9?ie=UTF8&psc=1&refRID=67XZ7GZVFZ3J57NQTJ8X)》
*   《[Building Microservices with .NET Core](https://www.amazon.cn/Building-Microservices-with-NET-Core-Develop-skills-in-Reactive-Microservices-database-scaling-Azure-Microservices-and-more-Aroraa-Gaurav-Kumar/dp/B01MQ52RM3/ref=sr_1_10?s=books&ie=UTF8&qid=1510300439&sr=1-10&keywords=.net+core)》
*   《[Microservices in .NET Core, with Examples in NancyFX](https://www.amazon.cn/Microservices-in-NET-Core-with-Examples-in-NancyFX-Horsdal-Christian/dp/1617293377/ref=sr_1_15?s=books&ie=UTF8&qid=1510300439&sr=1-15&keywords=.net+core)》

## Python

*   《[集体智慧编程](https://www.amazon.cn/gp/product/B00UI93JD8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00UI93JD8&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[笨办法学Python](https://www.amazon.cn/gp/product/B00P6OJ0TC/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00P6OJ0TC&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Python基础教程](https://www.amazon.cn/gp/product/B00KAFX65Q/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00KAFX65Q&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《Python源码剖析》
*   《[Head First Python](https://www.amazon.cn/gp/product/B007NB2B4M/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B007NB2B4M&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[与孩子一起学编程](https://www.amazon.cn/gp/product/B00HECW20S/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00HECW20S&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Python学习手册（第4版）](https://www.amazon.cn/gp/product/B004TUJ7A6/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B004TUJ7A6&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Python Cookbook（第3版）](https://www.amazon.cn/gp/product/B00WKR1OKG/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00WKR1OKG&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Python参考手册（第4版）](https://www.amazon.cn/gp/product/B01MCUN37Y/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01MCUN37Y&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Python核心编程（第3版）](https://www.amazon.cn/gp/product/B01FQAS0KK/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01FQAS0KK&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Python科学计算（第2版）](https://www.amazon.cn/gp/product/B01HCVUJFA/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01HCVUJFA&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[利用 Python 进行数据分析](https://www.amazon.cn/gp/product/B00GHGZLWS/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00GHGZLWS&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Think Python：像计算机科学家一样思考Python（第2版）](https://www.amazon.cn/gp/product/B01ION3W54/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01ION3W54&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Python编程实战:运用设计模式、并发和程序库创建高质量程序](https://www.amazon.cn/gp/product/B00MHDPIJ6/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00MHDPIJ6&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Python绝技：运用Python成为顶级黑客](https://www.amazon.cn/gp/product/B019ZRGBVU/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B019ZRGBVU&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Flask Web开发:基于Python的Web应用开发实战](https://www.amazon.cn/gp/product/B0153177A6/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0153177A6&amp;linkCode=as2&amp;tag=vastwork-23)》

## Android

*   《[Android编程权威指南（第2版）](https://www.amazon.cn/gp/product/B01FSXCBOQ/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01FSXCBOQ&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[移动应用UI设计模式（第2版）](https://www.amazon.cn/gp/product/B00SFZGX08/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00SFZGX08&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Android开发艺术探索](https://www.amazon.cn/Android%E5%BC%80%E5%8F%91%E8%89%BA%E6%9C%AF%E6%8E%A2%E7%B4%A2-%E4%BB%BB%E7%8E%89%E5%88%9A/dp/B014HV1X3K/ref=sr_1_1?s=books&ie=UTF8&qid=1478155289&sr=1-1&keywords=android%E5%BC%80%E5%8F%91%E8%89%BA%E6%9C%AF%E6%8E%A2%E7%B4%A2)》

## iOS

*   《[iOS编程实战](https://www.amazon.cn/gp/product/B00NKZCM3U/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00NKZCM3U&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[iOS编程（第4版）](https://www.amazon.cn/gp/product/B013UG2ULW/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B013UG2ULW&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Objective-C高级编程](https://www.amazon.cn/gp/product/B00DE60G3S/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00DE60G3S&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Effective Objective-C 2.0：编写高质量iOS与OS X代码的52个有效方法](https://www.amazon.cn/gp/product/B00IDSGY06/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00IDSGY06&amp;linkCode=as2&amp;tag=vastwork-23)》

## PHP

*   《[Head First PHP &amp; MySQL（中文版）](https://www.amazon.cn/gp/product/B004R1QIJU/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B004R1QIJU&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[深入PHP：面向对象、模式与实践（第3版）](https://www.amazon.cn/gp/product/B005D6IRRY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B005D6IRRY&amp;linkCode=as2&amp;tag=vastwork-23)》

## C语言

*   《[C标准库](https://www.amazon.cn/gp/product/B00IZW4DK8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00IZW4DK8&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[C和指针](https://www.amazon.cn/gp/product/B00163LU68/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00163LU68&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[C专家编程](https://www.amazon.cn/gp/product/B0012NIW9K/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0012NIW9K&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[C陷阱与缺陷](https://www.amazon.cn/gp/product/B0012UMPBY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0012UMPBY&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[C语言接口与实现](https://www.amazon.cn/gp/product/B01D10NSCM/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01D10NSCM&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[C程序设计语言（第2版）](https://www.amazon.cn/gp/product/B0011425T8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0011425T8&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《C语言参考手册（第5版）》

## C++

*   《[C++标准库](https://www.amazon.cn/gp/product/B00YLZIRHI/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00YLZIRHI&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[C++编程思想](https://www.amazon.cn/gp/product/B005CFUQR0/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B005CFUQR0&amp;linkCode=as2&amp;tag=vastwork-23)》
*   <span style="font-weight: normal;">《</span>C++语言的设计与演化<span style="font-weight: normal;">》</span>
*   《[C++程序设计原理与实践](https://www.amazon.cn/gp/product/B003VPX6YS/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B003VPX6YS&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[C++ Primer （中文第5版）](https://www.amazon.cn/gp/product/B00ESUIL0O/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00ESUIL0O&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[C++ Primer习题集(第5版)](https://www.amazon.cn/gp/product/B00S6U4C6E/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00S6U4C6E&amp;linkCode=as2&amp;tag=vastwork-23) 》
*   《[C++程序设计语言(第1-3部分)(原书第4版)](https://www.amazon.cn/gp/product/B01I9BNASA/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01I9BNASA&amp;linkCode=as2&amp;tag=vastwork-23) 》
*   《[Effective C++:改善程序与设计的55个具体做法(第3版)(中文版) ](https://www.amazon.cn/gp/product/B004G72P24/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B004G72P24&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[More Effective C++:35个改善编程与设计的有效方法(中文版) ](https://www.amazon.cn/gp/product/B004IP8BD6/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B004IP8BD6&amp;linkCode=as2&amp;tag=vastwork-23)》
&nbsp;

## 机器学习和数据挖掘

*   《[数据之巅](https://www.amazon.cn/gp/product/B00JUE9DXW/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00JUE9DXW&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[矩阵分析](https://www.amazon.cn/gp/product/B00NTM5GK0/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00NTM5GK0&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[机器学习](https://www.amazon.cn/gp/product/B002WC7NH2/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B002WC7NH2&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[统计学习方法](https://www.amazon.cn/gp/product/B007TSFMTA/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B007TSFMTA&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[机器学习导论](https://www.amazon.cn/gp/product/B01AG3ZV9K/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B01AG3ZV9K&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[推荐系统实践](https://www.amazon.cn/gp/product/B008AK5YJO/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B008AK5YJO&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[机器学习实战](https://www.amazon.cn/gp/product/B00D747PTK/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00D747PTK&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Web数据挖掘](https://www.amazon.cn/gp/product/B00AY830HS/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00AY830HS&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[深入浅出统计学](https://www.amazon.cn/gp/product/B006PHIVNA/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B006PHIVNA&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[模式分类（第2版）](https://www.amazon.cn/gp/product/B00116C3DY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00116C3DY&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[概率论与数理统计](https://www.amazon.cn/gp/product/B00264GG56/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00264GG56&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[统计学习基础(第2版)(英文)](https://www.amazon.cn/gp/product/B00PRH2BXA/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00PRH2BXA&amp;linkCode=as2&amp;tag=vastwork-23) 》
*   《[数据挖掘：概念与技术（第3版）](https://www.amazon.cn/gp/product/B007NR0T4A/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B007NR0T4A&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[数据挖掘：实用机器学习工具与技术（原书第3版）](https://www.amazon.cn/gp/product/B00K5I91WK/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00K5I91WK&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[大数据：互联网大规模数据挖掘与分布式处理（第2版）](https://www.amazon.cn/gp/product/B011I34CGA/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B011I34CGA&amp;linkCode=as2&amp;tag=vastwork-23)》

## 数据库

* 《[数据库系统概念](https://amazon.cn/gp/product/B007KYSEZC/ref=as_li_qf_asin_il_tl?ie=UTF8&tag=vastwork-23&creative=3200&linkCode=as2&creativeASIN=B007KYSEZC&linkId=32d1830aaeeda5b1ccaf242af94e73ad)》 感谢[@noisnemid](https://github.com/noisnemid) [推荐](https://github.com/jobbole/awesome-programming-books/issues/16)
* 《[数据库系统实现](https://amazon.cn/gp/product/B003NX8D0A/ref=as_li_qf_asin_il_tl?ie=UTF8&tag=vastwork-23&creative=3200&linkCode=as2&creativeASIN=B003NX8D0A&linkId=3d1723a92384a5febb43c2400b31f1fe)》
*   《[SQL应用重构](https://www.amazon.cn/gp/product/B00H6X6M1A/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00H6X6M1A&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[SQL Cookbook](https://www.amazon.cn/gp/product/0596009763/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=0596009763&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[高性能MySQL （第3版）](https://www.amazon.cn/gp/product/B00C1W58DE/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00C1W58DE&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《深入浅出SQL（中文版）》
*   《[MySQL技术内幕 : InnoDB存储引擎（第2版）](https://www.amazon.cn/gp/product/B00ETOV48K/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00ETOV48K&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[深入浅出MySQL : 数据库开发、优化与管理维护](https://www.amazon.cn/gp/product/B00KR87J8G/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00KR87J8G&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[收获,不止SQL优化:抓住SQL的本质](https://www.amazon.cn/%E6%94%B6%E8%8E%B7-%E4%B8%8D%E6%AD%A2SQL%E4%BC%98%E5%8C%96-%E6%8A%93%E4%BD%8FSQL%E7%9A%84%E6%9C%AC%E8%B4%A8-%E6%A2%81%E6%95%AC%E5%BD%AC/dp/B071S6ZYH8/ref=sr_1_1?s=books&ie=UTF8&qid=1510300270&sr=1-1&keywords=%E4%B8%8D%E6%AD%A2+sql)》
*   《[SQL Server 性能优化与管理的艺术](https://www.amazon.cn/SQL-Server%E6%80%A7%E8%83%BD%E4%BC%98%E5%8C%96%E4%B8%8E%E7%AE%A1%E7%90%86%E7%9A%84%E8%89%BA%E6%9C%AF-%E9%BB%84%E9%92%8A%E5%90%89/dp/B00NW2FVAM/ref=tmm_pap_swatch_0?_encoding=UTF8&qid=1510300294&sr=1-8)》
*   《[SQL Server性能调优实战](https://www.amazon.cn/SQL-Server%E6%80%A7%E8%83%BD%E8%B0%83%E4%BC%98%E5%AE%9E%E6%88%98-%E9%99%88%E7%95%85%E4%BA%AE/dp/B0171JJEN6/ref=sr_1_11?s=books&ie=UTF8&qid=1510300294&sr=1-11&keywords=sql+server)》
*   《[T-SQL性能调优秘笈:基于SQL Server 2012窗口函数](https://www.amazon.cn/T-SQL%E6%80%A7%E8%83%BD%E8%B0%83%E4%BC%98%E7%A7%98%E7%AC%88-%E5%9F%BA%E4%BA%8ESQL-Server-2012%E7%AA%97%E5%8F%A3%E5%87%BD%E6%95%B0-%E6%9C%AC-%E7%94%98/dp/B00M1CH5A8/ref=sr_1_14?s=books&ie=UTF8&qid=1510300294&sr=1-14&keywords=sql+server)》

## 测试

*   《[探索式软件测试](https://www.amazon.cn/gp/product/B003JBIV0S/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B003JBIV0S&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[有效的单元测试](https://www.amazon.cn/gp/product/B00PVOND2W/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00PVOND2W&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[Google软件测试之道](https://www.amazon.cn/gp/product/B00FH36R6G/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00FH36R6G&amp;linkCode=as2&amp;tag=vastwork-23)》

## 项目与团队

*   《[人月神话](https://www.amazon.cn/gp/product/B00VR8ZO28/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00VR8ZO28&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[快速软件开发](https://www.amazon.cn/gp/product/B001DBRWL0/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B001DBRWL0&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[人件（原书第3版）](https://www.amazon.cn/gp/product/B00MO7R1SG/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00MO7R1SG&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[门后的秘密：卓越管理的故事](https://www.amazon.cn/gp/product/B00CBBKRQ8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00CBBKRQ8&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[极客与团队：软件工程师的团队生存秘笈](https://www.amazon.cn/gp/product/B00BLZMG8W/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00BLZMG8W&amp;linkCode=as2&amp;tag=vastwork-23)》
* 《[硝烟中的 Scrum 和 XP](https://amazon.cn/gp/product/B00EE5HBAO/ref=as_li_qf_asin_il_tl?ie=UTF8&tag=vastwork-23&creative=3200&linkCode=as2&creativeASIN=B00EE5HBAO&linkId=d904f054b7a79a701065f544a449512b)》 (感谢[@geekgao](https://github.com/geekgao) 的推荐。

## 求职面试

*   《[程序员面试金典（第5版）](https://www.amazon.cn/gp/product/B00G8VOQOG/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00G8VOQOG&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[编程之美 : 微软技术面试心得](https://www.amazon.cn/gp/product/B00W5269HO/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00W5269HO&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[金领简历：敲开苹果、微软、谷歌的大门](https://www.amazon.cn/gp/product/B00ALPRM7S/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00ALPRM7S&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[剑指Offer：名企面试官精讲典型编程题（纪念版）](https://www.amazon.cn/gp/product/B00L5LKMVU/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00L5LKMVU&amp;linkCode=as2&amp;tag=vastwork-23)》

## 编程之外

*   《[暗时间](https://www.amazon.cn/gp/product/B005DSK4W8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B005DSK4W8&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[数学之美](https://www.amazon.cn/gp/product/B00P6OJ09C/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00P6OJ09C&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[赢得朋友](https://www.amazon.cn/gp/product/B00ANY9KZE/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00ANY9KZE&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[精益创业](https://www.amazon.cn/gp/product/B008MIFWJG/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B008MIFWJG&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[批判性思维](https://www.amazon.cn/gp/product/B00QPZARMA/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00QPZARMA&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[世界是数字的](https://www.amazon.cn/gp/product/B00M2DKZNA/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00M2DKZNA&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[程序员的数学](https://www.amazon.cn/gp/product/B00A4H3JJS/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00A4H3JJS&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[程序员健康指南](https://www.amazon.cn/gp/product/B00N4LZ6RO/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00N4LZ6RO&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[禅与摩托车维修艺术](https://www.amazon.cn/gp/product/B005O4PUFC/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B005O4PUFC&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[关键对话：如何高效能沟通](https://www.amazon.cn/gp/product/B0081M8TZ2/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B0081M8TZ2&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[写作法宝：非虚构写作指南](https://www.amazon.cn/gp/product/B00EY8JUBO/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00EY8JUBO&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[黑客与画家 : 来自计算机时代的高见](https://www.amazon.cn/gp/product/B00G1ZT2C0/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00G1ZT2C0&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[软件随想录（卷1）](https://www.amazon.cn/gp/product/B00WDTQU8M/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00WDTQU8M&amp;linkCode=as2&amp;tag=vastwork-23)》《[软件随想录（卷2）](https://www.amazon.cn/gp/product/B00WFT32FY/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00WFT32FY&amp;linkCode=as2&amp;tag=vastwork-23)》
*   《[如何把事情做到最好：改变全球9800万人的人生指导书](https://www.amazon.cn/gp/product/B00ICWNKT6/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&amp;camp=536&amp;creative=3200&amp;creativeASIN=B00ICWNKT6&amp;linkCode=as2&amp;tag=vastwork-23)》
