# [随手记](https://github.com/platojobs/SFLOG/issues/84)

```swift
func statusbar_height() -> CGFloat {
    
    var statusbarheight: CGFloat = 0
    
    if #available(iOS 13.0, *){
        
        let window = UIApplication.shared.connectedScenes.map({$0 as? UIWindowScene}).compactMap({ $0 }).first?.windows.first
        
        let statusbar = window?.windowScene?.statusBarManager?.statusBarFrame
        
        return statusbar?.size.height ?? 20.0
        
    }else{
        statusbarheight = UIApplication.shared.statusBarFrame.size.height
    }
    return statusbarheight
}

```

---

```swift
//获取状态栏高度的另一种形式
extension UIApplication {
    static var statusBarHeight: CGFloat {
        var statusHeight : CGFloat = 0
        if #available(iOS 13.0, *) {
            let window = shared.connectedScenes.map({$0 as? UIWindowScene}).compactMap({ $0 }).first?.windows.first
            
            statusHeight = window?.windowScene?.statusBarManager?.statusBarFrame.height ?? 0
        }else{
            statusHeight = shared.statusBarFrame.height
        }

        return statusHeight
    }
}
```