# [54: swift的函数](https://github.com/platojobs/SFLOG/issues/58)

swift的函数

---

```swift

//可变参数
func sum(_ numbers: Int...) -> Int {
    var sum = 0
    for number in numbers{
        sum += number
    }
    return sum
}
sum(10,20,30)
//一个函数最多只能有1个可变参数
//紧跟在可变参数后面的参数不能省略参数标签
//参数nstring不能省略标签
func test(_ numbers: Int..., nstring: String, _ other: String){}
test(10, 20, 30, string: "jack", "aaa")

//输入输出参数

func swapValues(_ v1: inout Int, _ v2: inout Int){
    (v1, v2) = (v2, v1)
}
var a = 10
var b = 20
swapValues(&a, &b)

//可变参数不能标记为inout
//inout参数不能有默认值
//inout参数只能传入可以被多次赋值的
//inout参数的本质是地址传递
//返回值是函数类型的函数，叫做高阶函数
```