# [19云：iOS 13.0以后presentViewController](https://github.com/platojobs/SFLOG/issues/19)

### 第一：基础的`Present View Controller `解析

一、主要用途

弹出模态`ViewController`是`iOS`变成中很有用的一个技术，UIKit提供的一些专门用于模态显示的`ViewController`，如`UIImagePickerController`等。弹出模态`ViewController`主要使用于一下这几种情形：

+ 1、收集用户输入信息

+ 2、临时呈现一些内容

+ 3、临时改变工作模式

+ 4、相应设备方向变化（用于针对不同方向分别是想两个ViewController的情况）

+ 5、显示一个新的`view`层级

这几种情形都会暂时中断程序正常的执行流程，主要作用是收集或者显示一些信息。

### 二、几个概念和常用设置

#### 1、`presenting view controller `Vs `presented view controller`

当我们在`view controller A`中模态显示`view controller B`的时候，A就充当`presenting view controller`（弹出`VC`），而B就是`presented view controller`（被弹出`VC`）。官方文档建议这两者之间通过`delegate`实现交互，如果使用过`UIImagePickerController`从系统相册选取照片或者拍照，我们可以发现`imagePickerController`和弹出它的`VC`之间就是通过`UIImagePickerControllerDelegate`实现交互的。因此我们在实际应用用，最好也遵守这个原则，在被弹出的VC中定义`delegate`，然后在弹出`VC`中实现该代理，这样就可以比较方便的实现两者之间的交互。

#### 2、`Modal Presentation Styles`（弹出风格）

通过设置`presented VC`的`modalPresentationStyle`属性，我们可以设置弹出View Controller时的风格，有以下四种风格，其定义如下：
```objc
typedef enum {

UIModalPresentationFullScreen = 0,

UIModalPresentationPageSheet,

UIModalPresentationFormSheet,

UIModalPresentationCurrentContext,

} UIModalPresentationStyle;

```
`UIModalPresentationFullScreen`代表弹出`VC`时，`presented VC`充满全屏，如果弹出VC的`wantsFullScreenLayout`设置为`YES`的，则会填充到状态栏下边，否则不会填充到状态栏之下。

`UIModalPresentationPageSheet`代表弹出是弹出VC时，presented VC的高度和当前屏幕高度相同，宽度和竖屏模式下屏幕宽度相同，剩余未覆盖区域将会变暗并阻止用户点击，这种弹出模式下，竖屏时跟UIModalPresentationFullScreen的效果一样，横屏时候两边则会留下变暗的区域。

`UIModalPresentationFormSheet`这种模式下，presented VC的高度和宽度均会小于屏幕尺寸，presented VC居中显示，四周留下变暗区域。

`UIModalPresentationCurrentContext`这种模式下，presented VC的弹出方式和presenting VC的父VC的方式相同。

这四种方式在`iPad上`面统统有效，但在`iPhone`和`iPod touch`上面系统始终已`UIModalPresentationFullScreen`模式显示presented VC。

#### 3、`Modal Transition Style`（弹出时的动画风格）

通过设置设置presented VC的`modalTransitionStyle`属性，我们可以设置弹出`presented VC`时场景切换动画的风格，其定义如下：
```objc
typedef enum {

UIModalTransitionStyleCoverVertical = 0,

UIModalTransitionStyleFlipHorizontal,

UIModalTransitionStyleCrossDissolve,

UIModalTransitionStylePartialCurl,

} UIModalTransitionStyle;
```

我们可以看到有从底部滑入，水平翻转进入，交叉溶解以及翻页这四种风格可选。这四种风格在不受设备的限制，即不管是iPhone还是iPad都会根据我们指定的风格显示转场效果。

#### 4、`Dismiss Modal ViewController`（消失弹出的VC）

消失`presented VC`，我们可以通过调用以下两个函数中的任何一个来完成
```objc
dismissModalViewControllerAnimated:                // 将要废弃，不赞成继续使用

dismissViewControllerAnimated:completion:
```
谁来调用这消失presented VC的这个方法：正确的做法是`“谁污染谁治理”`，即`presenting VC`调用上面的方法来取消`presented VC`的显示。这样做有一个好处，如果一个VC真不用户做的不同选择可能弹出不同的`view controller`，当不再需要显示被弹出的`view controller`的时候，直接调用`[self dismissModalViewControllerAnimated]`即可使之消失，而不用去关心其具体显示的哪一类view controller。当然系统在这里做了优化，当我们在presented VC里面调用上面的方法的时候，系统会自动的将这个消息传递到相应的presenting VC中，这样就可以实现不管谁弹出了自己，当不再需要的时候直接将自己消失掉的功能。在应用中具体要采用那种要看具体情况，如果presented VC需要和presenting VC有数据传递的话，建议在presenting VC实现的代理函数中dismiss弹出的view controller。

`presentModalViewController`支持5.0，而`presentViewController`支持5.0以下

你可以
```objc
if (SYSTEM_VERSION_LESS_THAN(@"5.0")) {

[self presentModalViewController:self.childVC animated:YES];

} else {

[self presentViewController:self.childVC animated:YES completion:nil];

}
```
或直接使用
```objc
[self presentViewController:self.childVC animated:YES completion:nil];
```
来解决兼容性问题

##### 第二：高级自定义`Present View Controller  `解析

我们在使用View跳转的过程中，想使用各种各样的特效，例如：翻页、立方体等特效，我们就可以使用一下几种方法，实现自己想要的动态的效果。

`presentModalViewController:animated:completion:`使用系统自带四种动画

简单的实现方式：
```objc
[page2Controller setModalTransitionStyle:UIModalTransitionStyleFlipHorizontal];

[self presentModalViewController:myNextViewController animated:YES  completion:nil];
```
系统支持的四种动画：
```objc
typedef enum {

UIModalTransitionStyleCoverVertical=0, //默认方式，竖向上推

UIModalTransitionStyleFlipHorizontal, //水平反转

UIModalTransitionStyleCrossDissolve,//隐出隐现

UIModalTransitionStylePartialCurl,//部分翻页效果

} UIModalTransitionStyle;
```
`presentModalViewController:animated:completion: `不用自带的四种动画效果

以下是我们高级自定义的动画效果：

实现全翻页效果：
```objc
CATransition *animation = [CATransition animation];

animation.duration = 1.0;

animation.timingFunction = UIViewAnimationCurveEaseInOut;

animation.type = @"pageCurl";

//animation.type = kCATransitionPush;

animation.subtype = kCATransitionFromLeft;

[self.view.window.layer addAnimation:animation forKey:nil];

[self presentModalViewController:myNextViewController animated:NO completion:nil];

常見的轉換類型（type）：

kCATransitionFade              //淡出

kCATransitionMoveIn          //覆盖原图

kCATransitionPush              //推出

kCATransitionReveal          //底部显出来

SubType:

kCATransitionFromRight

kCATransitionFromLeft    // 默认值

kCATransitionFromTop

kCATransitionFromBottom

设置其他动画类型的方法(type):

pageCurl  向上翻一页

pageUnCurl 向下翻一页

rippleEffect 滴水效果

suckEffect 收缩效果，如一块布被抽走

cube 立方体效果

oglFlip 上下翻转效果
```
总之，我们使用这些静态的`ViewController`过程中，实现更多的动画效果，就需要深入了解它的底层，了解更深入的IOS底层内容。



在`iOS13`中使用`presentViewController`的时候，页面顶部会空出一部分来，并且可以手动往下滑动关闭界面。

原因：`UIViewController`的一个属性modalPresentationStyle

在iOS13中，`modalPresentationStyle`的默认值是`UIModalPresentationAutomatic`，而在iOS12以下的版本，默认值是`UIModalPresentationFullScreen`，这就导致了在iOS13中present出来的页面没法全屏。因此加上代码：
```objc
XXXX.modalPresentationStyle = UIModalPresentationFullScreen;
```
显示正常。

