# [18云：git命令](https://github.com/platojobs/SFLOG/issues/18)

### 1 说明
> 本文主要记录日常工作中，git使用过程中的常用命令。后续会持续更新完善。

### 2 环境配置

#### 2.1 参数配置

>` git客户端`安装完毕后，需要进行变量配置。主要配置`user.name`和`user.email`两个属性，用来标识`git`操作者的身份。

（1）查看全局所有配置
```java
git config --global --list
```
（2）查看全局某个属性配置
```
git config --global user.name
git config --global user.email
```
（3）设置全局属性
```
git config --global user.name "xxx"
git config --global user.email "xxx@126.com"
```
（4）删除某个全局配置
```
git config --global --unset user.name
```
（5）打开全局参数配置文件
```
git config --global --edit
```
此命令会打开一个文件，可直接更改文件中的参数。

（6）默认文件打开方式还原

如配置文件打开方式，更改为本地软件后，想更改为原来的打开方式，可以执行如下命令：
```
git config --global core.editor vi
```
#### 2.2 访问远程仓库

访问远程仓库，一般会直接执行`clone`命令。如下：
```
git clone https://gitee.com/xxx/mytest.git
```
初次访问git仓库，会弹出提示框要求输入git服务器的用户名密码。如多次输入失败，会提示
```
remote: xxx@126.com: Incorrect username or password (access token)
fatal: Authentication failed for 'https://gitee.com/xxx/mytest.git/'
```
这种情况需要清空windows凭据（控制面板->凭据管理器），输入正确的用户名密码

### 3 常用命令

#### 3.1 分支开发

#### 3.1.1 克隆远程分支
```
# 克隆远程分支到本地
git clone https://gitee.com/xxx/mytest.git
```
#### 3.1.2 创建新分支

（1）根据当前分支创建本地分支，并切换到此分支
```
git checkout -b dev1
```
（2）更改代码后，提交到本地仓库
```
# 更改代码......

# 所有"新增"文件和"删除"文件加入到暂存区【建议】
git add -A

# 提交到本地仓库
git commit -m "read me"
```
3）推送到远程仓库

新拉取的分支，第一次推送到远程仓库时，需指定远程仓库的名称并创建关联关系，有如下两种方式：

+ ` push`命令
```
# 推送到远程新分支+创建本地和远程分支的关联关系
git push -u origin dev1
```
+  `push`命令+`branch`命令
```
# 推送当前分支到远程新分支
git push origin dev1

# 当前分支和推送到的远程分支，创建关联关系
 git branch --set-upstream-to=origin/dev1
```
创建远程分支，创建关联关系后，之后再推送代码，如无特殊要求，推送时，无需再指定远程分支，推送时直接执行如下命令：
```
git push
```
查看远程分支和本地分支对应关系命令如下:
```
git branch -vv
```
输出内容如下，中括号内为远程分支名称：
```
$ git branch -vv
  dev1   c1715e4 [origin/dev1] read me
```

#### 3.2 查看命令

##### 3.2.1 远程操作

（1）查看当前分支对应的远程地址
```
git remote -v
```
输出内容如下，可以查看分支对应的远程地址：
```
$ git remote -v
origin  https://gitee.com/xxx/mytest.git (fetch)
origin  https://gitee.com/xxx/mytest.git (push)
```

##### 3.2.2 分支相关

（1）查看分支
```
# 查看本地分支
git branch

# 查看远程分支
git branch -r

# 查看所有分支
git branch -a

# 查看远程分支和本地分支对应关系
git branch -vv

```

（2）切换本地分支
```
git checkout xxx
```
用法如下：
```
# 切换到本地master分支
git checkout master

# 切换到本地feature/dev1分支
git checkout feature/dev1
```
##### 3.2.3 日志相关

```
# 单行+ 图形化方式查看日志【建议】
git log --graph --oneline

# 查看日志
git log 

# 单行查看日志
git log --oneline

# 图形化方式查看日志
git log --graph
```

#### 3.3 撤销变更

##### 3.3.1 撤销工作区变更

未使用`git add`时

受版本控制的文件，变更后进行撤销

```
# 放弃某个文件更改（受版本控制的文件，进行变更）
git checkout xx

# 放弃所有工作区文件更改（受版本控制的文件，进行变更）
git checkout .

```
不收版本控制的文件，进行撤销
```
# 删除未被跟踪的目录和文件
git clean -fd
```
##### 3.3.2 撤销暂存区变更

已使用`git add`，未使用`git commit`。只撤销到工作区，如需从工作区撤销，仍然需要继续撤销


```
# 恢复某个“暂存文件”到“工作区”
git reset HEAD XXX

# 恢复所有“暂存文件”到“工作区”
git reset HEAD .
```
##### 3.3.3 撤销本地仓库变更

已执行`git commit`，未执行`git push`
```
# 撤销“本地仓库”
git reset --soft 5f7024f

# 撤销“本地仓库”+“暂存区”
git reset --mixed 5f7024f

```
##### 3.3.4 撤销远程仓库变更

已push到远程仓库的记录，进行撤销

（1）不生成撤销记录
```
# 重置到某个分支
git reset --hard 重置到的镜像ID

# 强推到远程（可能会收到分支保护限制）
 git push --force origin master 
```
强推后远程日志，不再存在之前强推前的日志，如需要还原到强推前的内容，可借助reflog日志进行回滚
```
# 查看操作日志reflog
git reflog

# 回滚到指定分支目录
git reset --hard 7167ac9
# 推送到远程分支
git push origin master
```
reflog如下
```
241323f (HEAD -> master, origin/master) HEAD@{0}: reset: moving to 241323f
7167ac9 HEAD@{1}: commit: xxx--new
```
（2）生成撤销记录
```
# 撤掉某次提交
git revert --no-edit 需要撤销掉的提交ID

# 提交
git push origin master
```
#### 3.4 合并分支

##### 3.4.1 合并

（1）`pull`合并

`pull`命令等于`fetch+merage`，建议此种方式：
```
# 合并远程分支
git pull origin dev1 --no-edit

# 推送到远程分支
git push
```
不加`--no-edit`参数，会打开一个编辑器，可以更改合并的提交信息：

**（2）merge合并 **
```
git merge origin/dev00
```
##### 3.4.2 处理冲突

（1）查看冲突文件，进行冲突处理

合并分支的时候，经常会出现有冲突的情况，可通过`git status`查看当前合并情况：
```
$ git status
On branch master
Your branch is up to date with 'origin/master'.

You have unmerged paths.
  (fix conflicts and run "git commit")
  (use "git merge --abort" to abort the merge)

Unmerged paths:
  (use "git add <file>..." to mark resolution)

        both modified:   ReadMe

no changes added to commit (use "git add" and/or "git commit -a")
```
此种情况，需要通过内置编辑器或外置编辑器（如idea或vscode等），对冲突的文件进行处理：

（2）标记文件已处理

处理完毕冲突后，执行如下命令
```
# 处理冲突后，标记文件已经处理
git add .
git add -A
git add <file>...
```
之后查看`git status`，结果如下：
```
$ git status
On branch master
Your branch is up to date with 'origin/master'.

All conflicts fixed but you are still merging.
  (use "git commit" to conclude merge)

Changes to be committed:

        modified:   ReadMe
```
（3）提交合并

提交合并，`commit `后不需要其他参数

```
git commit
```
默认情况下，会弹出编辑框，提示可更改此次合并的提交日志，如下：

> 如不想更改合并日志信息，直接commit，则可以在命令后增加参数--no-edit。命令如下：
```
git commit --no-edit
```
```
Merge branch 'dev00' of https://gitee.com/xxx/mytest3

# Conflicts:
#       ReadMe
#
# It looks like you may be committing a merge.
# If this is not correct, please remove the file
#       .git/MERGE_HEAD
# and try again.


# Please enter the commit message for your changes. Lines starting
# with '#' will be ignored, and an empty message aborts the commit.
#
# On branch master
# Your branch is up to date with 'origin/master'.
#
# All conflicts fixed but you are still merging.
#
# Changes to be committed:
#       modified:   ReadMe
#
```
更改完毕（或不更改）后，关闭此文件即可，关闭文件后，提示如下内容：
```
$ git commit
[master 2339e32] Merge branch 'dev00' of https://gitee.com/xxx/mytest3
```
代表已经合并完毕。

（4）推送到远程分支

此时已经合并完毕，推送到远程分支即可：
```
git push
```
#### 3.5 `rebase`命令

待完善。。。。。。

#### 4 其他命令
##### 4.1 加入到缓存区
```
# 所有"新增"文件和"删除"文件加入到暂存区【建议】
git add -A

# 所有“新增”文件加入到暂存区
git add .

# “指定”文件加入到暂存区
git add xxx xxx
```
#### 4.2` pull+rebase`

`git pull`的默认行为是`git fetch + git merge`

`git pull --rebase`则是`git fetch + git rebase`

#### 4.3 提交后补充提交

本地`commit`后，将新提交的，合并到上次提交中
```
# 提示打开更改的文件
git commit --amend

# 不提示打开更改的文件
git commit --amend --no-edit
```
提交后对应的原日志的日志id，会发生变动。建议本地仓库未推送到远程分支时，使用此种合并提交的方式。

#### 4.4 去除`rebase`状态
（1）放弃当前`rebase`操作
```
git rebase --abort
```
（2）继续`rebase`

如果冲突已经解决，先`add`冲突文件，之后 `git rebase --continue`
```
git rebase --continue
```
