# [17云：安装包瘦身](https://github.com/platojobs/SFLOG/issues/17)

### **1.常规瘦身方案**
##### 1.压缩资源

>项目中资源包括图片、字符串、音视频等资源。由于项目中图片比较多，所以资源压缩一般会从图片入手。在把图片加入到项目中时候需要采用tinypng或者ImageOptim对图片进行压缩；另外，可以通知设计，对切图进行压缩处理再上传；不需要内嵌到项目中的图片可以改为动态下载。

+ png，jpg，gif可以替换成webp
+ 动画图片可替换为lotties、APNG
+ 小图或表情图可替换为iconFont
+ 大图可替换为svg


 ##### 2.删除无用/重复资源

删除无用的资源。项目中主要以删除图片为主：

+ 图片用2x和3x图就可以，不要用1x图。
+ 可以用`LSUnusedResources`搜索出未使用的图片然后删除之。
`注意：该软件搜索出来的图片有可能项目中还在用，删除之前需要在工程中先搜索下图片是否有使用再确认是否可以删除。`

##### 3.删除无用代码

删除无用类和库：可以用`WBBladesForMac`来分析，注意：通过字符串调用的类也会检测为无用类。


### **2.非常规瘦身方案**

#### 1.Strip ：去除不必要的符号信息。
`-Strip Linked Product `和 `Strip Swift Symbols` 设置为 `YES`，`Deployment Postprocessing` 设置为 `NO`，发布代码的时候也需要勾选 `Strip Swift Symbols`。

`Strip Debug Symbols During Copy` 和 `Symbols Hidden by Default` 在`release`下设为YES
`Dead Code Stripping` 设置为 `YES`
对于动态库，可用`strip -x [动态库路径] `去除不必要的符号信息

#### 2.Make Strings Read-Only设为YES。

#### 3.Link-Time Optimization（LTO）release下设为 Incremental。WWDC2016介绍编译时会移除没有被调用的方法和代码，优化程序运行效率。
#### 4.开启`BitCode`
+ `watchOS`,`Bitcode`是必选的；
+ 而`Mac OS`是不支持`Bitcode`的。
+ 对于`iOS`，Bitcode是可选的，根据你对APP的要求已经第三方库的事情情况决定是否使用
#### 5.去除异常支持。不能使用@try @catch，包只缩小0.1M，效果不显著。

`Enable C++ Exceptions`和`Enable Objective-C Exceptions`设为NO，`Other C Flags`添加`-fno-exceptions`

#### 6.不生成`debug symbols：`不能生成`dSYM`，效果非常显著。
`Generate debug symbols`选项 `release `设置为`NO`
