# [13云：音频编码格式](https://github.com/platojobs/SFLOG/issues/13)

>我们通常从音乐App（如：酷狗音乐、QQ音乐）听歌时，会看到一首歌需要的存储空间大概是10M左右，对于手机磁盘来说这是可以接受的。但在网络中实时在线传播的话，这个数据量可能就太大了，所以必须对其进行压缩编码。
压缩编码的基本指标之一就是压缩比，压缩比通常小于1（否则就没有必要去做压缩）。

+ 压缩算法

>压缩算法包含无损压缩和有损压缩，常用压缩格式中，用的较多的是有损压缩

*  无损压缩 ：解压后的数据可以完全复原
* 有损压缩：解压后的数据不能完全复原，会丢失一部分信息，压缩比越小，丢失的信息就越多，信号还原后失真就会越大

+ 压缩编码原理

>压缩编码原理实际上是压缩掉冗余信号，冗余信号是指不能被人耳感知到的信号，包含人耳听觉范围之外的音频信号以及被掩蔽掉的音频信号
常用压缩编码格式

1. PCM编码
音频的裸数据格式就是脉冲编码调制(Pulse Code Modulation, PCM)数据，是 按照一定的格式记录采样和量化后的数字数据，描述一段PCM数据需要这几个概念：量化格式(sampleFormat)、采样率(sampleRate)、声道数(channel)
2. WAV编码
WAV编码的一种实现（有多种实现方式，但是都不会进行压缩操作）就是在PCM数据格式的前面加上44字节，分别用来描述PCM的采样率、声道数、数据格式等信息
3. MP3编码
MP3具有不错的压缩比，使用`LAME编码`（MP3编码格式的一种实现）的中高码率的MP3文件，听感上非常接近源WAV文件
特点：音质在128Kbit/s 以上表现还不错，压缩比比较高，大量软件和硬件都支持，兼容性好
使用场合：高比特率下对兼容性有要求的音乐欣赏
4. AAC编码
AAC是新一代的音频有损压缩技术，通过一些附件的编码技术（比如PS、SBR等），衍生出了LC-AAC、HE-AAC、HE-AAC v2三种主要的编码格式。`LC-AAC`是比较传统的AAC，相对而言，其主要应用于中高码率场景的编码（≥ 80Kbit/s） ；HE-AAC(相当于AAC+SBR)主要应用于中低码率场景的编码（≤80Kbit/s)；而`HE-AACv2`（相当于AAC+SBR+PS)主要用于低码率场景的编码（≤48Kbit/s)。大部分编码器都设置为≤48Kbit/s自动启用PS技术，而>48Kbit/s则不加PS，相当于普通的HE-AAC
特点：在小于128Kbit/s的码率下表现优异，并且多用于视频中的音频编码
使用场合：128Kbit/s以下的音频编码，多用于视频中音频轨的编码
5. Ogg
一种非常有潜力的编码，在各种码率下都有比较优秀的表现，尤其在中低码率场景下。Ogg除了音质好之外，Ogg有着非常出色的算法，可以用更小的码率达到更好的音质，128Kbit/s的Ogg比192Kbit/s甚至更高码率的MP3还要出色
特点：可以用比MP3更小的码率实现比MP3更好的音质，高中低码率下均有良好表现
缺点：兼容性不够好，流媒体特性不支持，目前没有美图服务软件的支出，因此基于Ogg的数字广播还无法实现，Ogg目前受支持的情况还不够好，无论是软件上的还是硬件上的支持，都无法和MP3箱体并论
适用场合：语音聊天的音频消息场景
