# 🌱 PlantUML

Generate UML diagrams from textual descriptions.

[![Discord server](https://img.shields.io/discord/1083727021328306236?color=5865F2&logo=discord&logoColor=white)](https://discord.gg/sXhzexAQGh)
[![GitHub Sponsors](https://img.shields.io/github/sponsors/plantuml?logo=github)](https://github.com/sponsors/plantuml/)
[![GitHub Org's stars](https://img.shields.io/github/stars/plantuml)](https://github.com/plantuml/plantuml/stargazers/)
[![GitHub watchers](https://img.shields.io/github/watchers/plantuml/plantuml)](https://github.com/plantuml/plantuml/watchers/)
[![GitHub contributors](https://img.shields.io/github/contributors-anon/plantuml/plantuml?color=blue)](https://github.com/plantuml/plantuml/graphs/contributors)
[![GitHub forks](https://img.shields.io/github/forks/plantuml/plantuml)](https://github.com/plantuml/plantuml/network/)
[![GitHub all releases](https://img.shields.io/sourceforge/dt/plantuml?color=blue)](https://github.com/plantuml/plantuml/releases)

[![Release (latest by date)](https://img.shields.io/github/v/release/plantuml/plantuml)](https://github.com/plantuml/plantuml/releases/latest)
[![Release Date](https://img.shields.io/github/release-date/plantuml/plantuml?color=blue)](https://github.com/plantuml/plantuml/releases/latest)
[![GitHub commits since latest release (by date)](https://img.shields.io/github/commits-since/plantuml/plantuml/latest)](https://github.com/plantuml/plantuml/commits/)
[![javadoc](https://javadoc.io/badge2/net.sourceforge.plantuml/plantuml-gplv2/javadoc.svg)](https://javadoc.io/doc/net.sourceforge.plantuml/plantuml-gplv2)

[![Pre-release (latest by date)](https://img.shields.io/github/v/release/plantuml/plantuml?color=chocolate&include_prereleases)](https://github.com/plantuml/plantuml/releases/tag/snapshot)
[![Pre-release Date](https://img.shields.io/github/release-date-pre/plantuml/plantuml?color=chocolate)](https://github.com/plantuml/plantuml/releases/tag/snapshot)
[![GitHub last commit](https://img.shields.io/github/last-commit/plantuml/plantuml?color=chocolate)](https://github.com/plantuml/plantuml/commits/)
[![CI](https://github.com/plantuml/plantuml/actions/workflows/ci.yml/badge.svg?color=chocolate)](https://github.com/plantuml/plantuml/actions/workflows/ci.yml)
[![snapshot javadoc](https://img.shields.io/badge/javadoc-snapshot-chocolate.svg?logo=github)](https://plantuml.github.io/plantuml/)

## ℹ️ About

PlantUML is a component that allows you to create various UML diagrams through simple textual descriptions. From sequence diagrams to deployment diagrams and beyond, PlantUML provides an easy way to create visual representations of complex systems.

### 🗃️ Supported Diagram Types

- 🧩 UML Diagrams
  - [Sequence diagram](http://plantuml.com/sequence-diagram)
  - [Use case diagram](http://plantuml.com/use-case-diagram)
  - [Class diagram](http://plantuml.com/class-diagram)
  - [Object diagram](http://plantuml.com/object-diagram)
  - [Activity diagram](http://plantuml.com/activity-diagram-beta)
    - [Legacy syntax](http://plantuml.com/activity-diagram-legacy)
  - [Component diagram](http://plantuml.com/component-diagram)
  - [Deployment diagram](http://plantuml.com/deployment-diagram)
  - [State diagram](http://plantuml.com/state-diagram)
  - [Timing diagram](http://plantuml.com/timing-diagram)
- 📈 Non-UML Diagrams
  - [JSON data](http://plantuml.com/json)
  - [YAML data](http://plantuml.com/yaml)
  - [EBNF (Extended Backus-Naur Form)](http://plantuml.com/ebnf)
  - [Regex (Regular Expression)](http://plantuml.com/regex)
  - [Network diagram (nwdiag)](http://plantuml.com/nwdiag)
  - [Salt (Wireframe graphical interface or UI Mockups)](http://plantuml.com/salt)
  - [Archimate diagram](http://plantuml.com/archimate-diagram)
  - [SDL (Specification and Description Language)](http://plantuml.com/activity-diagram-beta#sdl)
  - [Ditaa diagram](http://plantuml.com/ditaa)
  - [Gantt diagram](http://plantuml.com/gantt-diagram)
  - [Chronology diagram](http://plantuml.com/chronology-diagram)
  - [MindMap diagram](http://plantuml.com/mindmap-diagram)
  - [WBS (Work Breakdown Structure)](http://plantuml.com/wbs-diagram)
  - [Mathematical Notations (AsciiMath, JLaTeXMath)](http://plantuml.com/ascii-math)
  - Entity Relationship (ER) diagram
    - [Information Engineering (IE) diagram](http://plantuml.com/ie-diagram)
    - [Entity Relationship (ER) diagram (Chen's notation)](http://plantuml.com/er-diagram)

### 📣 Additional Features

- [Hyperlinks and tooltips](http://plantuml.com/link)
- [Rich text (Creole) with emoticons, unicode, and icons](http://plantuml.com/creole)
- [OpenIconic icons](http://plantuml.com/openiconic)
- [Sprite icons](http://plantuml.com/sprite)

### 📖 Learn More

For a more detailed overview, visit [PlantUML Official Website](https://plantuml.com/).

## 🛡 Security

See [Security Policy](SECURITY.md) and [Security overview](https://github.com/plantuml/plantuml/security).

> [!IMPORTANT]
> [PlantUML is **not** affected by the log4j vulnerability.](https://github.com/plantuml/plantuml/issues/826)

## 🚀 Getting Started

Whether you're looking to use PlantUML as a standalone application or as a component in your own project, getting started is simple. Check out the official [PlantUML setup guide](https://plantuml.com/starting) for instructions on how to set up PlantUML on your system.

## ⚙️ Building from Source

To build PlantUML from source, you'll need to have certain prerequisites installed and follow a series of steps outlined in our build guide. Find detailed instructions in our [BUILDING.md](https://github.com/plantuml/plantuml/blob/master/BUILDING.md) file.

## 🧱 Contributing

PlantUML is an open-source project, and we welcome contributions of all kinds. Whether you're helping us fix bugs, improve the docs, or spread the word, we appreciate your support. See our [contributing guide](CONTRIBUTING.md) for more information on how to get started.

For comprehensive and detailed documentation on using PlantUML, refer to the [official Javadoc, available here](https://plantuml.github.io/plantuml/). Please note that this documentation is a work in progress and may not be complete. 

## 🧑‍🤝‍🧑 Support and Community

- [GitHub issues](https://github.com/plantuml/plantuml/issues/)
- [Community Forum](https://forum.plantuml.net/)

## 📃 License

PlantUML is licensed under several licenses; you can choose the one that suits you best:

- [GPL license](https://www.gnu.org/licenses/gpl-3.0.html)
- [LGPL license](https://www.gnu.org/licenses/lgpl-3.0.html)
- [Apache license](https://www.apache.org/licenses/LICENSE-2.0)
- [Eclipse Public license](https://www.eclipse.org/legal/epl-2.0/)
- [MIT license](https://opensource.org/licenses/MIT)

For more information, please refer to the [PlantUML license FAQ](https://plantuml.com/en/faq#ddbc9d04378ee462) to help determine which license is appropriate for your use case.

