<def>LAA1001</def>: SystemRandomBreaksActionDeterminism
=======================================================

Since random values derived from local system's seeds break `IAction`'s
determinism, `IActionContext.Random` property should be used instead.


Examples
--------

The following code is warned by the rule LAA1001:

~~~~ csharp
public IAccountStateDelta Execute(IActionContext context)
{
    var states = context.PreviousState;
    System.Random random = new System.Random();  // LAA1001
    states.SetState(_targetAddress, (Bencodex.Types.Integer)random.Next());
    return states;
}
~~~~

This can be addressed like below:

~~~~ csharp
public IAccountStateDelta Execute(IActionContext context)
{
    var states = context.PreviousState;
    IRandom random = context.Random;  // Fixed
    states.SetState(_targetAddress, (Bencodex.Types.Integer)random.Next());
    return states;
}
~~~~
