using System.IO;
using System.Threading.Tasks;
using Libplanet.Stun.Messages;
using Xunit;

namespace Libplanet.Stun.Tests.Messages
{
    public class RefreshSuccessResponseTest
    {
        [Fact]
        public async Task ParseBytes()
        {
            var bytes = new byte[]
            {
                0x01, 0x04, 0x00, 0x30, 0x21, 0x12, 0xa4, 0x42, 0xaf, 0x9d,
                0x6b, 0xa5, 0x71, 0x17, 0xd7, 0xf2, 0x0a, 0x3a, 0x94, 0x7b,
                0x00, 0x0d, 0x00, 0x04, 0x00, 0x00, 0x03, 0x09, 0x80, 0x22,
                0x00, 0x1a, 0x43, 0x6f, 0x74, 0x75, 0x72, 0x6e, 0x2d, 0x34,
                0x2e, 0x35, 0x2e, 0x30, 0x2e, 0x38, 0x20, 0x27, 0x64, 0x61,
                0x6e, 0x20, 0x45, 0x69, 0x64, 0x65, 0x72, 0x27, 0x74, 0x75,
                0x80, 0x28, 0x00, 0x04, 0xa9, 0x72, 0xb1, 0xa3,
            };

            using (var stream = new MemoryStream(bytes))
            {
                var response =
                    (RefreshSuccessResponse)await StunMessage.ParseAsync(stream);
                Assert.Equal(
                    new byte[]
                    {
                        0xaf, 0x9d, 0x6b, 0xa5, 0x71, 0x17, 0xd7, 0xf2, 0x0a, 0x3a,
                        0x94, 0x7b,
                    },
                    response.TransactionId);
                Assert.Equal(777, response.Lifetime);
            }
        }
    }
}
