using System.Net;
using Libplanet.Stun.Messages;
using Xunit;

namespace Libplanet.Stun.Tests.Messages
{
    public class CreatePermissionRequestTest
    {
        [Fact]
        public void EncodeToBytes()
        {
            var request = new CreatePermissionRequest(
                new IPEndPoint(IPAddress.Parse("54.65.63.212"), 37005)
            )
            {
                TransactionId = new byte[]
                {
                    0xf8, 0x57, 0xe3, 0x50, 0x4c, 0x8f, 0xd3, 0x9d, 0xb8, 0xca,
                    0x69, 0x83,
                },
            };
            var ctx = new TestStunContext()
            {
                Username = "ae0633cd58ba097a1167c6d2cc4e236db52256a40d565f11edf76c02d13db93c",
                Password = "U/X7qP2MosBElz8/T2CESYkvqyUIOoGTlOJoSsHvZkQ=",
                Realm = "twilio.com",
                Nonce = new byte[]
                {
                    0x64, 0x32, 0x34, 0x35, 0x39, 0x35, 0x35, 0x39, 0x61, 0x33,
                    0x38, 0x37, 0x34, 0x63, 0x39, 0x61,
                },
            };

            Assert.Equal(
                new byte[]
                {
                    0x00, 0x08, 0x00, 0x94, 0x21, 0x12, 0xa4, 0x42, 0xf8, 0x57,
                    0xe3, 0x50, 0x4c, 0x8f, 0xd3, 0x9d, 0xb8, 0xca, 0x69, 0x83,
                    0x00, 0x12, 0x00, 0x08, 0x00, 0x01, 0xb1, 0x9f, 0x17, 0x53,
                    0x9b, 0x96, 0x00, 0x06, 0x00, 0x40, 0x61, 0x65, 0x30, 0x36,
                    0x33, 0x33, 0x63, 0x64, 0x35, 0x38, 0x62, 0x61, 0x30, 0x39,
                    0x37, 0x61, 0x31, 0x31, 0x36, 0x37, 0x63, 0x36, 0x64, 0x32,
                    0x63, 0x63, 0x34, 0x65, 0x32, 0x33, 0x36, 0x64, 0x62, 0x35,
                    0x32, 0x32, 0x35, 0x36, 0x61, 0x34, 0x30, 0x64, 0x35, 0x36,
                    0x35, 0x66, 0x31, 0x31, 0x65, 0x64, 0x66, 0x37, 0x36, 0x63,
                    0x30, 0x32, 0x64, 0x31, 0x33, 0x64, 0x62, 0x39, 0x33, 0x63,
                    0x00, 0x15, 0x00, 0x10, 0x64, 0x32, 0x34, 0x35, 0x39, 0x35,
                    0x35, 0x39, 0x61, 0x33, 0x38, 0x37, 0x34, 0x63, 0x39, 0x61,
                    0x00, 0x14, 0x00, 0x0a, 0x74, 0x77, 0x69, 0x6c, 0x69, 0x6f,
                    0x2e, 0x63, 0x6f, 0x6d, 0x00, 0x00, 0x00, 0x08, 0x00, 0x14,
                    0xe9, 0x4a, 0x95, 0x2a, 0x53, 0xb0, 0xdc, 0x8c, 0x3a, 0x42,
                    0xd7, 0xfd, 0x21, 0xeb, 0x0c, 0xd4, 0x2f, 0x6c, 0x8d, 0x40,
                    0x80, 0x28, 0x00, 0x04, 0x31, 0x5b, 0x2f, 0x0e,
                },
                request.Encode(ctx));
        }
    }
}
