using System.IO;
using System.Threading.Tasks;
using Libplanet.Stun.Messages;
using Xunit;

namespace Libplanet.Stun.Tests.Messages
{
    public class ConnectionBindSuccessResponseTest
    {
        [Fact]
        public async Task ParseBytes()
        {
            var bytes = new byte[]
            {
                0x01, 0x0b, 0x00, 0x28, 0x21, 0x12, 0xa4, 0x42, 0x3d, 0x29,
                0x0c, 0x81, 0x83, 0x69, 0xa5, 0x48, 0x36, 0xfa, 0x52, 0x6c,
                0x80, 0x22, 0x00, 0x04, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x08,
                0x00, 0x14, 0xf9, 0xa4, 0x0f, 0x85, 0x74, 0xa1, 0x45, 0x91,
                0xb9, 0x71, 0x12, 0x09, 0x53, 0x15, 0x61, 0xc6, 0x4e, 0xec,
                0x82, 0x07, 0x80, 0x28, 0x00, 0x04, 0xd1, 0xf8, 0x6c, 0xd8,
            };

            using (var stream = new MemoryStream(bytes))
            {
                var response = await StunMessage.ParseAsync(stream);
                Assert.Equal(
                    new byte[]
                    {
                        0x3d, 0x29, 0x0c, 0x81, 0x83, 0x69, 0xa5, 0x48, 0x36, 0xfa,
                        0x52, 0x6c,
                    },
                    response.TransactionId);
                Assert.IsType<ConnectionBindSuccessResponse>(response);
            }
        }
    }
}
