using Libplanet.Stun.Messages;
using Xunit;

namespace Libplanet.Stun.Tests.Messages
{
    public class ConnectionBindRequestTest
    {
        [Fact]
        public void EncodeToBytes()
        {
            var connectionId = new byte[] { 0x1e, 0xe2, 0x38, 0x02 };
            var request = new ConnectionBindRequest(connectionId)
            {
                TransactionId = new byte[]
                {
                    0x3d, 0x29, 0x0c, 0x81, 0x83, 0x69, 0xa5, 0x48, 0x36, 0xfa,
                    0x52, 0x6c,
                },
            };
            var ctx = new TestStunContext()
            {
                Username = "ae0633cd58ba097a1167c6d2cc4e236db52256a40d565f11edf76c02d13db93c",
                Password = "U/X7qP2MosBElz8/T2CESYkvqyUIOoGTlOJoSsHvZkQ=",
                Realm = "twilio.com",
                Nonce = new byte[]
                {
                    0x64, 0x32, 0x34, 0x35, 0x39, 0x35, 0x35, 0x39, 0x61, 0x33,
                    0x38, 0x37, 0x34, 0x63, 0x39, 0x61,
                },
            };

            Assert.Equal(
                new byte[]
                {
                    0x00, 0x0b, 0x00, 0x90, 0x21, 0x12, 0xa4, 0x42, 0x3d, 0x29,
                    0x0c, 0x81, 0x83, 0x69, 0xa5, 0x48, 0x36, 0xfa, 0x52, 0x6c,
                    0x00, 0x2a, 0x00, 0x04, 0x1e, 0xe2, 0x38, 0x02, 0x00, 0x06,
                    0x00, 0x40, 0x61, 0x65, 0x30, 0x36, 0x33, 0x33, 0x63, 0x64,
                    0x35, 0x38, 0x62, 0x61, 0x30, 0x39, 0x37, 0x61, 0x31, 0x31,
                    0x36, 0x37, 0x63, 0x36, 0x64, 0x32, 0x63, 0x63, 0x34, 0x65,
                    0x32, 0x33, 0x36, 0x64, 0x62, 0x35, 0x32, 0x32, 0x35, 0x36,
                    0x61, 0x34, 0x30, 0x64, 0x35, 0x36, 0x35, 0x66, 0x31, 0x31,
                    0x65, 0x64, 0x66, 0x37, 0x36, 0x63, 0x30, 0x32, 0x64, 0x31,
                    0x33, 0x64, 0x62, 0x39, 0x33, 0x63, 0x00, 0x15, 0x00, 0x10,
                    0x64, 0x32, 0x34, 0x35, 0x39, 0x35, 0x35, 0x39, 0x61, 0x33,
                    0x38, 0x37, 0x34, 0x63, 0x39, 0x61, 0x00, 0x14, 0x00, 0x0a,
                    0x74, 0x77, 0x69, 0x6c, 0x69, 0x6f, 0x2e, 0x63, 0x6f, 0x6d,
                    0x00, 0x00, 0x00, 0x08, 0x00, 0x14, 0x5e, 0xc8, 0x5b, 0xaa,
                    0x0c, 0x7e, 0x44, 0x0d, 0xca, 0x22, 0xa6, 0xaa, 0x3a, 0xf7,
                    0x0f, 0x4b, 0x5f, 0xe3, 0x09, 0x63, 0x80, 0x28, 0x00, 0x04,
                    0x22, 0x0e, 0x0e, 0x02,
                },
                request.Encode(ctx));
        }
    }
}
