using System.IO;
using System.Threading.Tasks;
using Libplanet.Stun.Messages;
using Xunit;

namespace Libplanet.Stun.Tests.Messages
{
    public class ConnectionAttemptTest
    {
        [Fact]
        public async Task ParseBytes()
        {
            var bytes = new byte[]
            {
                0x00, 0x1c, 0x00, 0x24, 0x21, 0x12, 0xa4, 0x42, 0x8e, 0x3b,
                0x82, 0x73, 0xda, 0x6f, 0xc3, 0xa9, 0x1e, 0x88, 0x8f, 0x0b,
                0x00, 0x2a, 0x00, 0x04, 0x21, 0x5a, 0x86, 0x01, 0x00, 0x12,
                0x00, 0x08, 0x00, 0x01, 0x60, 0xc6, 0x17, 0x53, 0x9b, 0x96,
                0x80, 0x22, 0x00, 0x04, 0x4e, 0x6f, 0x6e, 0x65, 0x80, 0x28,
                0x00, 0x04, 0x58, 0x07, 0xfb, 0x8e,
            };

            using (var stream = new MemoryStream(bytes))
            {
                var response =
                    (ConnectionAttempt)await StunMessage.ParseAsync(stream);
                Assert.Equal(
                    new byte[] { 0x21, 0x5a, 0x86, 0x01 },
                    response.ConnectionId);
            }
        }
    }
}
