using System.IO;
using System.Net;
using System.Threading.Tasks;
using Libplanet.Stun.Messages;
using Xunit;

namespace Libplanet.Stun.Tests.Messages
{
    public class AllocateSuccessResponseTest
    {
        [Fact]
        public async Task ParseBytes()
        {
            var bytes = new byte[]
            {
                0x01, 0x03, 0x00, 0x48, 0x21, 0x12, 0xa4, 0x42, 0xf5, 0xdb,
                0xe7, 0xc1, 0x2a, 0x74, 0xbe, 0xf9, 0x8b, 0x16, 0x56, 0x3e,
                0x00, 0x16, 0x00, 0x08, 0x00, 0x01, 0xc1, 0x9e, 0x17, 0x53,
                0x9b, 0x96, 0x00, 0x20, 0x00, 0x08, 0x00, 0x01, 0xaa, 0xaa,
                0xf2, 0xa2, 0x25, 0x18, 0x00, 0x0d, 0x00, 0x04, 0x00, 0x00,
                0x03, 0x09, 0x80, 0x22, 0x00, 0x04, 0x4e, 0x6f, 0x6e, 0x65,
                0x00, 0x08, 0x00, 0x14, 0x2b, 0x24, 0xd2, 0x75, 0xb9, 0x91,
                0x34, 0xd6, 0x48, 0x51, 0xc2, 0x15, 0x17, 0xf5, 0x65, 0x90,
                0x98, 0xfa, 0x9f, 0x7d, 0x80, 0x28, 0x00, 0x04, 0x6c, 0xcc,
                0x0c, 0x46,
            };

            using (var stream = new MemoryStream(bytes))
            {
                var response =
                    (AllocateSuccessResponse)await StunMessage.ParseAsync(stream);
                Assert.Equal(
                    new byte[]
                    {
                        0xf5, 0xdb, 0xe7, 0xc1, 0x2a, 0x74, 0xbe, 0xf9, 0x8b, 0x16,
                        0x56, 0x3e,
                    },
                    response.TransactionId);
                Assert.Equal(
                    new IPEndPoint(IPAddress.Parse("54.65.63.212"), 57484),
                    response.RelayedEndPoint);
            }
        }
    }
}
