using Libplanet.Stun.Messages;
using Xunit;

namespace Libplanet.Stun.Tests.Messages
{
    public class AllocateRequestTest
    {
        [Fact]
        public void EncodeToBytes()
        {
            var request = new AllocateRequest(777)
            {
                TransactionId = new byte[]
                {
                    0xee, 0x29, 0xdd, 0x2d, 0x7a, 0xe9, 0x9c, 0xf4, 0x00, 0x82,
                    0xf2, 0x5e,
                },
            };
            Assert.Equal(
                new byte[]
                {
                    0x00, 0x03, 0x00, 0x18, 0x21, 0x12, 0xa4, 0x42, 0xee, 0x29,
                    0xdd, 0x2d, 0x7a, 0xe9, 0x9c, 0xf4, 0x00, 0x82, 0xf2, 0x5e,
                    0x00, 0x19, 0x00, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00, 0x0d,
                    0x00, 0x04, 0x00, 0x00, 0x03, 0x09, 0x80, 0x28, 0x00, 0x04,
                    0x3d, 0xbe, 0x42, 0x75,
                },
                request.Encode(new TestStunContext())
            );
        }

        [Fact]
        public void EncodeToBytesWithCredential()
        {
            var request = new AllocateRequest(777)
            {
                TransactionId = new byte[]
                {
                    0xf5, 0xdb, 0xe7, 0xc1, 0x2a, 0x74, 0xbe, 0xf9, 0x8b, 0x16,
                    0x56, 0x3e,
                },
            };
            var ctx = new TestStunContext()
            {
                Username = "ae0633cd58ba097a1167c6d2cc4e236db52256a40d565f11edf76c02d13db93c",
                Password = "U/X7qP2MosBElz8/T2CESYkvqyUIOoGTlOJoSsHvZkQ=",
                Realm = "twilio.com",
                Nonce = new byte[]
                {
                    0x37, 0x35, 0x64, 0x34, 0x35, 0x34, 0x31, 0x39, 0x63, 0x33,
                    0x39, 0x33, 0x34, 0x33, 0x66, 0x65,
                },
            };

            Assert.Equal(
                new byte[]
                {
                    0x00, 0x03, 0x00, 0x98, 0x21, 0x12, 0xa4, 0x42, 0xf5, 0xdb,
                    0xe7, 0xc1, 0x2a, 0x74, 0xbe, 0xf9, 0x8b, 0x16, 0x56, 0x3e,
                    0x00, 0x19, 0x00, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00, 0x0d,
                    0x00, 0x04, 0x00, 0x00, 0x03, 0x09, 0x00, 0x06, 0x00, 0x40,
                    0x61, 0x65, 0x30, 0x36, 0x33, 0x33, 0x63, 0x64, 0x35, 0x38,
                    0x62, 0x61, 0x30, 0x39, 0x37, 0x61, 0x31, 0x31, 0x36, 0x37,
                    0x63, 0x36, 0x64, 0x32, 0x63, 0x63, 0x34, 0x65, 0x32, 0x33,
                    0x36, 0x64, 0x62, 0x35, 0x32, 0x32, 0x35, 0x36, 0x61, 0x34,
                    0x30, 0x64, 0x35, 0x36, 0x35, 0x66, 0x31, 0x31, 0x65, 0x64,
                    0x66, 0x37, 0x36, 0x63, 0x30, 0x32, 0x64, 0x31, 0x33, 0x64,
                    0x62, 0x39, 0x33, 0x63, 0x00, 0x15, 0x00, 0x10, 0x37, 0x35,
                    0x64, 0x34, 0x35, 0x34, 0x31, 0x39, 0x63, 0x33, 0x39, 0x33,
                    0x34, 0x33, 0x66, 0x65, 0x00, 0x14, 0x00, 0x0a, 0x74, 0x77,
                    0x69, 0x6c, 0x69, 0x6f, 0x2e, 0x63, 0x6f, 0x6d, 0x00, 0x00,
                    0x00, 0x08, 0x00, 0x14, 0x77, 0xe8, 0xcf, 0x30, 0x9e, 0x85,
                    0x6c, 0x22, 0x72, 0x53, 0xa3, 0xb7, 0xe0, 0x35, 0x7c, 0xc2,
                    0x30, 0xfc, 0xbc, 0xf4, 0x80, 0x28, 0x00, 0x04, 0x98, 0x46,
                    0x9c, 0x07,
                },
                request.Encode(ctx));
        }
    }
}
